/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.gap;

import java.io.IOException;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.api.gap.CalledAddressAndService;
import org.mobicents.protocols.ss7.cap.api.isup.Digits;
import org.mobicents.protocols.ss7.cap.isup.DigitsImpl;
import org.mobicents.protocols.ss7.cap.primitives.SequenceBase;

public class CalledAddressAndServiceImpl
extends SequenceBase
implements CalledAddressAndService {
    public static final int _ID_calledAddressValue = 0;
    public static final int _ID_serviceKey = 1;
    private static final String CALLED_ADDRESS_VALUE = "calledAddressValue";
    private static final String SERVICE_KEY = "serviceKey";
    private Digits calledAddressValue;
    private int serviceKey;
    protected static final XMLFormat<CalledAddressAndServiceImpl> CALLED_ADDRESS_AND_SERVICE_XML = new XMLFormat<CalledAddressAndServiceImpl>(CalledAddressAndServiceImpl.class){

        public void read(XMLFormat.InputElement xml, CalledAddressAndServiceImpl calledAddressAndServiceImpl) throws XMLStreamException {
            calledAddressAndServiceImpl.calledAddressValue = (Digits)xml.get(CalledAddressAndServiceImpl.CALLED_ADDRESS_VALUE, DigitsImpl.class);
            calledAddressAndServiceImpl.serviceKey = (Integer)xml.get(CalledAddressAndServiceImpl.SERVICE_KEY, Integer.class);
        }

        public void write(CalledAddressAndServiceImpl calledAddressAndServiceImpl, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.add((Object)((DigitsImpl)calledAddressAndServiceImpl.getCalledAddressValue()), CalledAddressAndServiceImpl.CALLED_ADDRESS_VALUE, DigitsImpl.class);
            xml.add((Object)calledAddressAndServiceImpl.getServiceKey(), CalledAddressAndServiceImpl.SERVICE_KEY, Integer.class);
        }
    };

    public CalledAddressAndServiceImpl() {
        super("CalledAddressAndService");
    }

    public CalledAddressAndServiceImpl(Digits calledAddressValue, int serviceKey) {
        super("CalledAddressAndService");
        this.calledAddressValue = calledAddressValue;
        this.serviceKey = serviceKey;
    }

    public Digits getCalledAddressValue() {
        return this.calledAddressValue;
    }

    public int getServiceKey() {
        return this.serviceKey;
    }

    @Override
    protected void _decode(AsnInputStream ansIS, int length) throws IOException, AsnException, CAPParsingComponentException {
        this.calledAddressValue = null;
        this.serviceKey = 0;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        block4: while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 0: {
                        this.calledAddressValue = new DigitsImpl();
                        ((DigitsImpl)this.calledAddressValue).decodeAll(ais);
                        this.calledAddressValue.setIsGenericNumber();
                        continue block4;
                    }
                    case 1: {
                        if (!ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding InitialDPRequest: Parameter 1 not primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.serviceKey = (int)ais.readInteger();
                        continue block4;
                    }
                }
                ais.advanceElement();
                continue;
            }
            ais.advanceElement();
        }
        if (this.serviceKey == 0) {
            throw new CAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": serviceKey is mandatory", CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws CAPException {
        if (this.calledAddressValue == null) {
            throw new CAPException("Error while encoding " + this._PrimitiveName + ": calledAddressValue must not be null");
        }
        try {
            ((DigitsImpl)this.calledAddressValue).encodeAll(asnOs, 2, 0);
            asnOs.writeInteger(2, 1, (long)this.serviceKey);
        }
        catch (IOException e) {
            throw new CAPException("IOException when encoding " + this._PrimitiveName + ": " + e.getMessage(), (Throwable)e);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding " + this._PrimitiveName + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName);
        sb.append(" [");
        sb.append("calledAddressValue=");
        sb.append(this.calledAddressValue.toString());
        sb.append(", serviceKey=");
        sb.append(this.serviceKey);
        sb.append("]");
        return sb.toString();
    }
}

