/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.gap;

import java.io.IOException;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.api.gap.CallingAddressAndService;
import org.mobicents.protocols.ss7.cap.api.isup.Digits;
import org.mobicents.protocols.ss7.cap.isup.DigitsImpl;
import org.mobicents.protocols.ss7.cap.primitives.SequenceBase;

public class CallingAddressAndServiceImpl
extends SequenceBase
implements CallingAddressAndService {
    public static final int _ID_callingAddressValue = 0;
    public static final int _ID_serviceKey = 1;
    private static final String CALLING_ADDRESS_VALUE = "callingAddressValue";
    private static final String SERVICE_KEY = "serviceKey";
    private Digits callingAddressValue;
    private int serviceKey;
    protected static final XMLFormat<CallingAddressAndServiceImpl> CALLING_ADDRESS_AND_SERVICE_XML = new XMLFormat<CallingAddressAndServiceImpl>(CallingAddressAndServiceImpl.class){

        public void read(XMLFormat.InputElement xml, CallingAddressAndServiceImpl callingAddressAndServiceImpl) throws XMLStreamException {
            callingAddressAndServiceImpl.callingAddressValue = (Digits)xml.get(CallingAddressAndServiceImpl.CALLING_ADDRESS_VALUE, DigitsImpl.class);
            callingAddressAndServiceImpl.serviceKey = (Integer)xml.get(CallingAddressAndServiceImpl.SERVICE_KEY, Integer.class);
        }

        public void write(CallingAddressAndServiceImpl callingAddressAndServiceImpl, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.add((Object)((DigitsImpl)callingAddressAndServiceImpl.getCallingAddressValue()), CallingAddressAndServiceImpl.CALLING_ADDRESS_VALUE, DigitsImpl.class);
            xml.add((Object)callingAddressAndServiceImpl.getServiceKey(), CallingAddressAndServiceImpl.SERVICE_KEY, Integer.class);
        }
    };

    public CallingAddressAndServiceImpl() {
        super("CallingAddressAndService");
    }

    public CallingAddressAndServiceImpl(Digits callingAddressValue, int serviceKey) {
        super("CallingAddressAndService");
        this.callingAddressValue = callingAddressValue;
        this.serviceKey = serviceKey;
    }

    public Digits getCallingAddressValue() {
        return this.callingAddressValue;
    }

    public int getServiceKey() {
        return this.serviceKey;
    }

    @Override
    protected void _decode(AsnInputStream ansIS, int length) throws IOException, AsnException, CAPParsingComponentException {
        this.callingAddressValue = null;
        this.serviceKey = 0;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        block4: while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 0: {
                        this.callingAddressValue = new DigitsImpl();
                        ((DigitsImpl)this.callingAddressValue).decodeAll(ais);
                        this.callingAddressValue.setIsGenericNumber();
                        continue block4;
                    }
                    case 1: {
                        if (!ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding InitialDPRequest: Parameter 1 not primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.serviceKey = (int)ais.readInteger();
                        continue block4;
                    }
                }
                ais.advanceElement();
                continue;
            }
            ais.advanceElement();
        }
        if (this.serviceKey == 0) {
            throw new CAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": serviceKey is mandatory", CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws CAPException {
        if (this.callingAddressValue == null) {
            throw new CAPException("Error while encoding " + this._PrimitiveName + ": callingAddressValue must not be null");
        }
        try {
            ((DigitsImpl)this.callingAddressValue).encodeAll(asnOs, 2, 0);
            asnOs.writeInteger(2, 1, (long)this.serviceKey);
        }
        catch (IOException e) {
            throw new CAPException("IOException when encoding " + this._PrimitiveName + ": " + e.getMessage(), (Throwable)e);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding " + this._PrimitiveName + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName);
        sb.append(" [");
        sb.append("callingAddressValue=");
        sb.append(this.callingAddressValue.toString());
        sb.append(", serviceKey=");
        sb.append(this.serviceKey);
        sb.append("]");
        return sb.toString();
    }
}

