/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.gap;

import java.io.IOException;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.api.gap.GapIndicators;
import org.mobicents.protocols.ss7.cap.primitives.SequenceBase;

public class GapIndicatorsImpl
extends SequenceBase
implements GapIndicators {
    private static final String DURATION = "duration";
    private static final String GAP_INTERVAL = "gapInterval";
    private static final int _ID_Duration = 0;
    private static final int _ID_Gap_Interval = 1;
    private int duration;
    private int gapInterval;
    protected static final XMLFormat<GapIndicatorsImpl> GAP_INDICATORS_XML = new XMLFormat<GapIndicatorsImpl>(GapIndicatorsImpl.class){

        public void read(XMLFormat.InputElement xml, GapIndicatorsImpl gapIndicators) throws XMLStreamException {
            Integer i2;
            Integer i1 = (Integer)xml.get(GapIndicatorsImpl.DURATION, Integer.class);
            if (i1 != null) {
                gapIndicators.duration = i1;
            }
            if ((i2 = (Integer)xml.get(GapIndicatorsImpl.GAP_INTERVAL, Integer.class)) != null) {
                gapIndicators.gapInterval = i2;
            }
        }

        public void write(GapIndicatorsImpl gapIndicators, XMLFormat.OutputElement xml) throws XMLStreamException {
            if (gapIndicators.duration != 0) {
                xml.add((Object)gapIndicators.duration, GapIndicatorsImpl.DURATION, Integer.class);
            }
            if (gapIndicators.gapInterval != 0) {
                xml.add((Object)gapIndicators.gapInterval, GapIndicatorsImpl.GAP_INTERVAL, Integer.class);
            }
        }
    };

    public GapIndicatorsImpl() {
        super("GapIndicators");
    }

    public GapIndicatorsImpl(int duration, int gapInterval) {
        super("GapIndicators");
        this.duration = duration;
        this.gapInterval = gapInterval;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getGapInterval() {
        return this.gapInterval;
    }

    @Override
    protected void _decode(AsnInputStream asnIS, int length) throws CAPParsingComponentException, IOException, AsnException {
        this.duration = 0;
        this.gapInterval = 0;
        AsnInputStream ais = asnIS.readSequenceStreamData(length);
        block4: while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 0: {
                        this.duration = (int)ais.readInteger();
                        if (this.duration >= -2 && this.duration <= 86400) continue block4;
                        throw new CAPParsingComponentException("Error while decoding " + this._PrimitiveName + "-duration: possible value -2..86400, received=" + this.duration, CAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    case 1: {
                        this.gapInterval = (int)ais.readInteger();
                        if (this.gapInterval >= -1 && this.gapInterval <= 60000) continue block4;
                        throw new CAPParsingComponentException("Error while decoding " + this._PrimitiveName + "-gapInterval: possible value -1..60000, received=" + this.gapInterval, CAPParsingComponentExceptionReason.MistypedParameter);
                    }
                }
                ais.advanceElement();
                continue;
            }
            ais.advanceElement();
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws CAPException {
        try {
            if (this.duration != 0) {
                if (this.duration < -2 || this.duration > 86400) {
                    throw new CAPException("Error when encoding " + this._PrimitiveName + ": duration must be -2..86400, supplied=" + this.duration);
                }
                asnOs.writeInteger(2, 0, (long)this.duration);
            }
            if (this.gapInterval != 0) {
                if (this.gapInterval < -1 || this.gapInterval > 60000) {
                    throw new CAPException("Error when encoding " + this._PrimitiveName + ": gapInterval must be -1..60000, supplied=" + this.gapInterval);
                }
                asnOs.writeInteger(2, 1, (long)this.gapInterval);
            }
        }
        catch (IOException e) {
            throw new CAPException("IOException when encoding " + this._PrimitiveName + ": " + e.getMessage(), (Throwable)e);
        }
        catch (AsnException ex) {
            throw new CAPException("AsnException when encoding " + this._PrimitiveName + ": " + ex.getMessage(), (Throwable)ex);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName);
        sb.append(" [");
        if (this.duration != 0) {
            sb.append("duration=[");
            sb.append(this.duration);
            sb.append("]");
        } else if (this.gapInterval != 0) {
            sb.append("gapInterval=[");
            sb.append(this.gapInterval);
            sb.append("]");
        }
        sb.append("]");
        return sb.toString();
    }
}

