/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.primitives;

import java.io.IOException;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.api.primitives.AChChargingAddress;
import org.mobicents.protocols.ss7.cap.primitives.CAPAsnPrimitive;
import org.mobicents.protocols.ss7.inap.api.INAPException;
import org.mobicents.protocols.ss7.inap.api.INAPParsingComponentException;
import org.mobicents.protocols.ss7.inap.api.primitives.LegID;
import org.mobicents.protocols.ss7.inap.primitives.LegIDImpl;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;

public class AChChargingAddressImpl
implements AChChargingAddress,
CAPAsnPrimitive {
    private static final String LEG_ID = "legID";
    private static final String SRF_CONNECTION = "srfConnection";
    public static final int _ID_legID = 2;
    public static final int _ID_srfConnection = 50;
    public static final String _PrimitiveName = "AChChargingAddress";
    private LegID legID;
    private int srfConnection;
    protected static final XMLFormat<AChChargingAddressImpl> A_CH_CHARGING_ADDRESS_XML = new XMLFormat<AChChargingAddressImpl>(AChChargingAddressImpl.class){

        public void read(XMLFormat.InputElement xml, AChChargingAddressImpl aChChargingAddress) throws XMLStreamException {
            aChChargingAddress.legID = (LegID)xml.get(AChChargingAddressImpl.LEG_ID, LegIDImpl.class);
            Integer i1 = (Integer)xml.get(AChChargingAddressImpl.SRF_CONNECTION, Integer.class);
            if (i1 != null) {
                aChChargingAddress.srfConnection = i1;
            }
        }

        public void write(AChChargingAddressImpl aChChargingAddress, XMLFormat.OutputElement xml) throws XMLStreamException {
            if (aChChargingAddress.legID != null) {
                xml.add((Object)((LegIDImpl)aChChargingAddress.legID), AChChargingAddressImpl.LEG_ID, LegIDImpl.class);
            }
            if (aChChargingAddress.srfConnection != 0) {
                xml.add((Object)aChChargingAddress.srfConnection, AChChargingAddressImpl.SRF_CONNECTION, Integer.class);
            }
        }
    };

    public AChChargingAddressImpl() {
    }

    public AChChargingAddressImpl(LegID legID) {
        this.legID = legID;
    }

    public AChChargingAddressImpl(int srfConnection) {
        this.srfConnection = srfConnection;
    }

    public LegID getLegID() {
        return this.legID;
    }

    public int getSrfConnection() {
        return this.srfConnection;
    }

    @Override
    public int getTag() throws CAPException {
        if (this.legID != null) {
            return 2;
        }
        if (this.srfConnection != 0) {
            return 50;
        }
        throw new CAPException("Error while encoding AChChargingAddress: no choice is specified");
    }

    @Override
    public int getTagClass() {
        return 2;
    }

    @Override
    public boolean getIsPrimitive() {
        return this.legID == null;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws CAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding AChChargingAddress: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding AChChargingAddress: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (MAPParsingComponentException e) {
            throw new CAPParsingComponentException("MAPParsingComponentException when decoding AChChargingAddress: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (INAPParsingComponentException e) {
            throw new CAPParsingComponentException("INAPParsingComponentException when decoding AChChargingAddress: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws CAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding AChChargingAddress: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding AChChargingAddress: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (MAPParsingComponentException e) {
            throw new CAPParsingComponentException("MAPParsingComponentException when decoding AChChargingAddress: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (INAPParsingComponentException e) {
            throw new CAPParsingComponentException("INAPParsingComponentException when decoding AChChargingAddress: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ais, int length) throws CAPParsingComponentException, MAPParsingComponentException, INAPParsingComponentException, IOException, AsnException {
        block7: {
            block6: {
                this.legID = null;
                this.srfConnection = 0;
                int tag = ais.getTag();
                if (ais.getTagClass() != 2) break block6;
                switch (tag) {
                    case 2: {
                        if (ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding AChChargingAddress-legID: parameter is primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        AsnInputStream ais2 = ais.readSequenceStreamData(length);
                        ais2.readTag();
                        this.legID = new LegIDImpl();
                        ((LegIDImpl)this.legID).decodeAll(ais2);
                        break;
                    }
                    case 50: {
                        this.srfConnection = (int)ais.readIntegerData(length);
                        if (this.srfConnection < 1 || this.srfConnection > 127) {
                            throw new CAPParsingComponentException("Error while decoding AChChargingAddress-srfConnection: possible value 1..127, received=" + this.srfConnection, CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        break block7;
                    }
                    default: {
                        throw new CAPParsingComponentException("Error while decoding AChChargingAddress: bad choice tag", CAPParsingComponentExceptionReason.MistypedParameter);
                    }
                }
                break block7;
            }
            throw new CAPParsingComponentException("Error while decoding AChChargingAddress: bad choice tagClass", CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws CAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws CAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding AChChargingAddress: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws CAPException {
        try {
            if (this.legID != null) {
                ((LegIDImpl)this.legID).encodeAll(asnOs);
                return;
            }
            if (this.srfConnection != 0) {
                if (this.srfConnection < 1 || this.srfConnection > 127) {
                    throw new CAPException("Error when encoding AChChargingAddress: srfConnection must be 1..127, supplied=" + this.srfConnection);
                }
                asnOs.writeIntegerData((long)this.srfConnection);
                return;
            }
        }
        catch (IOException e) {
            throw new CAPException("IOException when encoding AChChargingAddress: " + e.getMessage(), (Throwable)e);
        }
        catch (INAPException e) {
            throw new CAPException("INAPException when encoding AChChargingAddress: " + e.getMessage(), (Throwable)e);
        }
        throw new CAPException("Error while encoding AChChargingAddress: no choice is specified");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.legID != null) {
            sb.append("legID=[");
            sb.append(this.legID);
            sb.append("]");
        } else if (this.srfConnection != 0) {
            sb.append("srfConnection=[");
            sb.append(this.srfConnection);
            sb.append("]");
        }
        sb.append("]");
        return sb.toString();
    }
}

