/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall;

import java.io.IOException;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPMessageType;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.api.isup.CalledPartyNumberCap;
import org.mobicents.protocols.ss7.cap.api.primitives.CAPExtensions;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.ConnectToResourceRequest;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.primitive.ServiceInteractionIndicatorsTwo;
import org.mobicents.protocols.ss7.cap.isup.CalledPartyNumberCapImpl;
import org.mobicents.protocols.ss7.cap.primitives.CAPExtensionsImpl;
import org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall.CircuitSwitchedCallMessageImpl;
import org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall.primitive.ServiceInteractionIndicatorsTwoImpl;

public class ConnectToResourceRequestImpl
extends CircuitSwitchedCallMessageImpl
implements ConnectToResourceRequest {
    public static final int _ID_resourceAddress_ipRoutingAddress = 0;
    public static final int _ID_resourceAddress_none = 3;
    public static final int _ID_extensions = 4;
    public static final int _ID_serviceInteractionIndicatorsTwo = 7;
    public static final int _ID_callSegmentID = 50;
    public static final String _PrimitiveName = "ConnectToResourceIndication";
    private static final String RESOURCE_ADDRESS_IP_ROUTING_ADDRESS = "resourceAddress_IPRoutingAddress";
    private static final String RESOURCE_ADDRESS_NULL = "resourceAddress_Null";
    private static final String EXTENSIONS = "extensions";
    private static final String SERVICE_INTERACTION_INDICATORS_TWO = "serviceInteractionIndicatorsTwo";
    private static final String CALL_SEGMENT_ID = "callSegmentID";
    private CalledPartyNumberCap resourceAddress_IPRoutingAddress;
    private boolean resourceAddress_Null;
    private CAPExtensions extensions;
    private ServiceInteractionIndicatorsTwo serviceInteractionIndicatorsTwo;
    private Integer callSegmentID;
    protected static final XMLFormat<ConnectToResourceRequestImpl> CONNECT_TO_RESOURCE_REQUEST_XML = new XMLFormat<ConnectToResourceRequestImpl>(ConnectToResourceRequestImpl.class){

        public void read(XMLFormat.InputElement xml, ConnectToResourceRequestImpl connectToResourceRequest) throws XMLStreamException {
            CircuitSwitchedCallMessageImpl.CIRCUIT_SWITCHED_CALL_MESSAGE_XML.read(xml, (Object)connectToResourceRequest);
            int vali = xml.getAttribute(ConnectToResourceRequestImpl.CALL_SEGMENT_ID, -1);
            if (vali != -1) {
                connectToResourceRequest.callSegmentID = vali;
            }
            connectToResourceRequest.resourceAddress_IPRoutingAddress = (CalledPartyNumberCap)xml.get(ConnectToResourceRequestImpl.RESOURCE_ADDRESS_IP_ROUTING_ADDRESS, CalledPartyNumberCapImpl.class);
            Boolean valb = (Boolean)xml.get(ConnectToResourceRequestImpl.RESOURCE_ADDRESS_NULL, Boolean.class);
            if (valb != null) {
                connectToResourceRequest.resourceAddress_Null = valb;
            } else {
                connectToResourceRequest.resourceAddress_Null = false;
            }
            int choiceCount = 0;
            if (connectToResourceRequest.resourceAddress_IPRoutingAddress != null) {
                ++choiceCount;
            }
            if (connectToResourceRequest.resourceAddress_Null) {
                ++choiceCount;
            }
            if (choiceCount != 1) {
                throw new XMLStreamException("ConnectToResourceRequest decoding error: there must be one choice selected, found: " + choiceCount);
            }
            connectToResourceRequest.extensions = (CAPExtensions)xml.get(ConnectToResourceRequestImpl.EXTENSIONS, CAPExtensionsImpl.class);
            connectToResourceRequest.serviceInteractionIndicatorsTwo = (ServiceInteractionIndicatorsTwo)xml.get(ConnectToResourceRequestImpl.SERVICE_INTERACTION_INDICATORS_TWO, ServiceInteractionIndicatorsTwoImpl.class);
        }

        public void write(ConnectToResourceRequestImpl connectToResourceRequest, XMLFormat.OutputElement xml) throws XMLStreamException {
            CircuitSwitchedCallMessageImpl.CIRCUIT_SWITCHED_CALL_MESSAGE_XML.write((Object)connectToResourceRequest, xml);
            if (connectToResourceRequest.callSegmentID != null) {
                xml.setAttribute(ConnectToResourceRequestImpl.CALL_SEGMENT_ID, (Object)connectToResourceRequest.callSegmentID);
            }
            if (connectToResourceRequest.resourceAddress_IPRoutingAddress != null) {
                xml.add((Object)((CalledPartyNumberCapImpl)connectToResourceRequest.resourceAddress_IPRoutingAddress), ConnectToResourceRequestImpl.RESOURCE_ADDRESS_IP_ROUTING_ADDRESS, CalledPartyNumberCapImpl.class);
            }
            if (connectToResourceRequest.resourceAddress_Null) {
                xml.add((Object)connectToResourceRequest.resourceAddress_Null, ConnectToResourceRequestImpl.RESOURCE_ADDRESS_NULL, Boolean.class);
            }
            if (connectToResourceRequest.getExtensions() != null) {
                xml.add((Object)((CAPExtensionsImpl)connectToResourceRequest.getExtensions()), ConnectToResourceRequestImpl.EXTENSIONS, CAPExtensionsImpl.class);
            }
            if (connectToResourceRequest.serviceInteractionIndicatorsTwo != null) {
                xml.add((Object)((ServiceInteractionIndicatorsTwoImpl)connectToResourceRequest.serviceInteractionIndicatorsTwo), ConnectToResourceRequestImpl.SERVICE_INTERACTION_INDICATORS_TWO, ServiceInteractionIndicatorsTwoImpl.class);
            }
        }
    };

    public ConnectToResourceRequestImpl() {
    }

    public ConnectToResourceRequestImpl(CalledPartyNumberCap resourceAddress_IPRoutingAddress, boolean resourceAddress_Null, CAPExtensions extensions, ServiceInteractionIndicatorsTwo serviceInteractionIndicatorsTwo, Integer callSegmentID) {
        this.resourceAddress_IPRoutingAddress = resourceAddress_IPRoutingAddress;
        this.resourceAddress_Null = resourceAddress_Null;
        this.extensions = extensions;
        this.serviceInteractionIndicatorsTwo = serviceInteractionIndicatorsTwo;
        this.callSegmentID = callSegmentID;
    }

    public CAPMessageType getMessageType() {
        return CAPMessageType.connectToResource_Request;
    }

    public int getOperationCode() {
        return 19;
    }

    public CalledPartyNumberCap getResourceAddress_IPRoutingAddress() {
        return this.resourceAddress_IPRoutingAddress;
    }

    public boolean getResourceAddress_Null() {
        return this.resourceAddress_Null;
    }

    public CAPExtensions getExtensions() {
        return this.extensions;
    }

    public ServiceInteractionIndicatorsTwo getServiceInteractionIndicatorsTwo() {
        return this.serviceInteractionIndicatorsTwo;
    }

    public Integer getCallSegmentID() {
        return this.callSegmentID;
    }

    @Override
    public int getTag() throws CAPException {
        return 16;
    }

    @Override
    public int getTagClass() {
        return 0;
    }

    @Override
    public boolean getIsPrimitive() {
        return false;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws CAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding ConnectToResourceIndication: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding ConnectToResourceIndication: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws CAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding ConnectToResourceIndication: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding ConnectToResourceIndication: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws CAPParsingComponentException, IOException, AsnException {
        this.resourceAddress_IPRoutingAddress = null;
        this.resourceAddress_Null = false;
        this.extensions = null;
        this.serviceInteractionIndicatorsTwo = null;
        this.callSegmentID = null;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        block7: while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 0: {
                        this.resourceAddress_IPRoutingAddress = new CalledPartyNumberCapImpl();
                        ((CalledPartyNumberCapImpl)this.resourceAddress_IPRoutingAddress).decodeAll(ais);
                        continue block7;
                    }
                    case 3: {
                        ais.readNull();
                        this.resourceAddress_Null = true;
                        continue block7;
                    }
                    case 4: {
                        this.extensions = new CAPExtensionsImpl();
                        ((CAPExtensionsImpl)this.extensions).decodeAll(ais);
                        continue block7;
                    }
                    case 7: {
                        this.serviceInteractionIndicatorsTwo = new ServiceInteractionIndicatorsTwoImpl();
                        ((ServiceInteractionIndicatorsTwoImpl)this.serviceInteractionIndicatorsTwo).decodeAll(ais);
                        continue block7;
                    }
                    case 50: {
                        this.callSegmentID = (int)ais.readInteger();
                        continue block7;
                    }
                }
                ais.advanceElement();
                continue;
            }
            ais.advanceElement();
        }
        int choiceCnt = 0;
        if (this.resourceAddress_IPRoutingAddress != null) {
            ++choiceCnt;
        }
        if (this.resourceAddress_Null) {
            ++choiceCnt;
        }
        if (choiceCnt != 1) {
            throw new CAPParsingComponentException("Error while decoding ConnectToResourceIndication: resourceAddress parameter must have 1 choice, found: " + choiceCnt, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws CAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws CAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding ConnectToResourceIndication: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream aos) throws CAPException {
        int choiceCnt = 0;
        if (this.resourceAddress_IPRoutingAddress != null) {
            ++choiceCnt;
        }
        if (this.resourceAddress_Null) {
            ++choiceCnt;
        }
        if (choiceCnt != 1) {
            throw new CAPException("Error while encoding ConnectToResourceIndication: resourceAddress parameter must have 1 choice, found: " + choiceCnt);
        }
        try {
            if (this.resourceAddress_IPRoutingAddress != null) {
                ((CalledPartyNumberCapImpl)this.resourceAddress_IPRoutingAddress).encodeAll(aos, 2, 0);
            }
            if (this.resourceAddress_Null) {
                aos.writeNull(2, 3);
            }
            if (this.extensions != null) {
                ((CAPExtensionsImpl)this.extensions).encodeAll(aos, 2, 4);
            }
            if (this.serviceInteractionIndicatorsTwo != null) {
                ((ServiceInteractionIndicatorsTwoImpl)this.serviceInteractionIndicatorsTwo).encodeAll(aos, 2, 7);
            }
            if (this.callSegmentID != null) {
                aos.writeInteger(2, 50, (long)this.callSegmentID.intValue());
            }
        }
        catch (IOException e) {
            throw new CAPException("IOException when encoding ConnectToResourceIndication: " + e.getMessage(), (Throwable)e);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding ConnectToResourceIndication: " + e.getMessage(), (Throwable)e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        this.addInvokeIdInfo(sb);
        if (this.resourceAddress_IPRoutingAddress != null) {
            sb.append(", resourceAddress: IPRoutingAddress=");
            sb.append(this.resourceAddress_IPRoutingAddress.toString());
        }
        if (this.resourceAddress_Null) {
            sb.append(", resourceAddress: Null");
        }
        if (this.extensions != null) {
            sb.append(", extensions=");
            sb.append(this.extensions.toString());
        }
        if (this.serviceInteractionIndicatorsTwo != null) {
            sb.append(", serviceInteractionIndicatorsTwo=");
            sb.append(this.serviceInteractionIndicatorsTwo.toString());
        }
        if (this.callSegmentID != null) {
            sb.append(", callSegmentID=");
            sb.append(this.callSegmentID.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

