/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall.primitive;

import java.io.IOException;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.api.primitives.CAPExtensions;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.primitive.AudibleIndicator;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.primitive.CAMELAChBillingChargingCharacteristics;
import org.mobicents.protocols.ss7.cap.primitives.CAPAsnPrimitive;
import org.mobicents.protocols.ss7.cap.primitives.CAPExtensionsImpl;
import org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall.primitive.AudibleIndicatorImpl;

public class CAMELAChBillingChargingCharacteristicsImpl
implements CAMELAChBillingChargingCharacteristics,
CAPAsnPrimitive {
    private static final String MAX_CALL_PERIOD_DURATION = "maxCallPeriodDuration";
    private static final String RELEASED_IF_DURATION_EXCEEDED = "releaseIfdurationExceeded";
    private static final String TARIFF_SWITCH_INTERVAL = "tariffSwitchInterval";
    private static final String AUDIBLE_INDICATOR = "audibleIndicator";
    private static final String EXTENSIONS = "extensions";
    private static final String CAP_VERSION = "capVersion";
    public static final int _ID_timeDurationCharging = 0;
    public static final int _ID_maxCallPeriodDuration = 0;
    public static final int _ID_releaseIfdurationExceeded = 1;
    public static final int _ID_tariffSwitchInterval = 2;
    public static final int _ID_audibleIndicator = 3;
    public static final int _ID_extensions = 4;
    public static final int _ID_extensions_In_ReleaseIfDurationExceeded = 10;
    public static final String _PrimitiveName = "CAMELAChBillingChargingCharacteristics";
    private byte[] data;
    private long maxCallPeriodDuration;
    private boolean releaseIfdurationExceeded;
    private Long tariffSwitchInterval;
    private AudibleIndicator audibleIndicator;
    private CAPExtensions extensions;
    private int capVersion;
    protected static final XMLFormat<CAMELAChBillingChargingCharacteristicsImpl> CAMEL_ACH_BILLING_CHARGING_CHARACTERISTIC_XML = new XMLFormat<CAMELAChBillingChargingCharacteristicsImpl>(CAMELAChBillingChargingCharacteristicsImpl.class){

        public void read(XMLFormat.InputElement xml, CAMELAChBillingChargingCharacteristicsImpl camelAChBillingChargingCharacteristics) throws XMLStreamException {
            camelAChBillingChargingCharacteristics.capVersion = xml.getAttribute(CAMELAChBillingChargingCharacteristicsImpl.CAP_VERSION, 2);
            camelAChBillingChargingCharacteristics.maxCallPeriodDuration = (Long)xml.get(CAMELAChBillingChargingCharacteristicsImpl.MAX_CALL_PERIOD_DURATION, Long.class);
            camelAChBillingChargingCharacteristics.releaseIfdurationExceeded = (Boolean)xml.get(CAMELAChBillingChargingCharacteristicsImpl.RELEASED_IF_DURATION_EXCEEDED, Boolean.class);
            camelAChBillingChargingCharacteristics.tariffSwitchInterval = (Long)xml.get(CAMELAChBillingChargingCharacteristicsImpl.TARIFF_SWITCH_INTERVAL, Long.class);
            camelAChBillingChargingCharacteristics.extensions = (CAPExtensions)xml.get(CAMELAChBillingChargingCharacteristicsImpl.EXTENSIONS, CAPExtensionsImpl.class);
            camelAChBillingChargingCharacteristics.audibleIndicator = (AudibleIndicator)xml.get(CAMELAChBillingChargingCharacteristicsImpl.AUDIBLE_INDICATOR, AudibleIndicatorImpl.class);
        }

        public void write(CAMELAChBillingChargingCharacteristicsImpl camelAChBillingChargingCharacteristics, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute(CAMELAChBillingChargingCharacteristicsImpl.CAP_VERSION, camelAChBillingChargingCharacteristics.capVersion);
            xml.add((Object)camelAChBillingChargingCharacteristics.maxCallPeriodDuration, CAMELAChBillingChargingCharacteristicsImpl.MAX_CALL_PERIOD_DURATION, Long.class);
            xml.add((Object)camelAChBillingChargingCharacteristics.releaseIfdurationExceeded, CAMELAChBillingChargingCharacteristicsImpl.RELEASED_IF_DURATION_EXCEEDED, Boolean.class);
            if (camelAChBillingChargingCharacteristics.tariffSwitchInterval != null) {
                xml.add((Object)camelAChBillingChargingCharacteristics.tariffSwitchInterval, CAMELAChBillingChargingCharacteristicsImpl.TARIFF_SWITCH_INTERVAL, Long.class);
            }
            if (camelAChBillingChargingCharacteristics.extensions != null) {
                xml.add((Object)((CAPExtensionsImpl)camelAChBillingChargingCharacteristics.extensions), CAMELAChBillingChargingCharacteristicsImpl.EXTENSIONS, CAPExtensionsImpl.class);
            }
            if (camelAChBillingChargingCharacteristics.audibleIndicator != null) {
                xml.add((Object)((AudibleIndicatorImpl)camelAChBillingChargingCharacteristics.audibleIndicator), CAMELAChBillingChargingCharacteristicsImpl.AUDIBLE_INDICATOR, AudibleIndicatorImpl.class);
            }
        }
    };

    public CAMELAChBillingChargingCharacteristicsImpl() {
    }

    public CAMELAChBillingChargingCharacteristicsImpl(byte[] data) {
        this.data = data;
    }

    public CAMELAChBillingChargingCharacteristicsImpl(long maxCallPeriodDuration, boolean releaseIfdurationExceeded, Long tariffSwitchInterval, AudibleIndicator audibleIndicator, CAPExtensions extensions, int capVersion) {
        this.maxCallPeriodDuration = maxCallPeriodDuration;
        this.releaseIfdurationExceeded = releaseIfdurationExceeded;
        this.tariffSwitchInterval = tariffSwitchInterval;
        this.audibleIndicator = audibleIndicator;
        this.extensions = extensions;
        this.capVersion = capVersion;
    }

    public byte[] getData() {
        return this.data;
    }

    public long getMaxCallPeriodDuration() {
        return this.maxCallPeriodDuration;
    }

    public boolean getReleaseIfdurationExceeded() {
        return this.releaseIfdurationExceeded;
    }

    public Long getTariffSwitchInterval() {
        return this.tariffSwitchInterval;
    }

    public AudibleIndicator getAudibleIndicator() {
        return this.audibleIndicator;
    }

    public CAPExtensions getExtensions() {
        return this.extensions;
    }

    @Override
    public int getTag() throws CAPException {
        return 4;
    }

    @Override
    public int getTagClass() {
        return 0;
    }

    @Override
    public boolean getIsPrimitive() {
        return true;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws CAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding CAMELAChBillingChargingCharacteristics: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding CAMELAChBillingChargingCharacteristics: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws CAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding CAMELAChBillingChargingCharacteristics: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding CAMELAChBillingChargingCharacteristics: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws CAPParsingComponentException, IOException, AsnException {
        this.data = null;
        this.maxCallPeriodDuration = -1L;
        this.releaseIfdurationExceeded = false;
        this.tariffSwitchInterval = null;
        this.audibleIndicator = null;
        this.extensions = null;
        this.capVersion = 0;
        this.data = ansIS.readOctetStringData(length);
        AsnInputStream aiss = new AsnInputStream(this.data);
        int tag = aiss.readTag();
        if (tag != 0 || aiss.getTagClass() != 2 || aiss.isTagPrimitive()) {
            throw new CAPParsingComponentException("Error when decoding CAMELAChBillingChargingCharacteristics: CAMEL-AChBillingChargingCharacteristics choice has bad tag or tagClass or is primitive, tag=" + tag + ", tagClass=" + aiss.getTagClass(), CAPParsingComponentExceptionReason.MistypedParameter);
        }
        AsnInputStream ais = aiss.readSequenceStream();
        while (ais.available() != 0) {
            tag = ais.readTag();
            if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 0: {
                        this.maxCallPeriodDuration = ais.readInteger();
                        break;
                    }
                    case 1: {
                        int ln = ais.readLength();
                        if (ln == 1) {
                            if (this.capVersion < 3) {
                                this.capVersion = 3;
                            }
                            this.releaseIfdurationExceeded = ais.readBooleanData(ln);
                            break;
                        }
                        this.capVersion = 2;
                        AsnInputStream ais2 = ais.readSequenceStreamData(ln);
                        this.releaseIfdurationExceeded = true;
                        int num = 0;
                        while (ais2.available() != 0) {
                            int tag2 = ais2.readTag();
                            boolean parsed = false;
                            if (num == 0 && tag2 == 1 && ais2.getTagClass() == 0) {
                                this.audibleIndicator = new AudibleIndicatorImpl(ais2.readBoolean());
                                parsed = true;
                            }
                            if (ais2.getTagClass() == 2 && tag2 == 10) {
                                this.extensions = new CAPExtensionsImpl();
                                ((CAPExtensionsImpl)this.extensions).decodeAll(ais2);
                                parsed = true;
                            }
                            if (!parsed) {
                                ais2.advanceElement();
                            }
                            ++num;
                        }
                        break;
                    }
                    case 2: {
                        this.tariffSwitchInterval = ais.readInteger();
                        break;
                    }
                    case 3: {
                        if (ais.isTagPrimitive()) {
                            this.capVersion = 3;
                            this.audibleIndicator = new AudibleIndicatorImpl(ais.readBoolean());
                            break;
                        }
                        this.capVersion = 4;
                        AsnInputStream ais2 = ais.readSequenceStream();
                        ais2.readTag();
                        this.audibleIndicator = new AudibleIndicatorImpl();
                        ((AudibleIndicatorImpl)this.audibleIndicator).decodeAll(ais2);
                        break;
                    }
                    case 4: {
                        if (this.capVersion < 3) {
                            this.capVersion = 3;
                        }
                        this.extensions = new CAPExtensionsImpl();
                        ((CAPExtensionsImpl)this.extensions).decodeAll(ais);
                        break;
                    }
                    default: {
                        ais.advanceElement();
                    }
                }
                continue;
            }
            ais.advanceElement();
        }
        if (this.maxCallPeriodDuration == -1L) {
            throw new CAPParsingComponentException("Error while decoding CAMELAChBillingChargingCharacteristics: maxCallPeriodDuration is mandatory but not found", CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws CAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws CAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding CAMELAChBillingChargingCharacteristics: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws CAPException {
        if (this.data == null) {
            if (this.maxCallPeriodDuration < 1L || this.maxCallPeriodDuration > 864000L) {
                throw new CAPException("Error while encoding CAMELAChBillingChargingCharacteristics: maxCallPeriodDuration must be from 1 to 864000");
            }
            if (this.tariffSwitchInterval != null && (this.tariffSwitchInterval < 1L || this.tariffSwitchInterval > 86400L)) {
                throw new CAPException("Error while encoding CAMELAChBillingChargingCharacteristics: tariffSwitchInterval must be from 1 to 86400");
            }
            try {
                int pos2;
                AsnOutputStream aos = new AsnOutputStream();
                aos.writeTag(2, false, 0);
                int pos = aos.StartContentDefiniteLength();
                aos.writeInteger(2, 0, this.maxCallPeriodDuration);
                if (this.capVersion >= 3) {
                    if (this.releaseIfdurationExceeded) {
                        aos.writeBoolean(2, 1, true);
                    }
                } else if (this.releaseIfdurationExceeded || this.extensions != null) {
                    aos.writeTag(2, false, 1);
                    pos2 = aos.StartContentDefiniteLength();
                    if (this.audibleIndicator != null && this.audibleIndicator.getTone() != null) {
                        aos.writeBoolean(this.audibleIndicator.getTone().booleanValue());
                    } else {
                        aos.writeBoolean(false);
                    }
                    if (this.extensions != null) {
                        ((CAPExtensionsImpl)this.extensions).encodeAll(aos, 2, 10);
                    }
                    aos.FinalizeContent(pos2);
                }
                if (this.tariffSwitchInterval != null) {
                    aos.writeInteger(2, 2, this.tariffSwitchInterval.longValue());
                }
                if (this.audibleIndicator != null) {
                    switch (this.capVersion) {
                        case 3: {
                            aos.writeBoolean(2, 3, this.audibleIndicator.getTone().booleanValue());
                            break;
                        }
                        case 4: {
                            aos.writeTag(2, false, 3);
                            pos2 = aos.StartContentDefiniteLength();
                            ((AudibleIndicatorImpl)this.audibleIndicator).encodeAll(aos);
                            aos.FinalizeContent(pos2);
                            break;
                        }
                    }
                }
                if (this.extensions != null && this.capVersion >= 3) {
                    ((CAPExtensionsImpl)this.extensions).encodeAll(aos, 2, 4);
                }
                aos.FinalizeContent(pos);
                this.data = aos.toByteArray();
            }
            catch (IOException e) {
                throw new CAPException("IOException when encoding CAMELAChBillingChargingCharacteristics: " + e.getMessage(), (Throwable)e);
            }
            catch (AsnException e) {
                throw new CAPException("AsnException when encoding CAMELAChBillingChargingCharacteristics: " + e.getMessage(), (Throwable)e);
            }
        }
        asnOs.writeOctetStringData(this.data);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [timeDurationCharging [");
        sb.append("capVersion=");
        sb.append(this.capVersion);
        sb.append(", maxCallPeriodDuration=");
        sb.append(this.maxCallPeriodDuration);
        if (this.releaseIfdurationExceeded) {
            sb.append(", releaseIfdurationExceeded");
        }
        if (this.tariffSwitchInterval != null) {
            sb.append(", tariffSwitchInterval=");
            sb.append(this.tariffSwitchInterval);
        }
        if (this.audibleIndicator != null) {
            sb.append(", audibleIndicator=");
            sb.append(this.audibleIndicator.toString());
        }
        if (this.extensions != null) {
            sb.append(", extensions=");
            sb.append(this.extensions.toString());
        }
        sb.append("]]");
        return sb.toString();
    }
}

