/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall.primitive;

import java.io.IOException;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.primitive.IPSSPCapabilities;
import org.mobicents.protocols.ss7.cap.primitives.CAPAsnPrimitive;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.ByteArrayContainer;

public class IPSSPCapabilitiesImpl
implements IPSSPCapabilities,
CAPAsnPrimitive {
    public static int _Mask_IPRoutingAddress = 1;
    public static int _Mask_VoiceBack = 2;
    public static int _Mask_VoiceInformation_SpeechRecognition = 4;
    public static int _Mask_VoiceInformation_VoiceRecognition = 8;
    public static int _Mask_GenerationOfVoiceAnnouncementsFromTextSupported = 16;
    private static final String IP_ROUTING_ADDRESS_SUPPORTED = "ipRoutingAddressSupported";
    private static final String VOICE_BACK_SUPPORTED = "voiceBackSupported";
    private static final String VOICE_INFORMATION_SUPPORTED_VIA_SPEECH_RECOGNITION = "voiceInformationSupportedViaSpeechRecognition";
    private static final String VOICE_INFORMATION_SUPPORTED_VIA_VOICE_RECOGNITION = "voiceInformationSupportedViaVoiceRecognition";
    private static final String GENERATION_OF_VOICE_ANNOUNCEMENTS_FROM_TEXT_SUPPORTED = "generationOfVoiceAnnouncementsFromTextSupported";
    private static final String EXTRA_DATA = "extraData";
    public static final String _PrimitiveName = "IPSSPCapabilities";
    private byte[] data;
    protected static final XMLFormat<IPSSPCapabilitiesImpl> IPSSP_CAPABILITIES_XML = new XMLFormat<IPSSPCapabilitiesImpl>(IPSSPCapabilitiesImpl.class){

        public void read(XMLFormat.InputElement xml, IPSSPCapabilitiesImpl ipsspCapabilities) throws XMLStreamException {
            boolean IPRoutingAddressSupported = xml.getAttribute(IPSSPCapabilitiesImpl.IP_ROUTING_ADDRESS_SUPPORTED, false);
            boolean voiceBackSupported = xml.getAttribute(IPSSPCapabilitiesImpl.VOICE_BACK_SUPPORTED, false);
            boolean voiceInformationSupportedViaSpeechRecognition = xml.getAttribute(IPSSPCapabilitiesImpl.VOICE_INFORMATION_SUPPORTED_VIA_SPEECH_RECOGNITION, false);
            boolean voiceInformationSupportedViaVoiceRecognition = xml.getAttribute(IPSSPCapabilitiesImpl.VOICE_INFORMATION_SUPPORTED_VIA_VOICE_RECOGNITION, false);
            boolean generationOfVoiceAnnouncementsFromTextSupported = xml.getAttribute(IPSSPCapabilitiesImpl.GENERATION_OF_VOICE_ANNOUNCEMENTS_FROM_TEXT_SUPPORTED, false);
            ByteArrayContainer bc = (ByteArrayContainer)xml.get(IPSSPCapabilitiesImpl.EXTRA_DATA, ByteArrayContainer.class);
            byte[] extraData = null;
            if (bc != null) {
                extraData = bc.getData();
            }
            ipsspCapabilities.setData(IPRoutingAddressSupported, voiceBackSupported, voiceInformationSupportedViaSpeechRecognition, voiceInformationSupportedViaVoiceRecognition, generationOfVoiceAnnouncementsFromTextSupported, extraData);
        }

        public void write(IPSSPCapabilitiesImpl ipsspCapabilities, XMLFormat.OutputElement xml) throws XMLStreamException {
            if (ipsspCapabilities.getIPRoutingAddressSupported()) {
                xml.setAttribute(IPSSPCapabilitiesImpl.IP_ROUTING_ADDRESS_SUPPORTED, ipsspCapabilities.getIPRoutingAddressSupported());
            }
            if (ipsspCapabilities.getVoiceBackSupported()) {
                xml.setAttribute(IPSSPCapabilitiesImpl.VOICE_BACK_SUPPORTED, ipsspCapabilities.getVoiceBackSupported());
            }
            if (ipsspCapabilities.getVoiceInformationSupportedViaSpeechRecognition()) {
                xml.setAttribute(IPSSPCapabilitiesImpl.VOICE_INFORMATION_SUPPORTED_VIA_SPEECH_RECOGNITION, ipsspCapabilities.getVoiceInformationSupportedViaSpeechRecognition());
            }
            if (ipsspCapabilities.getVoiceInformationSupportedViaVoiceRecognition()) {
                xml.setAttribute(IPSSPCapabilitiesImpl.VOICE_INFORMATION_SUPPORTED_VIA_VOICE_RECOGNITION, ipsspCapabilities.getVoiceInformationSupportedViaVoiceRecognition());
            }
            if (ipsspCapabilities.getGenerationOfVoiceAnnouncementsFromTextSupported()) {
                xml.setAttribute(IPSSPCapabilitiesImpl.GENERATION_OF_VOICE_ANNOUNCEMENTS_FROM_TEXT_SUPPORTED, ipsspCapabilities.getGenerationOfVoiceAnnouncementsFromTextSupported());
            }
            if (ipsspCapabilities.getExtraData() != null && ipsspCapabilities.getExtraData().length > 0) {
                ByteArrayContainer bac = new ByteArrayContainer(ipsspCapabilities.getExtraData());
                xml.add((Object)bac, IPSSPCapabilitiesImpl.EXTRA_DATA, ByteArrayContainer.class);
            }
        }
    };

    public IPSSPCapabilitiesImpl() {
    }

    public IPSSPCapabilitiesImpl(byte[] data) {
        this.data = data;
    }

    public IPSSPCapabilitiesImpl(boolean IPRoutingAddressSupported, boolean VoiceBackSupported, boolean VoiceInformationSupportedViaSpeechRecognition, boolean VoiceInformationSupportedViaVoiceRecognition, boolean GenerationOfVoiceAnnouncementsFromTextSupported, byte[] extraData) {
        this.setData(IPRoutingAddressSupported, VoiceBackSupported, VoiceInformationSupportedViaSpeechRecognition, VoiceInformationSupportedViaVoiceRecognition, GenerationOfVoiceAnnouncementsFromTextSupported, extraData);
    }

    public void setData(boolean IPRoutingAddressSupported, boolean VoiceBackSupported, boolean VoiceInformationSupportedViaSpeechRecognition, boolean VoiceInformationSupportedViaVoiceRecognition, boolean GenerationOfVoiceAnnouncementsFromTextSupported, byte[] extraData) {
        int firstByte = (IPRoutingAddressSupported ? _Mask_IPRoutingAddress : 0) | (VoiceBackSupported ? _Mask_VoiceBack : 0) | (VoiceInformationSupportedViaSpeechRecognition ? _Mask_VoiceInformation_SpeechRecognition : 0) | (VoiceInformationSupportedViaVoiceRecognition ? _Mask_VoiceInformation_VoiceRecognition : 0) | (GenerationOfVoiceAnnouncementsFromTextSupported ? _Mask_GenerationOfVoiceAnnouncementsFromTextSupported : 0);
        int extraCnt = 0;
        if (extraData != null) {
            extraCnt = extraData.length;
        }
        if (extraCnt > 3) {
            extraCnt = 3;
        }
        this.data = new byte[1 + extraCnt];
        this.data[0] = (byte)firstByte;
        if (extraCnt > 0) {
            System.arraycopy(extraData, 0, this.data, 1, extraCnt);
        }
    }

    public byte[] getData() {
        return this.data;
    }

    public boolean getIPRoutingAddressSupported() {
        if (this.data == null || this.data.length == 0) {
            return false;
        }
        return (this.data[0] & _Mask_IPRoutingAddress) != 0;
    }

    public boolean getVoiceBackSupported() {
        if (this.data == null || this.data.length == 0) {
            return false;
        }
        return (this.data[0] & _Mask_VoiceBack) != 0;
    }

    public boolean getVoiceInformationSupportedViaSpeechRecognition() {
        if (this.data == null || this.data.length == 0) {
            return false;
        }
        return (this.data[0] & _Mask_VoiceInformation_SpeechRecognition) != 0;
    }

    public boolean getVoiceInformationSupportedViaVoiceRecognition() {
        if (this.data == null || this.data.length == 0) {
            return false;
        }
        return (this.data[0] & _Mask_VoiceInformation_VoiceRecognition) != 0;
    }

    public boolean getGenerationOfVoiceAnnouncementsFromTextSupported() {
        if (this.data == null || this.data.length == 0) {
            return false;
        }
        return (this.data[0] & _Mask_GenerationOfVoiceAnnouncementsFromTextSupported) != 0;
    }

    public byte[] getExtraData() {
        if (this.data == null || this.data.length < 2) {
            return null;
        }
        int extraCount = this.data.length;
        if (extraCount > 3) {
            extraCount = 3;
        }
        byte[] res = new byte[extraCount];
        System.arraycopy(this.data, 1, res, 0, extraCount);
        return res;
    }

    @Override
    public int getTag() throws CAPException {
        return 4;
    }

    @Override
    public int getTagClass() {
        return 0;
    }

    @Override
    public boolean getIsPrimitive() {
        return true;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws CAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding IPSSPCapabilities: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding IPSSPCapabilities: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws CAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding IPSSPCapabilities: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding IPSSPCapabilities: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws CAPParsingComponentException, IOException, AsnException {
        this.data = ansIS.readOctetStringData(length);
        if (this.data.length < 1 || this.data.length > 4) {
            throw new CAPParsingComponentException("Error decoding IPSSPCapabilities: length must be from 1 to 4, real length = " + length, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws CAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws CAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding IPSSPCapabilities: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws CAPException {
        if (this.data == null) {
            throw new CAPException("Error while encoding IPSSPCapabilities: data field must not be null");
        }
        if (this.data.length < 1 || this.data.length > 4) {
            throw new CAPException("Error while encoding IPSSPCapabilities: data field length must be from 1 to 4");
        }
        asnOs.writeOctetStringData(this.data);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.data != null) {
            byte[] eArr;
            if (this.getIPRoutingAddressSupported()) {
                sb.append("IPRoutingAddressSupported, ");
            }
            if (this.getVoiceBackSupported()) {
                sb.append("VoiceBackSupported, ");
            }
            if (this.getVoiceInformationSupportedViaSpeechRecognition()) {
                sb.append("VoiceInformationSupportedViaSpeechRecognition, ");
            }
            if (this.getVoiceInformationSupportedViaVoiceRecognition()) {
                sb.append("VoiceInformationSupportedViaVoiceRecognition, ");
            }
            if (this.getGenerationOfVoiceAnnouncementsFromTextSupported()) {
                sb.append("GenerationOfVoiceAnnouncementsFromTextSupported, ");
            }
            if ((eArr = this.getExtraData()) != null) {
                sb.append("ExtraData=");
                for (int i1 = 0; i1 < eArr.length; ++i1) {
                    sb.append(eArr[i1]);
                    sb.append(", ");
                }
            }
        }
        sb.append("]");
        return sb.toString();
    }
}

