/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall.primitive;

import java.io.IOException;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.primitive.Tone;
import org.mobicents.protocols.ss7.cap.primitives.SequenceBase;

public class ToneImpl
extends SequenceBase
implements Tone {
    public static final int _ID_toneID = 0;
    public static final int _ID_duration = 1;
    private static final String TONE_ID = "toneID";
    private static final String DURATION = "duration";
    private int toneID;
    private Integer duration;
    protected static final XMLFormat<ToneImpl> TONE_XML = new XMLFormat<ToneImpl>(ToneImpl.class){

        public void read(XMLFormat.InputElement xml, ToneImpl tone) throws XMLStreamException {
            tone.toneID = xml.getAttribute(ToneImpl.TONE_ID, 0);
            int vali = xml.getAttribute(ToneImpl.DURATION, -1);
            if (vali != -1) {
                tone.duration = vali;
            }
        }

        public void write(ToneImpl tone, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute(ToneImpl.TONE_ID, tone.toneID);
            if (tone.duration != null) {
                xml.setAttribute(ToneImpl.DURATION, tone.duration.intValue());
            }
        }
    };

    public ToneImpl() {
        super("Tone");
    }

    public ToneImpl(int toneID, Integer duration) {
        super("Tone");
        this.toneID = toneID;
        this.duration = duration;
    }

    public int getToneID() {
        return this.toneID;
    }

    public Integer getDuration() {
        return this.duration;
    }

    @Override
    protected void _decode(AsnInputStream ansIS, int length) throws CAPParsingComponentException, IOException, AsnException {
        this.toneID = 0;
        this.duration = null;
        boolean toneIDRecieved = false;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        block4: while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 0: {
                        this.toneID = (int)ais.readInteger();
                        toneIDRecieved = true;
                        continue block4;
                    }
                    case 1: {
                        this.duration = (int)ais.readInteger();
                        continue block4;
                    }
                }
                ais.advanceElement();
                continue;
            }
            ais.advanceElement();
        }
        if (!toneIDRecieved) {
            throw new CAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": toneID is mandatory but not found", CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeData(AsnOutputStream aos) throws CAPException {
        try {
            aos.writeInteger(2, 0, (long)this.toneID);
            if (this.duration != null) {
                aos.writeInteger(2, 1, (long)this.duration.intValue());
            }
        }
        catch (IOException e) {
            throw new CAPException("IOException when encoding " + this._PrimitiveName + ": " + e.getMessage(), (Throwable)e);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding " + this._PrimitiveName + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName);
        sb.append(" [");
        sb.append("toneID=");
        sb.append(this.toneID);
        if (this.duration != null) {
            sb.append(", duration=");
            sb.append(this.duration);
        }
        sb.append("]");
        return sb.toString();
    }
}

