/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.service.gprs;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPMessageType;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.api.service.gprs.ApplyChargingGPRSRequest;
import org.mobicents.protocols.ss7.cap.api.service.gprs.primitive.ChargingCharacteristics;
import org.mobicents.protocols.ss7.cap.api.service.gprs.primitive.PDPID;
import org.mobicents.protocols.ss7.cap.service.gprs.GprsMessageImpl;
import org.mobicents.protocols.ss7.cap.service.gprs.primitive.ChargingCharacteristicsImpl;
import org.mobicents.protocols.ss7.cap.service.gprs.primitive.PDPIDImpl;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;

public class ApplyChargingGPRSRequestImpl
extends GprsMessageImpl
implements ApplyChargingGPRSRequest {
    public static final String _PrimitiveName = "ApplyChargingGPRSRequest";
    public static final int _ID_chargingCharacteristics = 0;
    public static final int _ID_tariffSwitchInterval = 1;
    public static final int _ID_pdpID = 2;
    private ChargingCharacteristics chargingCharacteristics;
    private Integer tariffSwitchInterval;
    private PDPID pdpID;

    public ApplyChargingGPRSRequestImpl() {
    }

    public ApplyChargingGPRSRequestImpl(ChargingCharacteristics chargingCharacteristics, Integer tariffSwitchInterval, PDPID pdpID) {
        this.chargingCharacteristics = chargingCharacteristics;
        this.tariffSwitchInterval = tariffSwitchInterval;
        this.pdpID = pdpID;
    }

    public ChargingCharacteristics getChargingCharacteristics() {
        return this.chargingCharacteristics;
    }

    public Integer getTariffSwitchInterval() {
        return this.tariffSwitchInterval;
    }

    public PDPID getPDPID() {
        return this.pdpID;
    }

    public CAPMessageType getMessageType() {
        return CAPMessageType.applyChargingGPRS_Request;
    }

    public int getOperationCode() {
        return 71;
    }

    @Override
    public int getTag() throws CAPException {
        return 16;
    }

    @Override
    public int getTagClass() {
        return 0;
    }

    @Override
    public boolean getIsPrimitive() {
        return false;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws CAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding ApplyChargingGPRSRequest: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding ApplyChargingGPRSRequest: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (MAPParsingComponentException e) {
            throw new CAPParsingComponentException("MAPParsingComponentException when decoding ApplyChargingGPRSRequest: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws CAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding ApplyChargingGPRSRequest: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding ApplyChargingGPRSRequest: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (MAPParsingComponentException e) {
            throw new CAPParsingComponentException("MAPParsingComponentException when decoding ApplyChargingGPRSRequest: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws CAPParsingComponentException, IOException, AsnException, MAPParsingComponentException {
        this.chargingCharacteristics = null;
        this.tariffSwitchInterval = null;
        this.pdpID = null;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 0: {
                        if (ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding ApplyChargingGPRSRequest.chargingCharacteristics: Parameter is primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.chargingCharacteristics = new ChargingCharacteristicsImpl();
                        AsnInputStream ais2 = ais.readSequenceStream();
                        ais2.readTag();
                        ((ChargingCharacteristicsImpl)this.chargingCharacteristics).decodeAll(ais2);
                        break;
                    }
                    case 1: {
                        if (!ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding ApplyChargingGPRSRequest.tariffSwitchInterval: Parameter is not primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.tariffSwitchInterval = (int)ais.readInteger();
                        break;
                    }
                    case 2: {
                        if (!ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding ApplyChargingGPRSRequest.pdpID: Parameter is not primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.pdpID = new PDPIDImpl();
                        ((PDPIDImpl)this.pdpID).decodeAll(ais);
                        break;
                    }
                    default: {
                        ais.advanceElement();
                        break;
                    }
                }
                continue;
            }
            ais.advanceElement();
        }
        if (this.chargingCharacteristics == null) {
            throw new CAPParsingComponentException("Error while decoding ApplyChargingGPRSRequest: parameter chargingCharacteristics is mandatory but not found", CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws CAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws CAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding ApplyChargingGPRSRequest: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws CAPException {
        if (this.chargingCharacteristics == null) {
            throw new CAPException("Error while encoding ApplyChargingGPRSRequest: chargingCharacteristics must not be null");
        }
        try {
            asnOs.writeTag(2, false, 0);
            int pos = asnOs.StartContentDefiniteLength();
            ((ChargingCharacteristicsImpl)this.chargingCharacteristics).encodeAll(asnOs);
            asnOs.FinalizeContent(pos);
            if (this.tariffSwitchInterval != null) {
                asnOs.writeInteger(2, 1, (long)this.tariffSwitchInterval.intValue());
            }
            if (this.pdpID != null) {
                ((PDPIDImpl)this.pdpID).encodeAll(asnOs, 2, 2);
            }
        }
        catch (IOException e) {
            throw new CAPException("IOException when encoding ApplyChargingGPRSRequest: " + e.getMessage(), (Throwable)e);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding ApplyChargingGPRSRequest: " + e.getMessage(), (Throwable)e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ApplyChargingGPRSRequest [");
        this.addInvokeIdInfo(sb);
        if (this.chargingCharacteristics != null) {
            sb.append(", chargingCharacteristics=");
            sb.append(this.chargingCharacteristics.toString());
            sb.append(", ");
        }
        if (this.tariffSwitchInterval != null) {
            sb.append(", tariffSwitchInterval=");
            sb.append(this.tariffSwitchInterval.toString());
            sb.append(", ");
        }
        if (this.pdpID != null) {
            sb.append(", pdpID=");
            sb.append(this.pdpID.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

