/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.service.gprs;

import org.apache.log4j.Logger;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.ss7.cap.CAPDialogImpl;
import org.mobicents.protocols.ss7.cap.CAPProviderImpl;
import org.mobicents.protocols.ss7.cap.CAPServiceBaseImpl;
import org.mobicents.protocols.ss7.cap.api.CAPApplicationContext;
import org.mobicents.protocols.ss7.cap.api.CAPDialog;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPMessage;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.api.CAPServiceListener;
import org.mobicents.protocols.ss7.cap.api.dialog.ServingCheckData;
import org.mobicents.protocols.ss7.cap.api.dialog.ServingCheckResult;
import org.mobicents.protocols.ss7.cap.api.service.gprs.ActivityTestGPRSRequest;
import org.mobicents.protocols.ss7.cap.api.service.gprs.ActivityTestGPRSResponse;
import org.mobicents.protocols.ss7.cap.api.service.gprs.ApplyChargingGPRSRequest;
import org.mobicents.protocols.ss7.cap.api.service.gprs.ApplyChargingReportGPRSRequest;
import org.mobicents.protocols.ss7.cap.api.service.gprs.ApplyChargingReportGPRSResponse;
import org.mobicents.protocols.ss7.cap.api.service.gprs.CAPDialogGprs;
import org.mobicents.protocols.ss7.cap.api.service.gprs.CAPServiceGprs;
import org.mobicents.protocols.ss7.cap.api.service.gprs.CAPServiceGprsListener;
import org.mobicents.protocols.ss7.cap.api.service.gprs.CancelGPRSRequest;
import org.mobicents.protocols.ss7.cap.api.service.gprs.ConnectGPRSRequest;
import org.mobicents.protocols.ss7.cap.api.service.gprs.ContinueGPRSRequest;
import org.mobicents.protocols.ss7.cap.api.service.gprs.EntityReleasedGPRSRequest;
import org.mobicents.protocols.ss7.cap.api.service.gprs.EntityReleasedGPRSResponse;
import org.mobicents.protocols.ss7.cap.api.service.gprs.EventReportGPRSRequest;
import org.mobicents.protocols.ss7.cap.api.service.gprs.EventReportGPRSResponse;
import org.mobicents.protocols.ss7.cap.api.service.gprs.FurnishChargingInformationGPRSRequest;
import org.mobicents.protocols.ss7.cap.api.service.gprs.InitialDpGprsRequest;
import org.mobicents.protocols.ss7.cap.api.service.gprs.ReleaseGPRSRequest;
import org.mobicents.protocols.ss7.cap.api.service.gprs.RequestReportGPRSEventRequest;
import org.mobicents.protocols.ss7.cap.api.service.gprs.ResetTimerGPRSRequest;
import org.mobicents.protocols.ss7.cap.api.service.gprs.SendChargingInformationGPRSRequest;
import org.mobicents.protocols.ss7.cap.dialog.ServingCheckDataImpl;
import org.mobicents.protocols.ss7.cap.service.gprs.ActivityTestGPRSRequestImpl;
import org.mobicents.protocols.ss7.cap.service.gprs.ActivityTestGPRSResponseImpl;
import org.mobicents.protocols.ss7.cap.service.gprs.ApplyChargingGPRSRequestImpl;
import org.mobicents.protocols.ss7.cap.service.gprs.ApplyChargingReportGPRSRequestImpl;
import org.mobicents.protocols.ss7.cap.service.gprs.ApplyChargingReportGPRSResponseImpl;
import org.mobicents.protocols.ss7.cap.service.gprs.CAPDialogGprsImpl;
import org.mobicents.protocols.ss7.cap.service.gprs.CancelGPRSRequestImpl;
import org.mobicents.protocols.ss7.cap.service.gprs.ConnectGPRSRequestImpl;
import org.mobicents.protocols.ss7.cap.service.gprs.ContinueGPRSRequestImpl;
import org.mobicents.protocols.ss7.cap.service.gprs.EntityReleasedGPRSRequestImpl;
import org.mobicents.protocols.ss7.cap.service.gprs.EntityReleasedGPRSResponseImpl;
import org.mobicents.protocols.ss7.cap.service.gprs.EventReportGPRSRequestImpl;
import org.mobicents.protocols.ss7.cap.service.gprs.EventReportGPRSResponseImpl;
import org.mobicents.protocols.ss7.cap.service.gprs.FurnishChargingInformationGPRSRequestImpl;
import org.mobicents.protocols.ss7.cap.service.gprs.InitialDpGprsRequestImpl;
import org.mobicents.protocols.ss7.cap.service.gprs.ReleaseGPRSRequestImpl;
import org.mobicents.protocols.ss7.cap.service.gprs.RequestReportGPRSEventRequestImpl;
import org.mobicents.protocols.ss7.cap.service.gprs.ResetTimerGPRSRequestImpl;
import org.mobicents.protocols.ss7.cap.service.gprs.SendChargingInformationGPRSRequestImpl;
import org.mobicents.protocols.ss7.sccp.parameter.SccpAddress;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.Dialog;
import org.mobicents.protocols.ss7.tcap.asn.comp.ComponentType;
import org.mobicents.protocols.ss7.tcap.asn.comp.Invoke;
import org.mobicents.protocols.ss7.tcap.asn.comp.OperationCode;
import org.mobicents.protocols.ss7.tcap.asn.comp.Parameter;

public class CAPServiceGprsImpl
extends CAPServiceBaseImpl
implements CAPServiceGprs {
    protected Logger loger = Logger.getLogger(CAPServiceGprsImpl.class);

    public CAPServiceGprsImpl(CAPProviderImpl capProviderImpl) {
        super(capProviderImpl);
    }

    public CAPDialogGprs createNewDialog(CAPApplicationContext appCntx, SccpAddress origAddress, SccpAddress destAddress) throws CAPException {
        return this.createNewDialog(appCntx, origAddress, destAddress, null);
    }

    public CAPDialogGprs createNewDialog(CAPApplicationContext appCntx, SccpAddress origAddress, SccpAddress destAddress, Long localTrId) throws CAPException {
        if (!this.isActivated()) {
            throw new CAPException("Cannot create CAPDialogGprs because CAPServiceGprsl is not activated");
        }
        Dialog tcapDialog = this.createNewTCAPDialog(origAddress, destAddress, localTrId);
        CAPDialogGprsImpl dialog = new CAPDialogGprsImpl(appCntx, tcapDialog, this.capProviderImpl, this);
        this.putCAPDialogIntoCollection(dialog);
        return dialog;
    }

    public void addCAPServiceListener(CAPServiceGprsListener capServiceListener) {
        super.addCAPServiceListener((CAPServiceListener)capServiceListener);
    }

    public void removeCAPServiceListener(CAPServiceGprsListener capServiceListener) {
        super.removeCAPServiceListener((CAPServiceListener)capServiceListener);
    }

    @Override
    protected CAPDialogImpl createNewDialogIncoming(CAPApplicationContext appCntx, Dialog tcapDialog) {
        return new CAPDialogGprsImpl(appCntx, tcapDialog, this.capProviderImpl, this);
    }

    public ServingCheckData isServingService(CAPApplicationContext dialogApplicationContext) {
        switch (dialogApplicationContext) {
            case CapV3_gprsSSF_gsmSCF: 
            case CapV3_gsmSCF_gprsSSF: {
                return new ServingCheckDataImpl(ServingCheckResult.AC_Serving);
            }
        }
        return new ServingCheckDataImpl(ServingCheckResult.AC_NotServing);
    }

    @Override
    public void processComponent(ComponentType compType, OperationCode oc, Parameter parameter, CAPDialog capDialog, Long invokeId, Long linkedId, Invoke linkedInvoke) throws CAPParsingComponentException {
        CAPDialogGprsImpl capDialogGprsImpl = (CAPDialogGprsImpl)capDialog;
        Long ocValue = oc.getLocalOperationCode();
        if (ocValue == null) {
            new CAPParsingComponentException("", CAPParsingComponentExceptionReason.UnrecognizedOperation);
        }
        CAPApplicationContext acn = capDialog.getApplicationContext();
        int ocValueInt = (int)ocValue.longValue();
        switch (ocValueInt) {
            case 78: {
                if (acn != CAPApplicationContext.CapV3_gprsSSF_gsmSCF || compType != ComponentType.Invoke) break;
                this.initialDpGprsRequest(parameter, capDialogGprsImpl, invokeId);
                break;
            }
            case 81: {
                if (acn != CAPApplicationContext.CapV3_gprsSSF_gsmSCF && acn != CAPApplicationContext.CapV3_gsmSCF_gprsSSF || compType != ComponentType.Invoke) break;
                this.requestReportGPRSEventRequest(parameter, capDialogGprsImpl, invokeId);
                break;
            }
            case 71: {
                if (acn != CAPApplicationContext.CapV3_gprsSSF_gsmSCF && acn != CAPApplicationContext.CapV3_gsmSCF_gprsSSF || compType != ComponentType.Invoke) break;
                this.applyChargingGPRSRequest(parameter, capDialogGprsImpl, invokeId);
                break;
            }
            case 76: {
                if (acn != CAPApplicationContext.CapV3_gprsSSF_gsmSCF && acn != CAPApplicationContext.CapV3_gsmSCF_gprsSSF) break;
                if (compType == ComponentType.Invoke) {
                    this.entityReleasedGPRSRequest(parameter, capDialogGprsImpl, invokeId);
                }
                if (compType != ComponentType.ReturnResultLast) break;
                this.entityReleasedGPRSResponse(parameter, capDialogGprsImpl, invokeId);
                break;
            }
            case 74: {
                if (acn != CAPApplicationContext.CapV3_gprsSSF_gsmSCF && acn != CAPApplicationContext.CapV3_gsmSCF_gprsSSF || compType != ComponentType.Invoke) break;
                this.connectGPRSRequest(parameter, capDialogGprsImpl, invokeId);
                break;
            }
            case 75: {
                if (acn != CAPApplicationContext.CapV3_gprsSSF_gsmSCF && acn != CAPApplicationContext.CapV3_gsmSCF_gprsSSF || compType != ComponentType.Invoke) break;
                this.continueGPRSRequest(parameter, capDialogGprsImpl, invokeId);
                break;
            }
            case 79: {
                if (acn != CAPApplicationContext.CapV3_gprsSSF_gsmSCF && acn != CAPApplicationContext.CapV3_gsmSCF_gprsSSF || compType != ComponentType.Invoke) break;
                this.releaseGPRSRequest(parameter, capDialogGprsImpl, invokeId);
                break;
            }
            case 82: {
                if (acn != CAPApplicationContext.CapV3_gprsSSF_gsmSCF && acn != CAPApplicationContext.CapV3_gsmSCF_gprsSSF || compType != ComponentType.Invoke) break;
                this.resetTimerGPRSRequest(parameter, capDialogGprsImpl, invokeId);
                break;
            }
            case 77: {
                if (acn != CAPApplicationContext.CapV3_gprsSSF_gsmSCF && acn != CAPApplicationContext.CapV3_gsmSCF_gprsSSF || compType != ComponentType.Invoke) break;
                this.furnishChargingInformationGPRSRequest(parameter, capDialogGprsImpl, invokeId);
                break;
            }
            case 73: {
                if (acn != CAPApplicationContext.CapV3_gprsSSF_gsmSCF && acn != CAPApplicationContext.CapV3_gsmSCF_gprsSSF || compType != ComponentType.Invoke) break;
                this.cancelGPRSRequest(parameter, capDialogGprsImpl, invokeId);
                break;
            }
            case 83: {
                if (acn != CAPApplicationContext.CapV3_gprsSSF_gsmSCF && acn != CAPApplicationContext.CapV3_gsmSCF_gprsSSF || compType != ComponentType.Invoke) break;
                this.sendChargingInformationGPRSRequest(parameter, capDialogGprsImpl, invokeId);
                break;
            }
            case 72: {
                if (acn != CAPApplicationContext.CapV3_gprsSSF_gsmSCF && acn != CAPApplicationContext.CapV3_gsmSCF_gprsSSF) break;
                if (compType == ComponentType.Invoke) {
                    this.applyChargingReportGPRSRequest(parameter, capDialogGprsImpl, invokeId);
                }
                if (compType != ComponentType.ReturnResultLast) break;
                this.applyChargingReportGPRSResponse(parameter, capDialogGprsImpl, invokeId);
                break;
            }
            case 80: {
                if (acn != CAPApplicationContext.CapV3_gprsSSF_gsmSCF && acn != CAPApplicationContext.CapV3_gsmSCF_gprsSSF) break;
                if (compType == ComponentType.Invoke) {
                    this.eventReportGPRSRequest(parameter, capDialogGprsImpl, invokeId);
                }
                if (compType != ComponentType.ReturnResultLast) break;
                this.eventReportGPRSResponse(parameter, capDialogGprsImpl, invokeId);
                break;
            }
            case 70: {
                if (acn != CAPApplicationContext.CapV3_gprsSSF_gsmSCF && acn != CAPApplicationContext.CapV3_gsmSCF_gprsSSF) break;
                if (compType == ComponentType.Invoke) {
                    this.activityTestRequest(parameter, capDialogGprsImpl, invokeId);
                }
                if (compType != ComponentType.ReturnResultLast) break;
                this.activityTestResponse(parameter, capDialogGprsImpl, invokeId);
                break;
            }
            default: {
                throw new CAPParsingComponentException("", CAPParsingComponentExceptionReason.UnrecognizedOperation);
            }
        }
    }

    private void initialDpGprsRequest(Parameter parameter, CAPDialogGprsImpl capDialogImpl, Long invokeId) throws CAPParsingComponentException {
        if (parameter == null) {
            throw new CAPParsingComponentException("Error while decoding initialDpGprsRequest: Parameter is mandatory but not found", CAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new CAPParsingComponentException("Error while decoding initialDpGprsRequest: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), CAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        InitialDpGprsRequestImpl ind = new InitialDpGprsRequestImpl();
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setCAPDialog(capDialogImpl);
        for (CAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onCAPMessage((CAPMessage)ind);
                ((CAPServiceGprsListener)serLis).onInitialDpGprsRequest((InitialDpGprsRequest)ind);
            }
            catch (Exception e) {
                this.loger.error((Object)("Error processing initialDpRequest: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void requestReportGPRSEventRequest(Parameter parameter, CAPDialogGprsImpl capDialogImpl, Long invokeId) throws CAPParsingComponentException {
        if (parameter == null) {
            throw new CAPParsingComponentException("Error while decoding requestReportGPRSEventRequest: Parameter is mandatory but not found", CAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new CAPParsingComponentException("Error while decoding requestReportGPRSEventRequest: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), CAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        RequestReportGPRSEventRequestImpl ind = new RequestReportGPRSEventRequestImpl();
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setCAPDialog(capDialogImpl);
        for (CAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onCAPMessage((CAPMessage)ind);
                ((CAPServiceGprsListener)serLis).onRequestReportGPRSEventRequest((RequestReportGPRSEventRequest)ind);
            }
            catch (Exception e) {
                this.loger.error((Object)("Error processing requestReportGPRSEventRequest: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void applyChargingGPRSRequest(Parameter parameter, CAPDialogGprsImpl capDialogImpl, Long invokeId) throws CAPParsingComponentException {
        if (parameter == null) {
            throw new CAPParsingComponentException("Error while decoding applyChargingGPRSRequest: Parameter is mandatory but not found", CAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new CAPParsingComponentException("Error while decoding applyChargingGPRSRequest: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), CAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        ApplyChargingGPRSRequestImpl ind = new ApplyChargingGPRSRequestImpl();
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setCAPDialog(capDialogImpl);
        for (CAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onCAPMessage((CAPMessage)ind);
                ((CAPServiceGprsListener)serLis).onApplyChargingGPRSRequest((ApplyChargingGPRSRequest)ind);
            }
            catch (Exception e) {
                this.loger.error((Object)("Error processing applyChargingGPRSRequest: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void entityReleasedGPRSRequest(Parameter parameter, CAPDialogGprsImpl capDialogImpl, Long invokeId) throws CAPParsingComponentException {
        if (parameter == null) {
            throw new CAPParsingComponentException("Error while decoding entityReleasedGPRSRequest: Parameter is mandatory but not found", CAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new CAPParsingComponentException("Error while decoding entityReleasedGPRSRequest: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), CAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        EntityReleasedGPRSRequestImpl ind = new EntityReleasedGPRSRequestImpl();
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setCAPDialog(capDialogImpl);
        for (CAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onCAPMessage((CAPMessage)ind);
                ((CAPServiceGprsListener)serLis).onEntityReleasedGPRSRequest((EntityReleasedGPRSRequest)ind);
            }
            catch (Exception e) {
                this.loger.error((Object)("Error processing entityReleasedGPRSRequest: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void entityReleasedGPRSResponse(Parameter parameter, CAPDialogGprsImpl capDialogImpl, Long invokeId) throws CAPParsingComponentException {
        EntityReleasedGPRSResponseImpl ind = new EntityReleasedGPRSResponseImpl();
        ind.setInvokeId(invokeId);
        ind.setCAPDialog(capDialogImpl);
        for (CAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onCAPMessage((CAPMessage)ind);
                ((CAPServiceGprsListener)serLis).onEntityReleasedGPRSResponse((EntityReleasedGPRSResponse)ind);
            }
            catch (Exception e) {
                this.loger.error((Object)("Error processing entityReleasedGPRSResponse: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void connectGPRSRequest(Parameter parameter, CAPDialogGprsImpl capDialogImpl, Long invokeId) throws CAPParsingComponentException {
        if (parameter == null) {
            throw new CAPParsingComponentException("Error while decoding connectGPRSRequest: Parameter is mandatory but not found", CAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new CAPParsingComponentException("Error while decoding connectGPRSRequest: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), CAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        ConnectGPRSRequestImpl ind = new ConnectGPRSRequestImpl();
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setCAPDialog(capDialogImpl);
        for (CAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onCAPMessage((CAPMessage)ind);
                ((CAPServiceGprsListener)serLis).onConnectGPRSRequest((ConnectGPRSRequest)ind);
            }
            catch (Exception e) {
                this.loger.error((Object)("Error processing connectGPRSRequest: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void continueGPRSRequest(Parameter parameter, CAPDialogGprsImpl capDialogImpl, Long invokeId) throws CAPParsingComponentException {
        if (parameter == null) {
            throw new CAPParsingComponentException("Error while decoding continueGPRSRequest: Parameter is mandatory but not found", CAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new CAPParsingComponentException("Error while decoding continueGPRSRequest: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), CAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        ContinueGPRSRequestImpl ind = new ContinueGPRSRequestImpl();
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setCAPDialog(capDialogImpl);
        for (CAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onCAPMessage((CAPMessage)ind);
                ((CAPServiceGprsListener)serLis).onContinueGPRSRequest((ContinueGPRSRequest)ind);
            }
            catch (Exception e) {
                this.loger.error((Object)("Error processing continueGPRSRequest: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void releaseGPRSRequest(Parameter parameter, CAPDialogGprsImpl capDialogImpl, Long invokeId) throws CAPParsingComponentException {
        if (parameter == null) {
            throw new CAPParsingComponentException("Error while decoding releaseGPRSRequest: Parameter is mandatory but not found", CAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new CAPParsingComponentException("Error while decoding releaseGPRSRequest: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), CAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        ReleaseGPRSRequestImpl ind = new ReleaseGPRSRequestImpl();
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setCAPDialog(capDialogImpl);
        for (CAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onCAPMessage((CAPMessage)ind);
                ((CAPServiceGprsListener)serLis).onReleaseGPRSRequest((ReleaseGPRSRequest)ind);
            }
            catch (Exception e) {
                this.loger.error((Object)("Error processing releaseGPRSRequest: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void resetTimerGPRSRequest(Parameter parameter, CAPDialogGprsImpl capDialogImpl, Long invokeId) throws CAPParsingComponentException {
        if (parameter == null) {
            throw new CAPParsingComponentException("Error while decoding resetTimerGPRSRequest: Parameter is mandatory but not found", CAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new CAPParsingComponentException("Error while decoding resetTimerGPRSRequest: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), CAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        ResetTimerGPRSRequestImpl ind = new ResetTimerGPRSRequestImpl();
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setCAPDialog(capDialogImpl);
        for (CAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onCAPMessage((CAPMessage)ind);
                ((CAPServiceGprsListener)serLis).onResetTimerGPRSRequest((ResetTimerGPRSRequest)ind);
            }
            catch (Exception e) {
                this.loger.error((Object)("Error processing resetTimerGPRSRequest: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void furnishChargingInformationGPRSRequest(Parameter parameter, CAPDialogGprsImpl capDialogImpl, Long invokeId) throws CAPParsingComponentException {
        if (parameter == null) {
            throw new CAPParsingComponentException("Error while decoding furnishChargingInformationGPRSRequest: Parameter is mandatory but not found", CAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 4 || parameter.getTagClass() != 0 || !parameter.isPrimitive()) {
            throw new CAPParsingComponentException("Error while decoding furnishChargingInformationGPRSRequest: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), CAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        FurnishChargingInformationGPRSRequestImpl ind = new FurnishChargingInformationGPRSRequestImpl();
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setCAPDialog(capDialogImpl);
        for (CAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onCAPMessage((CAPMessage)ind);
                ((CAPServiceGprsListener)serLis).onFurnishChargingInformationGPRSRequest((FurnishChargingInformationGPRSRequest)ind);
            }
            catch (Exception e) {
                this.loger.error((Object)("Error processing furnishChargingInformationGPRSRequest: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void cancelGPRSRequest(Parameter parameter, CAPDialogGprsImpl capDialogImpl, Long invokeId) throws CAPParsingComponentException {
        if (parameter == null) {
            throw new CAPParsingComponentException("Error while decoding cancelGPRSRequest: Parameter is mandatory but not found", CAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new CAPParsingComponentException("Error while decoding cancelGPRSRequest: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), CAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        CancelGPRSRequestImpl ind = new CancelGPRSRequestImpl();
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setCAPDialog(capDialogImpl);
        for (CAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onCAPMessage((CAPMessage)ind);
                ((CAPServiceGprsListener)serLis).onCancelGPRSRequest((CancelGPRSRequest)ind);
            }
            catch (Exception e) {
                this.loger.error((Object)("Error processing cancelGPRSRequest: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void sendChargingInformationGPRSRequest(Parameter parameter, CAPDialogGprsImpl capDialogImpl, Long invokeId) throws CAPParsingComponentException {
        if (parameter == null) {
            throw new CAPParsingComponentException("Error while decoding sendChargingInformationGPRSRequest: Parameter is mandatory but not found", CAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new CAPParsingComponentException("Error while decoding sendChargingInformationGPRSRequest: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), CAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        SendChargingInformationGPRSRequestImpl ind = new SendChargingInformationGPRSRequestImpl();
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setCAPDialog(capDialogImpl);
        for (CAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onCAPMessage((CAPMessage)ind);
                ((CAPServiceGprsListener)serLis).onSendChargingInformationGPRSRequest((SendChargingInformationGPRSRequest)ind);
            }
            catch (Exception e) {
                this.loger.error((Object)("Error processing sendChargingInformationGPRSRequest: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void applyChargingReportGPRSRequest(Parameter parameter, CAPDialogGprsImpl capDialogImpl, Long invokeId) throws CAPParsingComponentException {
        if (parameter == null) {
            throw new CAPParsingComponentException("Error while decoding applyChargingReportGPRSRequest: Parameter is mandatory but not found", CAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new CAPParsingComponentException("Error while decoding applyChargingReportGPRSRequest: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), CAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        ApplyChargingReportGPRSRequestImpl ind = new ApplyChargingReportGPRSRequestImpl();
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setCAPDialog(capDialogImpl);
        for (CAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onCAPMessage((CAPMessage)ind);
                ((CAPServiceGprsListener)serLis).onApplyChargingReportGPRSRequest((ApplyChargingReportGPRSRequest)ind);
            }
            catch (Exception e) {
                this.loger.error((Object)("Error processing applyChargingReportGPRSRequest: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void applyChargingReportGPRSResponse(Parameter parameter, CAPDialogGprsImpl capDialogImpl, Long invokeId) throws CAPParsingComponentException {
        ApplyChargingReportGPRSResponseImpl ind = new ApplyChargingReportGPRSResponseImpl();
        ind.setInvokeId(invokeId);
        ind.setCAPDialog(capDialogImpl);
        for (CAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onCAPMessage((CAPMessage)ind);
                ((CAPServiceGprsListener)serLis).onApplyChargingReportGPRSResponse((ApplyChargingReportGPRSResponse)ind);
            }
            catch (Exception e) {
                this.loger.error((Object)("Error processing applyChargingReportGPRSResponse: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void eventReportGPRSRequest(Parameter parameter, CAPDialogGprsImpl capDialogImpl, Long invokeId) throws CAPParsingComponentException {
        if (parameter == null) {
            throw new CAPParsingComponentException("Error while decoding eventReportGPRSRequest: Parameter is mandatory but not found", CAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new CAPParsingComponentException("Error while decoding eventReportGPRSRequest: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), CAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        EventReportGPRSRequestImpl ind = new EventReportGPRSRequestImpl();
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setCAPDialog(capDialogImpl);
        for (CAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onCAPMessage((CAPMessage)ind);
                ((CAPServiceGprsListener)serLis).onEventReportGPRSRequest((EventReportGPRSRequest)ind);
            }
            catch (Exception e) {
                this.loger.error((Object)("Error processing eventReportGPRSRequest: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void eventReportGPRSResponse(Parameter parameter, CAPDialogGprsImpl capDialogImpl, Long invokeId) throws CAPParsingComponentException {
        EventReportGPRSResponseImpl ind = new EventReportGPRSResponseImpl();
        ind.setInvokeId(invokeId);
        ind.setCAPDialog(capDialogImpl);
        for (CAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onCAPMessage((CAPMessage)ind);
                ((CAPServiceGprsListener)serLis).onEventReportGPRSResponse((EventReportGPRSResponse)ind);
            }
            catch (Exception e) {
                this.loger.error((Object)("Error processing eventReportGPRSResponse: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void activityTestRequest(Parameter parameter, CAPDialogGprsImpl capDialogImpl, Long invokeId) throws CAPParsingComponentException {
        ActivityTestGPRSRequestImpl ind = new ActivityTestGPRSRequestImpl();
        ind.setInvokeId(invokeId);
        ind.setCAPDialog(capDialogImpl);
        for (CAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onCAPMessage((CAPMessage)ind);
                ((CAPServiceGprsListener)serLis).onActivityTestGPRSRequest((ActivityTestGPRSRequest)ind);
            }
            catch (Exception e) {
                this.loger.error((Object)("Error processing activityTestGPRSRequest: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void activityTestResponse(Parameter parameter, CAPDialogGprsImpl capDialogImpl, Long invokeId) throws CAPParsingComponentException {
        ActivityTestGPRSResponseImpl ind = new ActivityTestGPRSResponseImpl();
        ind.setInvokeId(invokeId);
        ind.setCAPDialog(capDialogImpl);
        for (CAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onCAPMessage((CAPMessage)ind);
                ((CAPServiceGprsListener)serLis).onActivityTestGPRSResponse((ActivityTestGPRSResponse)ind);
            }
            catch (Exception e) {
                this.loger.error((Object)("Error processing activityTestGPRSResponse: " + e.getMessage()), (Throwable)e);
            }
        }
    }
}

