/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.service.gprs.primitive;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.api.service.gprs.primitive.GPRSQoS;
import org.mobicents.protocols.ss7.cap.primitives.CAPAsnPrimitive;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.ExtQoSSubscribed;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.QoSSubscribed;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement.ExtQoSSubscribedImpl;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement.QoSSubscribedImpl;

public class GPRSQoSImpl
implements GPRSQoS,
CAPAsnPrimitive {
    public static final String _PrimitiveName = "GPRSQoS";
    public static final int _ID_shortQoSFormat = 0;
    public static final int _ID_longQoSFormat = 1;
    private QoSSubscribed shortQoSFormat;
    private ExtQoSSubscribed longQoSFormat;

    public GPRSQoSImpl() {
    }

    public GPRSQoSImpl(QoSSubscribed shortQoSFormat) {
        this.shortQoSFormat = shortQoSFormat;
    }

    public GPRSQoSImpl(ExtQoSSubscribed longQoSFormat) {
        this.longQoSFormat = longQoSFormat;
    }

    public QoSSubscribed getShortQoSFormat() {
        return this.shortQoSFormat;
    }

    public ExtQoSSubscribed getLongQoSFormat() {
        return this.longQoSFormat;
    }

    @Override
    public int getTag() throws CAPException {
        if (this.shortQoSFormat != null) {
            return 0;
        }
        return 1;
    }

    @Override
    public int getTagClass() {
        return 2;
    }

    @Override
    public boolean getIsPrimitive() {
        return true;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws CAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding GPRSQoS: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding GPRSQoS: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (MAPParsingComponentException e) {
            throw new CAPParsingComponentException("MAPParsingComponentException when decoding GPRSQoS: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws CAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding GPRSQoS: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding GPRSQoS: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (MAPParsingComponentException e) {
            throw new CAPParsingComponentException("MAPParsingComponentException when decoding GPRSQoS: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ais, int length) throws CAPParsingComponentException, IOException, AsnException, MAPParsingComponentException {
        block7: {
            block6: {
                this.shortQoSFormat = null;
                this.longQoSFormat = null;
                int tag = ais.getTag();
                if (ais.getTagClass() != 2) break block6;
                switch (tag) {
                    case 0: {
                        if (!ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding GPRSQoS.shortQoSFormat: Parameter is not primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.shortQoSFormat = new QoSSubscribedImpl();
                        ((QoSSubscribedImpl)this.shortQoSFormat).decodeData(ais, length);
                        break block7;
                    }
                    case 1: {
                        if (!ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding GPRSQoS.longQoSFormat: Parameter is not primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.longQoSFormat = new ExtQoSSubscribedImpl();
                        ((ExtQoSSubscribedImpl)this.longQoSFormat).decodeData(ais, length);
                        break block7;
                    }
                    default: {
                        throw new CAPParsingComponentException("Error while decoding GPRSQoS: bad choice tag", CAPParsingComponentExceptionReason.MistypedParameter);
                    }
                }
            }
            throw new CAPParsingComponentException("Error while decoding GPRSQoS: bad choice tagClass", CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws CAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws CAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding GPRSQoS: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws CAPException {
        if (this.shortQoSFormat == null && this.longQoSFormat == null || this.shortQoSFormat != null && this.longQoSFormat != null) {
            throw new CAPException("Error while decoding GPRSQoS: One and only one choice must be selected");
        }
        try {
            if (this.shortQoSFormat != null) {
                ((QoSSubscribedImpl)this.shortQoSFormat).encodeData(asnOs);
            } else {
                ((ExtQoSSubscribedImpl)this.longQoSFormat).encodeData(asnOs);
            }
        }
        catch (MAPException e) {
            throw new CAPException("MAPException when encoding GPRSQoS: " + e.getMessage(), (Throwable)e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("GPRSQoS [");
        if (this.shortQoSFormat != null) {
            sb.append("shortQoSFormat=");
            sb.append(this.shortQoSFormat.toString());
        }
        if (this.longQoSFormat != null) {
            sb.append("longQoSFormat=");
            sb.append(this.longQoSFormat.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

