/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.sccp.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javolution.util.FastList;
import javolution.util.FastMap;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.mobicents.protocols.ss7.indicator.RoutingIndicator;
import org.mobicents.protocols.ss7.mtp.Mtp3StatusCause;
import org.mobicents.protocols.ss7.sccp.ConcernedSignalingPointCode;
import org.mobicents.protocols.ss7.sccp.Mtp3ServiceAccessPoint;
import org.mobicents.protocols.ss7.sccp.RemoteSccpStatus;
import org.mobicents.protocols.ss7.sccp.RemoteSignalingPointCode;
import org.mobicents.protocols.ss7.sccp.RemoteSubSystem;
import org.mobicents.protocols.ss7.sccp.SccpListener;
import org.mobicents.protocols.ss7.sccp.SccpManagementEventListener;
import org.mobicents.protocols.ss7.sccp.SignallingPointStatus;
import org.mobicents.protocols.ss7.sccp.impl.ConcernedSignalingPointCodeMap;
import org.mobicents.protocols.ss7.sccp.impl.RemoteSignalingPointCodeImpl;
import org.mobicents.protocols.ss7.sccp.impl.RemoteSubSystemImpl;
import org.mobicents.protocols.ss7.sccp.impl.RemoteSubSystemMap;
import org.mobicents.protocols.ss7.sccp.impl.SccpProviderImpl;
import org.mobicents.protocols.ss7.sccp.impl.SccpRoutingControl;
import org.mobicents.protocols.ss7.sccp.impl.SccpStackImpl;
import org.mobicents.protocols.ss7.sccp.impl.message.SccpDataMessageImpl;
import org.mobicents.protocols.ss7.sccp.impl.message.SccpMessageImpl;
import org.mobicents.protocols.ss7.sccp.message.SccpDataMessage;
import org.mobicents.protocols.ss7.sccp.message.SccpMessage;
import org.mobicents.protocols.ss7.sccp.parameter.SccpAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SccpManagement {
    private final Logger logger;
    protected static final int MTP3_PAUSE = 3;
    protected static final int MTP3_RESUME = 4;
    protected static final int MTP3_STATUS = 5;
    protected static final int SSA = 1;
    protected static final int SSP = 2;
    protected static final int SST = 3;
    protected static final int SOR = 4;
    protected static final int SOG = 5;
    protected static final int SSC = 6;
    private static final String S_SSA = "SSA";
    private static final String S_SSP = "SSP";
    private static final String S_SST = "SST";
    private static final String S_SOR = "SOR";
    private static final String S_SOG = "SOG";
    private static final String S_SSC = "SSC";
    private static final String S_DEFAULT = "UNIDENTIFIED";
    protected static final int UNAVAILABILITY_CAUSE_UNKNOWN = 0;
    protected static final int UNAVAILABILITY_CAUSE_UNEQUIPED = 1;
    protected static final int UNAVAILABILITY_CAUSE_INACCESSIBLE = 2;
    private static final int ALL_POINT_CODE = -1;
    private SccpProviderImpl sccpProviderImpl;
    private SccpStackImpl sccpStackImpl;
    private SccpRoutingControl sccpRoutingControl;
    private ScheduledExecutorService managementExecutors;
    private final FastMap<Integer, FastList<SubSystemTest>> dpcVsSst = new FastMap();
    private final FastMap<DpcSsn, Long> dpcSspSent = new FastMap();
    private final String name;

    public SccpManagement(String name, SccpProviderImpl sccpProviderImpl, SccpStackImpl sccpStackImpl) {
        this.name = name;
        this.logger = Logger.getLogger((String)(SccpManagement.class.getCanonicalName() + "-" + this.name));
        this.sccpProviderImpl = sccpProviderImpl;
        this.sccpStackImpl = sccpStackImpl;
    }

    public SccpRoutingControl getSccpRoutingControl() {
        return this.sccpRoutingControl;
    }

    public void setSccpRoutingControl(SccpRoutingControl sccpRoutingControl) {
        this.sccpRoutingControl = sccpRoutingControl;
    }

    public void onManagementMessage(SccpDataMessage message) {
        byte[] data = message.getData();
        int messgType = data[0] & 0xFF;
        int affectedSsn = data[1] & 0xFF;
        int affectedPc = data[2] & 0xFF | (data[3] & 0xFF) << 8;
        int subsystemMultiplicity = data[3] & 0xFF;
        switch (messgType) {
            case 1: {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)String.format("Rx : SSA, Affected SSN=%d, Affected PC=%d, Subsystem Multiplicity Ind=%d SeqControl=%d", affectedSsn, affectedPc, subsystemMultiplicity, message.getSls()));
                }
                this.cancelSst(affectedPc, affectedSsn);
                if (affectedSsn == 1) {
                    this.allowRsp(affectedPc, false, RemoteSccpStatus.available);
                    break;
                }
                this.allowSsn(affectedPc, affectedSsn);
                break;
            }
            case 2: {
                if (this.logger.isEnabledFor((Priority)Level.WARN)) {
                    this.logger.warn((Object)String.format("Rx : SSP, Affected SSN=%d, Affected PC=%d, Subsystem Multiplicity Ind=%d SeqControl=%d", affectedSsn, affectedPc, subsystemMultiplicity, message.getSls()));
                }
                if (affectedSsn == 1) break;
                this.prohibitSsn(affectedPc, affectedSsn);
                this.startSst(affectedPc, affectedSsn);
                break;
            }
            case 3: {
                if (affectedSsn == 1) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info((Object)String.format("Rx : SST, Affected SSN=%d, Affected PC=%d, Subsystem Multiplicity Ind=%d SeqControl=%d", affectedSsn, affectedPc, subsystemMultiplicity, message.getSls()));
                    }
                    this.sendSSA((SccpMessage)message, affectedSsn);
                    break;
                }
                SccpListener listener = this.sccpProviderImpl.getSccpListener(affectedSsn);
                if (listener != null) {
                    this.sendSSA((SccpMessage)message, affectedSsn);
                    return;
                }
                if (!this.logger.isInfoEnabled()) break;
                this.logger.info((Object)String.format("Received SST for unavailable SSN=%d", affectedSsn));
                break;
            }
            case 4: {
                if (!this.logger.isEnabledFor((Priority)Level.WARN)) break;
                this.logger.warn((Object)"Received SOR. SOR not yet implemented, dropping message");
                break;
            }
            case 5: {
                if (!this.logger.isEnabledFor((Priority)Level.WARN)) break;
                this.logger.warn((Object)"Received SOG. SOG not yet implemented, dropping message");
                break;
            }
            case 6: {
                if (!this.logger.isEnabledFor((Priority)Level.WARN)) break;
                this.logger.warn((Object)"Received SSC. SSC not yet implemented, dropping message");
                break;
            }
            default: {
                this.logger.error((Object)"Received SCMG with unknown MessageType.");
            }
        }
    }

    private void sendManagementMessage(int dpc, int messageTypeCode, int affectedSsn, int subsystemMultiplicityIndicator) {
        Mtp3ServiceAccessPoint sap = this.sccpStackImpl.router.findMtp3ServiceAccessPoint(dpc, 0);
        if (sap == null) {
            this.logger.warn((Object)String.format("Failed sendManagementMessage : Mtp3ServiceAccessPoint has not found for dpc=%d", dpc));
            return;
        }
        int affectedPc = messageTypeCode == 3 || messageTypeCode == 5 ? dpc : sap.getOpc();
        SccpAddress calledAdd = new SccpAddress(RoutingIndicator.ROUTING_BASED_ON_DPC_AND_SSN, dpc, null, 1);
        SccpAddress callingAdd = new SccpAddress(RoutingIndicator.ROUTING_BASED_ON_DPC_AND_SSN, affectedPc, null, 1);
        byte[] data = new byte[]{(byte)messageTypeCode, (byte)affectedSsn, (byte)(affectedPc & 0xFF), (byte)((affectedPc & 0xFF00) >> 8), (byte)subsystemMultiplicityIndicator};
        SccpDataMessageImpl msg = (SccpDataMessageImpl)this.sccpProviderImpl.getMessageFactory().createDataMessageClass0(calledAdd, callingAdd, data, -1, false, null, null);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)String.format("Tx :SCMG Type=%d, Affected SSN=%d, AffectedPc=%d", messageTypeCode, affectedSsn, affectedPc));
        }
        try {
            this.sccpRoutingControl.sendMessageToMtp(msg);
        }
        catch (IOException e) {
            this.logger.error((Object)String.format("Exception while trying to send SSP message=%s", msg), (Throwable)e);
        }
    }

    private void sendSSA(SccpMessage msg, int affectedSsn) {
        this.sendManagementMessage(((SccpMessageImpl)msg).getIncomingOpc(), 1, affectedSsn, 0);
    }

    protected void broadcastChangedSsnState(int affectedSsn, boolean inService) {
        this.broadcastChangedSsnState(affectedSsn, inService, -1);
    }

    private void broadcastChangedSsnState(int affectedSsn, boolean inService, int concernedPointCode) {
        ConcernedSignalingPointCodeMap<Integer, ConcernedSignalingPointCode> lst = this.sccpStackImpl.sccpResource.concernedSpcs;
        FastMap.Entry e = lst.head();
        FastMap.Entry end = lst.tail();
        while ((e = e.getNext()) != end) {
            ConcernedSignalingPointCode concernedSubSystem = (ConcernedSignalingPointCode)e.getValue();
            int dpc = concernedSubSystem.getRemoteSpc();
            if (concernedPointCode != -1 && concernedPointCode != dpc) continue;
            if (inService) {
                this.sendManagementMessage(dpc, 1, affectedSsn, 0);
                continue;
            }
            this.sendManagementMessage(dpc, 2, affectedSsn, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recdMsgForProhibitedSsn(SccpMessage msg, int ssn) {
        int dpc = msg.getIncomingOpc();
        DpcSsn key = new DpcSsn(dpc, ssn);
        long now = System.currentTimeMillis();
        FastMap<DpcSsn, Long> fastMap = this.dpcSspSent;
        synchronized (fastMap) {
            Long dt = (Long)this.dpcSspSent.get((Object)key);
            if (dt != null && now - dt < 1000L) {
                return;
            }
            this.dpcSspSent.put((Object)key, (Object)now);
        }
        if (msg.getIsMtpOriginated()) {
            this.sendManagementMessage(dpc, 2, ssn, 0);
        }
    }

    protected void handleMtp3Pause(int affectedPc) {
        this.cancelAllSst(affectedPc, true);
        this.prohibitRsp(affectedPc, true, RemoteSccpStatus.inaccessible);
    }

    protected void handleMtp3Resume(int affectedPc) {
        this.allowRsp(affectedPc, true, RemoteSccpStatus.available);
        FastMap<Integer, SccpListener> lstrs = this.sccpProviderImpl.getAllSccpListeners();
        FastMap.Entry e1 = lstrs.head();
        FastMap.Entry end1 = lstrs.tail();
        while ((e1 = e1.getNext()) != end1) {
            int affectedSsn = (Integer)e1.getKey();
            this.broadcastChangedSsnState(affectedSsn, true, affectedPc);
        }
    }

    protected void handleMtp3Status(Mtp3StatusCause cause, int affectedPc, int congStatus) {
        switch (cause) {
            case SignallingNetworkCongested: {
                break;
            }
            case UserPartUnavailability_Unknown: 
            case UserPartUnavailability_InaccessibleRemoteUser: {
                this.prohibitRsp(affectedPc, false, cause == Mtp3StatusCause.UserPartUnavailability_Unknown ? RemoteSccpStatus.unavailableReasonUnknown : RemoteSccpStatus.inaccessible);
                SubSystemTest sstForSsn1 = this.cancelAllSst(affectedPc, false);
                if (sstForSsn1 != null) {
                    sstForSsn1.setRecdMtpStatusResp(true);
                    break;
                }
                this.startSst(affectedPc, 1);
                break;
            }
            case UserPartUnavailability_UnequippedRemoteUser: {
                this.prohibitRsp(affectedPc, false, RemoteSccpStatus.unequipped);
                this.cancelAllSst(affectedPc, true);
            }
        }
    }

    private void prohibitAllSsn(int affectedPc) {
        FastMap<Integer, SccpListener> lstrs = this.sccpProviderImpl.getAllSccpListeners();
        RemoteSubSystemMap<Integer, RemoteSubSystem> remoteSsns = this.sccpStackImpl.sccpResource.remoteSsns;
        FastMap.Entry e = remoteSsns.head();
        FastMap.Entry end = remoteSsns.tail();
        while ((e = e.getNext()) != end) {
            RemoteSubSystemImpl remoteSsn = (RemoteSubSystemImpl)e.getValue();
            if (remoteSsn.getRemoteSpc() != affectedPc || remoteSsn.isRemoteSsnProhibited()) continue;
            remoteSsn.setRemoteSsnProhibited(true);
            this.setRemoteSsnState(remoteSsn, false);
        }
    }

    private void allowAllSsn(int affectedPc) {
        FastMap<Integer, SccpListener> lstrs = this.sccpProviderImpl.getAllSccpListeners();
        RemoteSubSystemMap<Integer, RemoteSubSystem> remoteSsns = this.sccpStackImpl.sccpResource.remoteSsns;
        FastMap.Entry e = remoteSsns.head();
        FastMap.Entry end = remoteSsns.tail();
        while ((e = e.getNext()) != end) {
            RemoteSubSystemImpl remoteSsn = (RemoteSubSystemImpl)e.getValue();
            if (remoteSsn.getRemoteSpc() != affectedPc) continue;
            if (remoteSsn.getMarkProhibitedWhenSpcResuming()) {
                if (remoteSsn.isRemoteSsnProhibited()) continue;
                remoteSsn.setRemoteSsnProhibited(true);
                this.startSst(affectedPc, remoteSsn.getRemoteSsn());
                this.setRemoteSsnState(remoteSsn, false);
                continue;
            }
            if (!remoteSsn.isRemoteSsnProhibited()) continue;
            remoteSsn.setRemoteSsnProhibited(false);
            this.setRemoteSsnState(remoteSsn, true);
        }
    }

    private void prohibitRsp(int affectedPc, boolean spcChanging, RemoteSccpStatus remoteSccpStatus) {
        RemoteSignalingPointCodeImpl remoteSpc = (RemoteSignalingPointCodeImpl)this.sccpStackImpl.getSccpResource().getRemoteSpcByPC(affectedPc);
        if (remoteSpc != null) {
            boolean oldRemoteSpcProhibited = remoteSpc.isRemoteSpcProhibited();
            boolean oldRemoteSccpProhibited = remoteSpc.isRemoteSccpProhibited();
            if (spcChanging) {
                remoteSpc.setRemoteSpcProhibited(true);
            }
            if (remoteSccpStatus != null && remoteSccpStatus != RemoteSccpStatus.available) {
                remoteSpc.setRemoteSccpProhibited(true);
            }
            FastMap<Integer, SccpListener> lstrs = this.sccpProviderImpl.getAllSccpListeners();
            FastMap.Entry e1 = lstrs.head();
            FastMap.Entry end1 = lstrs.tail();
            while ((e1 = e1.getNext()) != end1) {
                try {
                    ((SccpListener)e1.getValue()).onPcState(affectedPc, remoteSpc.isRemoteSpcProhibited() ? SignallingPointStatus.inaccessible : SignallingPointStatus.accessible, 0, remoteSccpStatus);
                }
                catch (Exception ee) {
                    this.logger.error((Object)"Exception while invoking onPcState", (Throwable)ee);
                }
            }
            for (SccpManagementEventListener lstr : this.sccpProviderImpl.managementEventListeners) {
                try {
                    if (remoteSpc.isRemoteSpcProhibited() != oldRemoteSpcProhibited) {
                        lstr.onRemoteSpcDown((RemoteSignalingPointCode)remoteSpc);
                    }
                }
                catch (Throwable ee) {
                    this.logger.error((Object)"Exception while invoking onRemoteSpcDown", ee);
                }
                try {
                    if (remoteSpc.isRemoteSccpProhibited() == oldRemoteSccpProhibited) continue;
                    lstr.onRemoteSccpDown((RemoteSignalingPointCode)remoteSpc);
                }
                catch (Throwable ee) {
                    this.logger.error((Object)"Exception while invoking onRemoteSccpDown", ee);
                }
            }
        }
        this.prohibitAllSsn(affectedPc);
    }

    private void allowRsp(int affectedPc, boolean spcChanging, RemoteSccpStatus remoteSccpStatus) {
        RemoteSignalingPointCodeImpl remoteSpc = (RemoteSignalingPointCodeImpl)this.sccpStackImpl.getSccpResource().getRemoteSpcByPC(affectedPc);
        if (remoteSpc != null) {
            boolean oldRemoteSpcProhibited = remoteSpc.isRemoteSpcProhibited();
            boolean oldRemoteSccpProhibited = remoteSpc.isRemoteSccpProhibited();
            if (spcChanging) {
                remoteSpc.setRemoteSpcProhibited(false);
            }
            if (remoteSccpStatus != null && remoteSccpStatus == RemoteSccpStatus.available) {
                remoteSpc.setRemoteSccpProhibited(false);
            }
            FastMap<Integer, SccpListener> lstrs = this.sccpProviderImpl.getAllSccpListeners();
            FastMap.Entry e1 = lstrs.head();
            FastMap.Entry end1 = lstrs.tail();
            while ((e1 = e1.getNext()) != end1) {
                try {
                    ((SccpListener)e1.getValue()).onPcState(affectedPc, SignallingPointStatus.accessible, 0, remoteSccpStatus);
                }
                catch (Exception ee) {
                    this.logger.error((Object)"Exception while invoking onPcState", (Throwable)ee);
                }
            }
            for (SccpManagementEventListener lstr : this.sccpProviderImpl.managementEventListeners) {
                try {
                    if (remoteSpc.isRemoteSpcProhibited() != oldRemoteSpcProhibited) {
                        lstr.onRemoteSpcUp((RemoteSignalingPointCode)remoteSpc);
                    }
                }
                catch (Throwable ee) {
                    this.logger.error((Object)"Exception while invoking onRemoteSpcUp", ee);
                }
                try {
                    if (remoteSpc.isRemoteSccpProhibited() == oldRemoteSccpProhibited) continue;
                    lstr.onRemoteSccpUp((RemoteSignalingPointCode)remoteSpc);
                }
                catch (Throwable ee) {
                    this.logger.error((Object)"Exception while invoking onRemoteSccpUp", ee);
                }
            }
        }
        this.allowAllSsn(affectedPc);
    }

    private void prohibitSsn(int affectedPc, int ssn) {
        RemoteSubSystemMap<Integer, RemoteSubSystem> remoteSsns = this.sccpStackImpl.sccpResource.remoteSsns;
        FastMap.Entry e = remoteSsns.head();
        FastMap.Entry end = remoteSsns.tail();
        while ((e = e.getNext()) != end) {
            RemoteSubSystemImpl remoteSsn = (RemoteSubSystemImpl)e.getValue();
            if (remoteSsn.getRemoteSpc() != affectedPc || remoteSsn.getRemoteSsn() != ssn) continue;
            if (remoteSsn.isRemoteSsnProhibited()) break;
            this.setRemoteSsnState(remoteSsn, false);
            break;
        }
    }

    private void setRemoteSsnState(RemoteSubSystemImpl remoteSsn, boolean isEnabled) {
        remoteSsn.setRemoteSsnProhibited(!isEnabled);
        FastMap<Integer, SccpListener> lstrs = this.sccpProviderImpl.getAllSccpListeners();
        FastMap.Entry e1 = lstrs.head();
        FastMap.Entry end1 = lstrs.tail();
        while ((e1 = e1.getNext()) != end1) {
            try {
                ((SccpListener)e1.getValue()).onState(remoteSsn.getRemoteSpc(), remoteSsn.getRemoteSsn(), isEnabled, 0);
            }
            catch (Exception ee) {
                this.logger.error((Object)"Exception while invoking onState", (Throwable)ee);
            }
        }
        for (SccpManagementEventListener lstr : this.sccpProviderImpl.managementEventListeners) {
            try {
                if (isEnabled) {
                    lstr.onRemoteSubSystemUp((RemoteSubSystem)remoteSsn);
                    continue;
                }
                lstr.onRemoteSubSystemDown((RemoteSubSystem)remoteSsn);
            }
            catch (Throwable ee) {
                this.logger.error((Object)"Exception while invoking onRemoteSubSystemUp/Down", ee);
            }
        }
    }

    private void allowSsn(int affectedPc, int ssn) {
        FastMap<Integer, SccpListener> lstrs = this.sccpProviderImpl.getAllSccpListeners();
        RemoteSubSystemMap<Integer, RemoteSubSystem> remoteSsns = this.sccpStackImpl.sccpResource.remoteSsns;
        FastMap.Entry e = remoteSsns.head();
        FastMap.Entry end = remoteSsns.tail();
        while ((e = e.getNext()) != end) {
            RemoteSubSystemImpl remoteSsn = (RemoteSubSystemImpl)e.getValue();
            if (remoteSsn.getRemoteSpc() != affectedPc || ssn != 1 && remoteSsn.getRemoteSsn() != ssn) continue;
            if (!remoteSsn.isRemoteSsnProhibited()) break;
            remoteSsn.setRemoteSsnProhibited(false);
            this.setRemoteSsnState(remoteSsn, true);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startSst(int affectedPc, int affectedSsn) {
        FastList<SubSystemTest> ssts;
        FastList<SubSystemTest> fastList = ssts = this.getSubSystemTestListForAffectedDpc(affectedPc, true);
        synchronized (fastList) {
            SubSystemTest sst = this.getSubSystemTestBySsn(ssts, affectedSsn);
            if (sst == null) {
                sst = new SubSystemTest(affectedSsn, affectedPc, ssts);
                sst.startTest();
            } else {
                sst.resetTimerDuration();
                sst.stopTest();
                sst.startTest();
            }
        }
    }

    private void cancelSst(int affectedPc, int affectedSsn) {
        SubSystemTest sst1;
        FastList<SubSystemTest> ssts1 = this.getSubSystemTestListForAffectedDpc(affectedPc, false);
        if (ssts1 != null && (sst1 = this.getSubSystemTestBySsn(ssts1, affectedSsn)) != null) {
            sst1.stopTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private SubSystemTest cancelAllSst(int affectedPc, boolean cancelSstForSsn1) {
        SubSystemTest sstForSsn1 = null;
        FastList<SubSystemTest> ssts = this.getSubSystemTestListForAffectedDpc(affectedPc, false);
        if (ssts != null) {
            ArrayList<Object> arr = new ArrayList<Object>();
            FastList<SubSystemTest> fastList = ssts;
            synchronized (fastList) {
                void var7_8;
                FastList.Node node;
                FastList.Node node2 = ssts.head();
                FastList.Node endSst = ssts.tail();
                while ((node = var7_8.getNext()) != endSst && node.getValue() != null) {
                    arr.add(node.getValue());
                }
            }
            for (SubSystemTest subSystemTest : arr) {
                if (subSystemTest.getSsn() == 1 && !cancelSstForSsn1) {
                    sstForSsn1 = subSystemTest;
                    continue;
                }
                subSystemTest.stopTest();
            }
        }
        return sstForSsn1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FastList<SubSystemTest> getSubSystemTestListForAffectedDpc(int affectedPc, boolean createIfAbsent) {
        FastMap<Integer, FastList<SubSystemTest>> fastMap = this.dpcVsSst;
        synchronized (fastMap) {
            FastList ssts = (FastList)this.dpcVsSst.get((Object)affectedPc);
            if (ssts != null || !createIfAbsent) {
                return ssts;
            }
            ssts = new FastList();
            this.dpcVsSst.put((Object)affectedPc, (Object)ssts);
            return ssts;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SubSystemTest getSubSystemTestBySsn(FastList<SubSystemTest> ssts, int affectedSsn) {
        FastList<SubSystemTest> fastList = ssts;
        synchronized (fastList) {
            SubSystemTest sst = null;
            FastList.Node n = ssts.head();
            FastList.Node end = ssts.tail();
            while ((n = n.getNext()) != end && (sst = (SubSystemTest)n.getValue()).getSsn() != affectedSsn) {
            }
            return sst;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        FastMap<Integer, FastList<SubSystemTest>> fastMap = this.dpcVsSst;
        synchronized (fastMap) {
            this.dpcVsSst.clear();
        }
        this.managementExecutors = Executors.newScheduledThreadPool(1);
    }

    public void stop() {
        this.managementExecutors.shutdownNow();
    }

    private String getMessageType(int msgType) {
        switch (msgType) {
            case 1: {
                return S_SSA;
            }
            case 2: {
                return S_SSP;
            }
            case 3: {
                return S_SST;
            }
            case 4: {
                return S_SOR;
            }
            case 5: {
                return S_SOG;
            }
            case 6: {
                return S_SSC;
            }
        }
        return S_DEFAULT;
    }

    private class DpcSsn {
        private int dpc;
        private int ssn;

        public DpcSsn(int aDpc, int aSsn) {
            this.dpc = aDpc;
            this.ssn = aSsn;
        }

        public int getDpc() {
            return this.dpc;
        }

        public int getSsn() {
            return this.ssn;
        }

        public boolean equals(Object obj) {
            if (obj == null && !(obj instanceof DpcSsn)) {
                return false;
            }
            DpcSsn y = (DpcSsn)obj;
            return this.dpc == y.dpc && this.ssn == y.ssn;
        }

        public int hashCode() {
            return this.dpc + 65536 * this.ssn;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SubSystemTest
    implements Runnable {
        private volatile boolean started = false;
        private volatile boolean recdMtpStatusResp = true;
        private Future testFuture;
        private FastList<SubSystemTest> testsList;
        private int ssn = 0;
        private int affectedPc = 0;
        private int currentTimerDelay;

        SubSystemTest(int ssn, int affectedPc, FastList<SubSystemTest> testsList) {
            this.currentTimerDelay = ((SccpManagement)SccpManagement.this).sccpStackImpl.sstTimerDuration_Min;
            this.ssn = ssn;
            this.affectedPc = affectedPc;
            this.testsList = testsList;
        }

        public int getSsn() {
            return this.ssn;
        }

        public void setRecdMtpStatusResp(boolean recdMtpStatusResp) {
            this.recdMtpStatusResp = recdMtpStatusResp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stopTest() {
            FastList<SubSystemTest> fastList = this.testsList;
            synchronized (fastList) {
                this.started = false;
                Future f = this.testFuture;
                if (f != null) {
                    this.testsList.remove((Object)this);
                    this.testFuture = null;
                    f.cancel(false);
                }
            }
            try {
                this.notify();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void startTest() {
            FastList<SubSystemTest> fastList = this.testsList;
            synchronized (fastList) {
                if (!this.started) {
                    this.testFuture = SccpManagement.this.managementExecutors.schedule(this, (long)this.currentTimerDelay, TimeUnit.MILLISECONDS);
                    this.currentTimerDelay = (int)((double)this.currentTimerDelay * ((SccpManagement)SccpManagement.this).sccpStackImpl.sstTimerDuration_IncreaseFactor);
                    if (this.currentTimerDelay > ((SccpManagement)SccpManagement.this).sccpStackImpl.sstTimerDuration_Max) {
                        this.currentTimerDelay = ((SccpManagement)SccpManagement.this).sccpStackImpl.sstTimerDuration_Max;
                    }
                    this.started = true;
                    this.testsList.add((Object)this);
                }
            }
        }

        private void resetTimerDuration() {
            this.currentTimerDelay = ((SccpManagement)SccpManagement.this).sccpStackImpl.sstTimerDuration_Min;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.started) {
                FastList<SubSystemTest> fastList = this.testsList;
                synchronized (fastList) {
                    if (this.ssn == 1 && !this.recdMtpStatusResp) {
                        SubSystemTest sst1;
                        this.stopTest();
                        FastList ssts1 = SccpManagement.this.getSubSystemTestListForAffectedDpc(this.affectedPc, false);
                        if (ssts1 != null && (sst1 = SccpManagement.this.getSubSystemTestBySsn((FastList<SubSystemTest>)ssts1, this.ssn)) != null) {
                            sst1.stopTest();
                        }
                        if (this.ssn == 1) {
                            SccpManagement.this.allowRsp(this.affectedPc, false, RemoteSccpStatus.available);
                        } else {
                            SccpManagement.this.allowSsn(this.affectedPc, this.ssn);
                        }
                        return;
                    }
                    this.recdMtpStatusResp = false;
                    this.stopTest();
                    this.startTest();
                }
                SccpManagement.this.sendManagementMessage(this.affectedPc, 3, this.ssn, 0);
            }
        }
    }
}

