/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.sccp.impl;

import java.io.IOException;
import java.io.Serializable;
import javolution.util.FastList;
import javolution.util.FastMap;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.mobicents.protocols.ss7.sccp.SccpListener;
import org.mobicents.protocols.ss7.sccp.SccpManagementEventListener;
import org.mobicents.protocols.ss7.sccp.SccpProvider;
import org.mobicents.protocols.ss7.sccp.impl.SccpStackImpl;
import org.mobicents.protocols.ss7.sccp.impl.message.MessageFactoryImpl;
import org.mobicents.protocols.ss7.sccp.impl.message.SccpDataMessageImpl;
import org.mobicents.protocols.ss7.sccp.impl.parameter.ParameterFactoryImpl;
import org.mobicents.protocols.ss7.sccp.message.MessageFactory;
import org.mobicents.protocols.ss7.sccp.message.SccpDataMessage;
import org.mobicents.protocols.ss7.sccp.parameter.ParameterFactory;
import org.mobicents.protocols.ss7.sccp.parameter.SccpAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SccpProviderImpl
implements SccpProvider,
Serializable {
    private static final Logger logger = Logger.getLogger(SccpProviderImpl.class);
    private transient SccpStackImpl stack;
    protected FastMap<Integer, SccpListener> ssnToListener = new FastMap();
    protected FastList<SccpManagementEventListener> managementEventListeners = new FastList();
    private MessageFactoryImpl messageFactory;
    private ParameterFactoryImpl parameterFactory;

    SccpProviderImpl(SccpStackImpl stack) {
        this.stack = stack;
        this.messageFactory = stack.messageFactory;
        this.parameterFactory = new ParameterFactoryImpl();
    }

    public MessageFactory getMessageFactory() {
        return this.messageFactory;
    }

    public ParameterFactory getParameterFactory() {
        return this.parameterFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSccpListener(int ssn, SccpListener listener) {
        SccpProviderImpl sccpProviderImpl = this;
        synchronized (sccpProviderImpl) {
            SccpListener existingListener = (SccpListener)this.ssnToListener.get((Object)ssn);
            if (existingListener != null && logger.isEnabledFor((Priority)Level.WARN)) {
                logger.warn((Object)String.format("Registering SccpListener=%s for already existing SccpListnere=%s for SSN=%d", listener, existingListener, ssn));
            }
            FastMap newListener = new FastMap();
            newListener.putAll(this.ssnToListener);
            newListener.put((Object)ssn, (Object)listener);
            this.ssnToListener = newListener;
            this.stack.broadcastChangedSsnState(ssn, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterSccpListener(int ssn) {
        SccpProviderImpl sccpProviderImpl = this;
        synchronized (sccpProviderImpl) {
            FastMap newListener = new FastMap();
            newListener.putAll(this.ssnToListener);
            SccpListener existingListener = (SccpListener)newListener.remove((Object)ssn);
            if (existingListener == null && logger.isEnabledFor((Priority)Level.WARN)) {
                logger.warn((Object)String.format("No existing SccpListnere=%s for SSN=%d", existingListener, ssn));
            }
            this.ssnToListener = newListener;
            this.stack.broadcastChangedSsnState(ssn, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerManagementEventListener(SccpManagementEventListener listener) {
        SccpProviderImpl sccpProviderImpl = this;
        synchronized (sccpProviderImpl) {
            if (this.managementEventListeners.contains((Object)listener)) {
                return;
            }
            FastList newManagementEventListeners = new FastList();
            newManagementEventListeners.addAll(this.managementEventListeners);
            newManagementEventListeners.add((Object)listener);
            this.managementEventListeners = newManagementEventListeners;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterManagementEventListener(SccpManagementEventListener listener) {
        SccpProviderImpl sccpProviderImpl = this;
        synchronized (sccpProviderImpl) {
            if (!this.managementEventListeners.contains((Object)listener)) {
                return;
            }
            FastList newManagementEventListeners = new FastList();
            newManagementEventListeners.addAll(this.managementEventListeners);
            newManagementEventListeners.remove((Object)listener);
            this.managementEventListeners = newManagementEventListeners;
        }
    }

    protected SccpListener getSccpListener(int ssn) {
        return (SccpListener)this.ssnToListener.get((Object)ssn);
    }

    protected FastMap<Integer, SccpListener> getAllSccpListeners() {
        return this.ssnToListener;
    }

    public void send(SccpDataMessage message) throws IOException {
        SccpDataMessageImpl msg = (SccpDataMessageImpl)message;
        this.stack.send(msg);
    }

    public int getMaxUserDataLength(SccpAddress calledPartyAddress, SccpAddress callingPartyAddress) {
        return this.stack.getMaxUserDataLength(calledPartyAddress, callingPartyAddress);
    }
}

