/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.sccp.impl;

import java.io.IOException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.mobicents.protocols.ss7.indicator.RoutingIndicator;
import org.mobicents.protocols.ss7.mtp.Mtp3TransferPrimitive;
import org.mobicents.protocols.ss7.mtp.Mtp3TransferPrimitiveFactory;
import org.mobicents.protocols.ss7.mtp.Mtp3UserPart;
import org.mobicents.protocols.ss7.sccp.LoadSharingAlgorithm;
import org.mobicents.protocols.ss7.sccp.LongMessageRule;
import org.mobicents.protocols.ss7.sccp.LongMessageRuleType;
import org.mobicents.protocols.ss7.sccp.Mtp3ServiceAccessPoint;
import org.mobicents.protocols.ss7.sccp.RemoteSignalingPointCode;
import org.mobicents.protocols.ss7.sccp.RemoteSubSystem;
import org.mobicents.protocols.ss7.sccp.Rule;
import org.mobicents.protocols.ss7.sccp.RuleType;
import org.mobicents.protocols.ss7.sccp.SccpListener;
import org.mobicents.protocols.ss7.sccp.impl.SccpManagement;
import org.mobicents.protocols.ss7.sccp.impl.SccpProviderImpl;
import org.mobicents.protocols.ss7.sccp.impl.SccpStackImpl;
import org.mobicents.protocols.ss7.sccp.impl.message.EncodingResultData;
import org.mobicents.protocols.ss7.sccp.impl.message.MessageFactoryImpl;
import org.mobicents.protocols.ss7.sccp.impl.message.SccpAddressedMessageImpl;
import org.mobicents.protocols.ss7.sccp.impl.message.SccpDataMessageImpl;
import org.mobicents.protocols.ss7.sccp.impl.message.SccpMessageImpl;
import org.mobicents.protocols.ss7.sccp.impl.message.SccpNoticeMessageImpl;
import org.mobicents.protocols.ss7.sccp.impl.parameter.ParameterFactoryImpl;
import org.mobicents.protocols.ss7.sccp.message.SccpDataMessage;
import org.mobicents.protocols.ss7.sccp.message.SccpNoticeMessage;
import org.mobicents.protocols.ss7.sccp.parameter.GlobalTitle;
import org.mobicents.protocols.ss7.sccp.parameter.ReturnCause;
import org.mobicents.protocols.ss7.sccp.parameter.ReturnCauseValue;
import org.mobicents.protocols.ss7.sccp.parameter.SccpAddress;

public class SccpRoutingControl {
    private static final Logger logger = Logger.getLogger(SccpRoutingControl.class);
    private SccpStackImpl sccpStackImpl = null;
    private SccpProviderImpl sccpProviderImpl = null;
    private SccpManagement sccpManagement = null;
    private MessageFactoryImpl messageFactory;

    public SccpRoutingControl(SccpProviderImpl sccpProviderImpl, SccpStackImpl sccpStackImpl) {
        this.messageFactory = sccpStackImpl.messageFactory;
        this.sccpProviderImpl = sccpProviderImpl;
        this.sccpStackImpl = sccpStackImpl;
    }

    public SccpManagement getSccpManagement() {
        return this.sccpManagement;
    }

    public void setSccpManagement(SccpManagement sccpManagement) {
        this.sccpManagement = sccpManagement;
    }

    public void start() {
    }

    public void stop() {
    }

    protected void routeMssgFromMtp(SccpAddressedMessageImpl msg) throws IOException {
        SccpAddress calledPartyAddress = msg.getCalledPartyAddress();
        RoutingIndicator ri = calledPartyAddress.getAddressIndicator().getRoutingIndicator();
        switch (ri) {
            case ROUTING_BASED_ON_DPC_AND_SSN: {
                int ssn = msg.getCalledPartyAddress().getSubsystemNumber();
                if (ssn == 1) {
                    if (msg instanceof SccpDataMessage) {
                        this.sccpManagement.onManagementMessage((SccpDataMessage)msg);
                    }
                    return;
                }
                SccpListener listener = this.sccpProviderImpl.getSccpListener(ssn);
                if (listener == null) {
                    this.sccpManagement.recdMsgForProhibitedSsn(msg, ssn);
                    if (logger.isEnabledFor((Priority)Level.WARN)) {
                        logger.warn((Object)String.format("Received SccpMessage=%s from MTP but the SSN is not available for local routing", msg));
                    }
                    this.sendSccpError(msg, ReturnCauseValue.SUBSYSTEM_FAILURE);
                    return;
                }
                try {
                    if (msg instanceof SccpDataMessage) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)String.format("Local deliver : SCCP Data Message=%s", msg.toString()));
                        }
                        listener.onMessage((SccpDataMessage)msg);
                        break;
                    }
                    if (!(msg instanceof SccpNoticeMessage)) break;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)String.format("Local deliver : SCCP Notice Message=%s", msg.toString()));
                    }
                    listener.onNotice((SccpNoticeMessage)msg);
                }
                catch (Exception e) {
                    if (!logger.isEnabledFor((Priority)Level.WARN)) break;
                    logger.warn((Object)String.format("Exception from the listener side when delivering SccpData to ssn=%d: Message=%s", msg.getOriginLocalSsn(), msg), (Throwable)e);
                }
                break;
            }
            case ROUTING_BASED_ON_GLOBAL_TITLE: {
                this.translationFunction(msg);
                break;
            }
            default: {
                logger.error((Object)String.format("Invalid Routing Indictaor received for message=%s from MTP3", msg));
            }
        }
    }

    protected void routeMssgFromSccpUser(SccpAddressedMessageImpl msg) throws IOException {
        this.route(msg);
    }

    protected ReturnCauseValue send(SccpMessageImpl message) throws IOException {
        int sls;
        int dpc = message.getOutgoingDpc();
        Mtp3ServiceAccessPoint sap = this.sccpStackImpl.router.findMtp3ServiceAccessPoint(dpc, sls = message.getSls());
        if (sap == null) {
            if (logger.isEnabledFor((Priority)Level.WARN)) {
                logger.warn((Object)String.format("SccpMessage for sending=%s but no matching dpc=%d & sls=%d SAP found", message, dpc, sls));
            }
            return ReturnCauseValue.SCCP_FAILURE;
        }
        Mtp3UserPart mup = this.sccpStackImpl.getMtp3UserPart(sap.getMtp3Id());
        if (mup == null) {
            if (logger.isEnabledFor((Priority)Level.WARN)) {
                logger.warn((Object)String.format("SccpMessage for sending=%s but no matching Mtp3UserPart found for Id=%d", message, sap.getMtp3Id()));
            }
            return ReturnCauseValue.SCCP_FAILURE;
        }
        LongMessageRule lmr = this.sccpStackImpl.router.findLongMessageRule(dpc);
        LongMessageRuleType lmrt = LongMessageRuleType.LongMessagesForbidden;
        if (lmr != null) {
            lmrt = lmr.getLongMessageRuleType();
        }
        EncodingResultData erd = message.encode(lmrt, mup.getMaxUserDataLength(dpc), logger);
        switch (erd.getEncodingResult()) {
            case Success: {
                Mtp3TransferPrimitiveFactory factory = mup.getMtp3TransferPrimitiveFactory();
                if (erd.getSolidData() != null) {
                    Mtp3TransferPrimitive msg = factory.createMtp3TransferPrimitive(3, sap.getNi(), 0, sap.getOpc(), dpc, sls, erd.getSolidData());
                    mup.sendMessage(msg);
                } else {
                    for (byte[] bf : erd.getSegementedData()) {
                        Mtp3TransferPrimitive msg = factory.createMtp3TransferPrimitive(3, sap.getNi(), 0, sap.getOpc(), dpc, sls, bf);
                        mup.sendMessage(msg);
                    }
                }
                return null;
            }
            case ReturnFailure: {
                return erd.getReturnCause();
            }
        }
        String em = String.format("Error %s when encoding a SccpMessage\n%s", erd.getEncodingResult().toString(), message.toString());
        if (logger.isEnabledFor((Priority)Level.WARN)) {
            logger.warn((Object)em);
        }
        throw new IOException(em);
    }

    private TranslationAddressCheckingResult checkTranslationAddress(SccpAddressedMessageImpl msg, Rule rule, SccpAddress translationAddress, String destName) {
        if (translationAddress == null) {
            if (logger.isEnabledFor((Priority)Level.WARN)) {
                logger.warn((Object)String.format("Received SccpMessage=%s for Translation but no matching %s Address defined for Rule=%s for routing", msg, destName, rule));
            }
            return TranslationAddressCheckingResult.translationFailure;
        }
        if (!translationAddress.getAddressIndicator().pcPresent()) {
            if (logger.isEnabledFor((Priority)Level.WARN)) {
                logger.warn((Object)String.format("Received SccpMessage=%s for Translation but no PC is present for %s Address ", msg, destName));
            }
            return TranslationAddressCheckingResult.translationFailure;
        }
        int targetSsn = translationAddress.getSubsystemNumber();
        if (targetSsn == 0) {
            targetSsn = msg.getCalledPartyAddress().getSubsystemNumber();
        }
        if (this.sccpStackImpl.router.spcIsLocal(translationAddress.getSignalingPointCode())) {
            if (targetSsn == 1 || this.sccpProviderImpl.getSccpListener(targetSsn) != null) {
                return TranslationAddressCheckingResult.destinationAvailable;
            }
            if (logger.isEnabledFor((Priority)Level.WARN)) {
                logger.warn((Object)String.format("Received SccpMessage=%s for Translation but no local SSN is present for %s Address ", msg, destName));
            }
            return TranslationAddressCheckingResult.destinationUnavailable_SubsystemFailure;
        }
        RemoteSignalingPointCode remoteSpc = this.sccpStackImpl.getSccpResource().getRemoteSpcByPC(translationAddress.getSignalingPointCode());
        if (remoteSpc == null) {
            if (logger.isEnabledFor((Priority)Level.WARN)) {
                logger.warn((Object)String.format("Received SccpMessage=%s for Translation but no %s Remote Signaling Pointcode = %d resource defined ", msg, destName, translationAddress.getSignalingPointCode()));
            }
            return TranslationAddressCheckingResult.translationFailure;
        }
        if (remoteSpc.isRemoteSpcProhibited()) {
            if (logger.isEnabledFor((Priority)Level.WARN)) {
                logger.warn((Object)String.format("Received SccpMessage=%s for Translation but %s Remote Signaling Pointcode = %d is prohibited ", msg, destName, translationAddress.getSignalingPointCode()));
            }
            return TranslationAddressCheckingResult.destinationUnavailable_MtpFailure;
        }
        if (translationAddress.getAddressIndicator().getRoutingIndicator() == RoutingIndicator.ROUTING_BASED_ON_DPC_AND_SSN && targetSsn != 1) {
            RemoteSubSystem remoteSubSystem = this.sccpStackImpl.getSccpResource().getRemoteSsn(translationAddress.getSignalingPointCode(), targetSsn);
            if (remoteSubSystem == null) {
                if (logger.isEnabledFor((Priority)Level.WARN)) {
                    logger.warn((Object)String.format("Received SccpMessage=%s for Translation but no %s Remote SubSystem = %d (dpc=%d) resource defined ", msg, destName, translationAddress.getSubsystemNumber(), translationAddress.getSignalingPointCode()));
                }
                return TranslationAddressCheckingResult.translationFailure;
            }
            if (remoteSubSystem.isRemoteSsnProhibited()) {
                if (logger.isEnabledFor((Priority)Level.WARN)) {
                    logger.warn((Object)String.format("Received SccpMessage=%s for Translation but %s Remote SubSystem = %d (dpc=%d) is prohibited ", msg, destName, translationAddress.getSubsystemNumber(), translationAddress.getSignalingPointCode()));
                }
                return TranslationAddressCheckingResult.destinationUnavailable_SubsystemFailure;
            }
        }
        return TranslationAddressCheckingResult.destinationAvailable;
    }

    private void translationFunction(SccpAddressedMessageImpl msg) throws IOException {
        SccpAddress newCallingPartyAddress;
        if (!msg.reduceHopCounter()) {
            if (logger.isEnabledFor((Priority)Level.WARN)) {
                logger.warn((Object)String.format("Received SccpMessage for Translation but hop counter violation detected\nSccpMessage=%s", msg));
            }
            this.sendSccpError(msg, ReturnCauseValue.HOP_COUNTER_VIOLATION);
            return;
        }
        SccpAddress calledPartyAddress = msg.getCalledPartyAddress();
        Rule rule = this.sccpStackImpl.router.findRule(calledPartyAddress, msg.getIsMtpOriginated());
        if (rule == null) {
            if (logger.isEnabledFor((Priority)Level.WARN)) {
                logger.warn((Object)String.format("Received SccpMessage for Translation but no matching Rule found for local routing\nSccpMessage=%s", msg));
            }
            this.sendSccpError(msg, ReturnCauseValue.NO_TRANSLATION_FOR_ADDRESS);
            return;
        }
        SccpAddress translationAddressPri = this.sccpStackImpl.router.getRoutingAddress(rule.getPrimaryAddressId());
        TranslationAddressCheckingResult resPri = this.checkTranslationAddress(msg, rule, translationAddressPri, "primary");
        if (resPri == TranslationAddressCheckingResult.translationFailure) {
            this.sendSccpError(msg, ReturnCauseValue.NO_TRANSLATION_FOR_ADDRESS);
            return;
        }
        SccpAddress translationAddressSec = null;
        TranslationAddressCheckingResult resSec = TranslationAddressCheckingResult.destinationUnavailable_SubsystemFailure;
        if (rule.getRuleType() != RuleType.Solitary && (resSec = this.checkTranslationAddress(msg, rule, translationAddressSec = this.sccpStackImpl.router.getRoutingAddress(rule.getSecondaryAddressId()), "secondary")) == TranslationAddressCheckingResult.translationFailure) {
            this.sendSccpError(msg, ReturnCauseValue.NO_TRANSLATION_FOR_ADDRESS);
            return;
        }
        if (resPri != TranslationAddressCheckingResult.destinationAvailable && resSec != TranslationAddressCheckingResult.destinationAvailable) {
            switch (resPri) {
                case destinationUnavailable_SubsystemFailure: {
                    this.sendSccpError(msg, ReturnCauseValue.SUBSYSTEM_FAILURE);
                    return;
                }
                case destinationUnavailable_MtpFailure: {
                    this.sendSccpError(msg, ReturnCauseValue.MTP_FAILURE);
                    return;
                }
            }
            this.sendSccpError(msg, ReturnCauseValue.SCCP_FAILURE);
            return;
        }
        SccpAddress translationAddress = null;
        SccpAddress translationAddress2 = null;
        if (resPri == TranslationAddressCheckingResult.destinationAvailable && resSec != TranslationAddressCheckingResult.destinationAvailable) {
            translationAddress = translationAddressPri;
        } else if (resPri != TranslationAddressCheckingResult.destinationAvailable && resSec == TranslationAddressCheckingResult.destinationAvailable) {
            translationAddress = translationAddressSec;
        } else {
            switch (rule.getRuleType()) {
                case Solitary: 
                case Dominant: {
                    translationAddress = translationAddressPri;
                    break;
                }
                case Loadshared: {
                    if (msg.getSccpCreatesSls()) {
                        if (this.sccpStackImpl.newSelector()) {
                            translationAddress = translationAddressPri;
                            break;
                        }
                        translationAddress = translationAddressSec;
                        break;
                    }
                    if (this.selectLoadSharingRoute(rule.getLoadSharingAlgorithm(), msg)) {
                        translationAddress = translationAddressPri;
                        break;
                    }
                    translationAddress = translationAddressSec;
                    break;
                }
                case Broadcast: {
                    translationAddress = translationAddressPri;
                    translationAddress2 = translationAddressSec;
                }
            }
        }
        if (rule.getNewCallingPartyAddressId() != null && (newCallingPartyAddress = this.sccpStackImpl.router.getRoutingAddress(rule.getNewCallingPartyAddressId())) != null) {
            msg.setCallingPartyAddress(newCallingPartyAddress);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("New CallingPartyAddress assigned after translation = %s", newCallingPartyAddress));
            }
        }
        SccpAddress address = rule.translate(calledPartyAddress, translationAddress);
        msg.setCalledPartyAddress(address);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("CalledPartyAddress after translation = %s", address));
        }
        this.route(msg);
        if (translationAddress2 != null) {
            address = rule.translate(calledPartyAddress, translationAddress2);
            msg.setCalledPartyAddress(address);
            msg.clearReturnMessageOnError();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("CalledPartyAddress after translation - a second broadcast address = %s", address));
            }
            this.route(msg);
        }
    }

    private boolean selectLoadSharingRoute(LoadSharingAlgorithm loadSharingAlgo, SccpAddressedMessageImpl msg) {
        if (loadSharingAlgo == LoadSharingAlgorithm.Bit4) {
            return (msg.getSls() & 0x10) == 0;
        }
        if (loadSharingAlgo == LoadSharingAlgorithm.Bit3) {
            return (msg.getSls() & 8) == 0;
        }
        if (loadSharingAlgo == LoadSharingAlgorithm.Bit2) {
            return (msg.getSls() & 4) == 0;
        }
        if (loadSharingAlgo == LoadSharingAlgorithm.Bit1) {
            return (msg.getSls() & 2) == 0;
        }
        if (loadSharingAlgo == LoadSharingAlgorithm.Bit0) {
            return (msg.getSls() & 1) == 0;
        }
        return true;
    }

    private void route(SccpAddressedMessageImpl msg) throws IOException {
        block38: {
            SccpAddress calledPartyAddress = msg.getCalledPartyAddress();
            int dpc = calledPartyAddress.getSignalingPointCode();
            int ssn = calledPartyAddress.getSubsystemNumber();
            GlobalTitle gt = calledPartyAddress.getGlobalTitle();
            if (calledPartyAddress.getAddressIndicator().pcPresent()) {
                if (this.sccpStackImpl.router.spcIsLocal(dpc)) {
                    if (ssn > 0) {
                        if (ssn == 1) {
                            if (msg instanceof SccpDataMessage) {
                                this.sccpManagement.onManagementMessage((SccpDataMessage)msg);
                            }
                            return;
                        }
                        SccpListener listener = this.sccpProviderImpl.getSccpListener(ssn);
                        if (listener == null) {
                            if (logger.isEnabledFor((Priority)Level.WARN)) {
                                logger.warn((Object)String.format("Received SccpMessage=%s for routing but the SSN is not available for local routing", msg));
                            }
                            this.sendSccpError(msg, ReturnCauseValue.SUBSYSTEM_FAILURE);
                            return;
                        }
                        try {
                            if (msg instanceof SccpDataMessage) {
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)String.format("Local deliver : SCCP Data Message=%s", msg.toString()));
                                }
                                listener.onMessage((SccpDataMessage)msg);
                            } else if (msg instanceof SccpNoticeMessage) {
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)String.format("Local deliver : SCCP Notice Message=%s", msg.toString()));
                                }
                                listener.onNotice((SccpNoticeMessage)msg);
                            }
                            break block38;
                        }
                        catch (Exception e) {
                            if (logger.isEnabledFor((Priority)Level.WARN)) {
                                logger.warn((Object)String.format("Exception from the listener side when delivering SccpData to ssn=%d: Message=%s", msg.getOriginLocalSsn(), msg), (Throwable)e);
                            }
                            break block38;
                        }
                    }
                    if (gt != null) {
                        if (calledPartyAddress.isTranslated()) {
                            logger.error((Object)String.format("Droping message. Received SCCPMessage=%s for routing but CalledPartyAddress is already translated once", msg));
                            this.sendSccpError(msg, ReturnCauseValue.SCCP_FAILURE);
                            return;
                        }
                        this.translationFunction(msg);
                    } else {
                        logger.error((Object)String.format("Received SCCPMessage=%s for routing, but neither SSN nor GT present", msg));
                        this.sendSccpError(msg, ReturnCauseValue.NO_TRANSLATION_FOR_NATURE);
                    }
                } else {
                    RemoteSignalingPointCode remoteSpc = this.sccpStackImpl.getSccpResource().getRemoteSpcByPC(dpc);
                    if (remoteSpc == null) {
                        if (logger.isEnabledFor((Priority)Level.WARN)) {
                            logger.warn((Object)String.format("Received SccpMessage=%s for routing but no Remote Signaling Pointcode = %d resource defined ", msg, dpc));
                        }
                        this.sendSccpError(msg, ReturnCauseValue.SCCP_FAILURE);
                        return;
                    }
                    if (remoteSpc.isRemoteSpcProhibited()) {
                        if (logger.isEnabledFor((Priority)Level.WARN)) {
                            logger.warn((Object)String.format("Received SccpMessage=%s for routing but Remote Signaling Pointcode = %d is prohibited", msg, dpc));
                        }
                        this.sendSccpError(msg, ReturnCauseValue.MTP_FAILURE);
                        return;
                    }
                    if (ssn > 1) {
                        if (calledPartyAddress.getAddressIndicator().getRoutingIndicator() == RoutingIndicator.ROUTING_BASED_ON_DPC_AND_SSN) {
                            RemoteSubSystem remoteSsn = this.sccpStackImpl.getSccpResource().getRemoteSsn(dpc, calledPartyAddress.getSubsystemNumber());
                            if (remoteSsn == null) {
                                if (logger.isEnabledFor((Priority)Level.WARN)) {
                                    logger.warn((Object)String.format("Received SCCPMessage=%s for routing, but no Remote SubSystem = %d resource defined ", msg, calledPartyAddress.getSubsystemNumber()));
                                }
                                this.sendSccpError(msg, ReturnCauseValue.SCCP_FAILURE);
                                return;
                            }
                            if (remoteSsn.isRemoteSsnProhibited()) {
                                if (logger.isEnabledFor((Priority)Level.WARN)) {
                                    logger.warn((Object)String.format("Routing of Sccp Message=%s failed as Remote SubSystem = %d is prohibited ", msg, calledPartyAddress.getSubsystemNumber()));
                                }
                                this.sendSccpError(msg, ReturnCauseValue.SUBSYSTEM_FAILURE);
                                return;
                            }
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)String.format("Tx : SCCP Message=%s", msg.toString()));
                        }
                        this.sendMessageToMtp(msg);
                    } else if (gt != null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)String.format("Tx : SCCP Message=%s", msg.toString()));
                        }
                        this.sendMessageToMtp(msg);
                    } else {
                        logger.error((Object)String.format("Received SCCPMessage=%s for routing, but neither SSN nor GT present", msg));
                        this.sendSccpError(msg, ReturnCauseValue.NO_TRANSLATION_FOR_NATURE);
                    }
                }
            } else {
                if (gt == null) {
                    if (logger.isEnabledFor((Priority)Level.WARN)) {
                        logger.warn((Object)String.format("Received SccpMessage=%s for routing from local SCCP user part but no pointcode and no GT or SSN included", msg, dpc));
                    }
                    this.sendSccpError(msg, ReturnCauseValue.NO_TRANSLATION_FOR_NATURE);
                    return;
                }
                if (calledPartyAddress.isTranslated()) {
                    logger.error((Object)String.format("Droping message. Received SCCPMessage=%s for Routing , but CalledPartyAddress is already translated once", msg));
                    this.sendSccpError(msg, ReturnCauseValue.SCCP_FAILURE);
                    return;
                }
                this.translationFunction(msg);
            }
        }
    }

    protected void sendMessageToMtp(SccpAddressedMessageImpl msg) throws IOException {
        msg.setOutgoingDpc(msg.getCalledPartyAddress().getSignalingPointCode());
        ReturnCauseValue er = this.send(msg);
        if (er != null) {
            this.sendSccpError(msg, er);
        }
    }

    protected void sendSccpError(SccpAddressedMessageImpl msg, ReturnCauseValue returnCauseInt) throws IOException {
        block10: {
            if (!msg.getReturnMessageOnError()) {
                return;
            }
            SccpNoticeMessageImpl ans = null;
            ReturnCause returnCause = ((ParameterFactoryImpl)this.sccpProviderImpl.getParameterFactory()).createReturnCause(returnCauseInt);
            if (msg instanceof SccpDataMessageImpl) {
                SccpDataMessageImpl msgData = (SccpDataMessageImpl)msg;
                ans = (SccpNoticeMessageImpl)this.messageFactory.createNoticeMessage(msg.getType(), returnCause, msg.getCallingPartyAddress(), msg.getCalledPartyAddress(), msgData.getData(), msgData.getHopCounter(), msgData.getImportance());
            }
            if (ans != null) {
                if (msg.getIsMtpOriginated()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)String.format("sendSccpError to a remote user: SCCP Message=%s", msg.toString()));
                    }
                    this.route(ans);
                } else {
                    SccpListener listener;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)String.format("sendSccpError to a local user: SCCP Message=%s", msg.toString()));
                    }
                    if ((listener = this.sccpProviderImpl.getSccpListener(msg.getOriginLocalSsn())) != null) {
                        try {
                            listener.onNotice(ans);
                        }
                        catch (Exception e) {
                            if (!logger.isEnabledFor((Priority)Level.WARN)) break block10;
                            logger.warn((Object)String.format("Exception from the listener side when delivering SccpNotice to ssn=%d: Message=%s", msg.getOriginLocalSsn(), msg), (Throwable)e);
                        }
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TranslationAddressCheckingResult {
        destinationAvailable,
        destinationUnavailable_SubsystemFailure,
        destinationUnavailable_MtpFailure,
        translationFailure;

    }
}

