/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.sccp.impl.message;

import java.io.IOException;
import org.mobicents.protocols.ss7.sccp.impl.SccpStackImpl;
import org.mobicents.protocols.ss7.sccp.impl.message.SccpDataNoticeTemplateMessageImpl;
import org.mobicents.protocols.ss7.sccp.impl.parameter.AbstractParameter;
import org.mobicents.protocols.ss7.sccp.impl.parameter.ProtocolClassImpl;
import org.mobicents.protocols.ss7.sccp.message.SccpDataMessage;
import org.mobicents.protocols.ss7.sccp.parameter.HopCounter;
import org.mobicents.protocols.ss7.sccp.parameter.Importance;
import org.mobicents.protocols.ss7.sccp.parameter.ProtocolClass;
import org.mobicents.protocols.ss7.sccp.parameter.SccpAddress;

public class SccpDataMessageImpl
extends SccpDataNoticeTemplateMessageImpl
implements SccpDataMessage {
    protected ProtocolClass protocolClass;

    protected SccpDataMessageImpl(SccpStackImpl sccpStackImpl, ProtocolClass protocolClass, int outgoingSls, int localSsn, SccpAddress calledParty, SccpAddress callingParty, byte[] data, HopCounter hopCounter, Importance importance) {
        super(sccpStackImpl, -1, outgoingSls, localSsn, calledParty, callingParty, data, hopCounter, importance);
        this.protocolClass = protocolClass;
    }

    protected SccpDataMessageImpl(SccpStackImpl sccpStackImpl, int type, int incomingOpc, int incomingDpc, int incomingSls) {
        super(sccpStackImpl, type, incomingOpc, incomingDpc, incomingSls);
    }

    public ProtocolClass getProtocolClass() {
        return this.protocolClass;
    }

    public void setProtocolClass(ProtocolClass protocolClass) {
        this.protocolClass = protocolClass;
    }

    public boolean getReturnMessageOnError() {
        if (this.protocolClass != null) {
            return this.protocolClass.getReturnMessageOnError();
        }
        return false;
    }

    public void clearReturnMessageOnError() {
        if (this.protocolClass != null) {
            this.protocolClass.clearReturnMessageOnError();
        }
    }

    public boolean getSccpCreatesSls() {
        return this.protocolClass == null || this.protocolClass.getProtocolClass() == 0;
    }

    protected boolean getSecondParamaterPresent() {
        return this.protocolClass != null;
    }

    protected byte[] getSecondParamaterData() throws IOException {
        return ((AbstractParameter)this.protocolClass).encode();
    }

    protected void setSecondParamaterData(int data) throws IOException {
        this.protocolClass = new ProtocolClassImpl();
        ((AbstractParameter)this.protocolClass).decode(new byte[]{(byte)data});
    }

    protected boolean getIsProtocolClass1() {
        return this.protocolClass.getProtocolClass() != 0;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Sccp Msg [Type=");
        switch (this.type) {
            case 9: {
                sb.append("UDT");
                break;
            }
            case 17: {
                sb.append("XUDT");
                break;
            }
            case 19: {
                sb.append("LUDT");
            }
        }
        sb.append(" sls=").append(this.sls).append(" incomingOpc=").append(this.incomingOpc).append(" incomingDpc=").append(this.incomingDpc).append(" outgoingDpc=").append(this.outgoingDpc).append(" CallingAddress(").append(this.callingParty).append(") CalledParty(").append(this.calledParty).append(")");
        if (this.importance != null) {
            sb.append(" importance=");
            sb.append(this.importance.getValue());
        }
        if (this.hopCounter != null) {
            sb.append(" hopCounter=");
            sb.append(this.hopCounter.getValue());
        }
        if (this.segmentation != null) {
            sb.append(" segmentation=");
            sb.append(this.segmentation.toString());
        }
        sb.append(" DataLen=");
        if (this.data != null) {
            sb.append(this.data.length);
        }
        sb.append("]");
        return sb.toString();
    }
}

