/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.sccp.impl.message;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.mobicents.protocols.ss7.sccp.LongMessageRuleType;
import org.mobicents.protocols.ss7.sccp.impl.SccpStackImpl;
import org.mobicents.protocols.ss7.sccp.impl.message.EncodingResult;
import org.mobicents.protocols.ss7.sccp.impl.message.EncodingResultData;
import org.mobicents.protocols.ss7.sccp.impl.message.SccpDataMessageImpl;
import org.mobicents.protocols.ss7.sccp.impl.message.SccpSegmentableMessageImpl;
import org.mobicents.protocols.ss7.sccp.impl.parameter.HopCounterImpl;
import org.mobicents.protocols.ss7.sccp.impl.parameter.ImportanceImpl;
import org.mobicents.protocols.ss7.sccp.impl.parameter.SccpAddressCodec;
import org.mobicents.protocols.ss7.sccp.impl.parameter.SegmentationImpl;
import org.mobicents.protocols.ss7.sccp.parameter.HopCounter;
import org.mobicents.protocols.ss7.sccp.parameter.Importance;
import org.mobicents.protocols.ss7.sccp.parameter.ReturnCauseValue;
import org.mobicents.protocols.ss7.sccp.parameter.SccpAddress;

public abstract class SccpDataNoticeTemplateMessageImpl
extends SccpSegmentableMessageImpl {
    protected ImportanceImpl importance;

    protected SccpDataNoticeTemplateMessageImpl(SccpStackImpl sccpStackImpl, int type, int outgoingSls, int localSsn, SccpAddress calledParty, SccpAddress callingParty, byte[] data, HopCounter hopCounter, Importance importance) {
        super(sccpStackImpl, type, outgoingSls, localSsn, calledParty, callingParty, data, hopCounter);
        this.importance = (ImportanceImpl)importance;
    }

    protected SccpDataNoticeTemplateMessageImpl(SccpStackImpl sccpStackImpl, int type, int incomingOpc, int incomingDpc, int incomingSls) {
        super(sccpStackImpl, type, incomingOpc, incomingDpc, incomingSls);
    }

    public Importance getImportance() {
        return this.importance;
    }

    public void setImportance(Importance p) {
        this.importance = (ImportanceImpl)p;
    }

    protected abstract boolean getIsProtocolClass1();

    protected abstract boolean getSecondParamaterPresent();

    protected abstract byte[] getSecondParamaterData() throws IOException;

    protected abstract void setSecondParamaterData(int var1) throws IOException;

    public void decode(InputStream in) throws IOException {
        switch (this.type) {
            case 9: 
            case 10: {
                this.setSecondParamaterData(in.read());
                int cpaPointer = in.read() & 0xFF;
                in.mark(in.available());
                in.skip(cpaPointer - 1);
                int len = in.read() & 0xFF;
                byte[] buffer = new byte[len];
                in.read(buffer);
                this.calledParty = SccpAddressCodec.decode(buffer);
                in.reset();
                cpaPointer = in.read() & 0xFF;
                in.mark(in.available());
                in.skip(cpaPointer - 1);
                len = in.read() & 0xFF;
                buffer = new byte[len];
                in.read(buffer);
                this.callingParty = SccpAddressCodec.decode(buffer);
                in.reset();
                cpaPointer = in.read() & 0xFF;
                in.skip(cpaPointer - 1);
                len = in.read() & 0xFF;
                this.data = new byte[len];
                in.read(this.data);
                break;
            }
            case 17: 
            case 18: {
                this.setSecondParamaterData(in.read());
                this.hopCounter = new HopCounterImpl((byte)in.read());
                if (this.hopCounter.getValue() > 15 || this.hopCounter.getValue() <= 0) {
                    throw new IOException("Hop Counter must be between 1 and 15, it is: " + this.hopCounter);
                }
                int pointer = in.read() & 0xFF;
                in.mark(in.available());
                if ((long)(pointer - 1) != in.skip(pointer - 1)) {
                    throw new IOException("Not enough data in buffer");
                }
                int len = in.read() & 0xFF;
                byte[] buffer = new byte[len];
                in.read(buffer);
                this.calledParty = SccpAddressCodec.decode(buffer);
                in.reset();
                pointer = in.read() & 0xFF;
                in.mark(in.available());
                if ((long)(pointer - 1) != in.skip(pointer - 1)) {
                    throw new IOException("Not enough data in buffer");
                }
                len = in.read() & 0xFF;
                buffer = new byte[len];
                in.read(buffer);
                this.callingParty = SccpAddressCodec.decode(buffer);
                in.reset();
                pointer = in.read() & 0xFF;
                in.mark(in.available());
                if ((long)(pointer - 1) != in.skip(pointer - 1)) {
                    throw new IOException("Not enough data in buffer");
                }
                len = in.read() & 0xFF;
                this.data = new byte[len];
                in.read(this.data);
                in.reset();
                pointer = in.read() & 0xFF;
                in.mark(in.available());
                if (pointer == 0) {
                    return;
                }
                if ((long)(pointer - 1) != in.skip(pointer - 1)) {
                    throw new IOException("Not enough data in buffer");
                }
                int paramCode = 0;
                while ((paramCode = in.read() & 0xFF) != 0) {
                    len = in.read() & 0xFF;
                    buffer = new byte[len];
                    in.read(buffer);
                    this.decodeOptional(paramCode, buffer);
                }
                break;
            }
            case 19: 
            case 20: {
                this.setSecondParamaterData(in.read());
                this.hopCounter = new HopCounterImpl((byte)in.read());
                if (this.hopCounter.getValue() > 15 || this.hopCounter.getValue() <= 0) {
                    throw new IOException("Hop Counter must be between 1 and 15, it is: " + this.hopCounter);
                }
                int pointer = (in.read() & 0xFF) + ((in.read() & 0xFF) << 8);
                in.mark(in.available());
                if ((long)(pointer - 1) != in.skip(pointer - 1)) {
                    throw new IOException("Not enough data in buffer");
                }
                int len = in.read() & 0xFF;
                byte[] buffer = new byte[len];
                in.read(buffer);
                this.calledParty = SccpAddressCodec.decode(buffer);
                in.reset();
                pointer = (in.read() & 0xFF) + ((in.read() & 0xFF) << 8);
                in.mark(in.available());
                if ((long)(pointer - 1) != in.skip(pointer - 1)) {
                    throw new IOException("Not enough data in buffer");
                }
                len = in.read() & 0xFF;
                buffer = new byte[len];
                in.read(buffer);
                this.callingParty = SccpAddressCodec.decode(buffer);
                in.reset();
                pointer = (in.read() & 0xFF) + ((in.read() & 0xFF) << 8);
                in.mark(in.available());
                if ((long)(pointer - 1) != in.skip(pointer - 1)) {
                    throw new IOException("Not enough data in buffer");
                }
                len = (in.read() & 0xFF) + ((in.read() & 0xFF) << 8);
                this.data = new byte[len];
                in.read(this.data);
                in.reset();
                pointer = (in.read() & 0xFF) + ((in.read() & 0xFF) << 8);
                in.mark(in.available());
                if (pointer == 0) {
                    return;
                }
                if ((long)(pointer - 1) != in.skip(pointer - 1)) {
                    throw new IOException("Not enough data in buffer");
                }
                int paramCode = 0;
                while ((paramCode = in.read() & 0xFF) != 0) {
                    len = in.read() & 0xFF;
                    buffer = new byte[len];
                    in.read(buffer);
                    this.decodeOptional(paramCode, buffer);
                }
                break;
            }
        }
    }

    private void decodeOptional(int code, byte[] buffer) throws IOException {
        switch (code) {
            case 16: {
                this.segmentation = new SegmentationImpl();
                this.segmentation.decode(buffer);
                break;
            }
            case 18: {
                this.importance = new ImportanceImpl();
                this.importance.decode(buffer);
                break;
            }
            default: {
                throw new IOException("Uknown optional parameter code: " + code);
            }
        }
    }

    public EncodingResultData encode(LongMessageRuleType longMessageRuleType, int maxMtp3UserDataLength, Logger logger) throws IOException {
        byte[] b;
        int fieldsLenL;
        int availLen;
        byte[] bf = this.getData();
        if (bf == null || bf.length == 0) {
            return new EncodingResultData(EncodingResult.DataMissed, null, null, null);
        }
        if (bf.length > this.sccpStackImpl.getMaxDataMessage()) {
            return new EncodingResultData(EncodingResult.DataMaxLengthExceeded, null, null, null);
        }
        if (this.calledParty == null) {
            return new EncodingResultData(EncodingResult.CalledPartyAddressMissing, null, null, null);
        }
        if (this.callingParty == null) {
            return new EncodingResultData(EncodingResult.CallingPartyAddressMissing, null, null, null);
        }
        if (!this.getSecondParamaterPresent()) {
            return new EncodingResultData(EncodingResult.ProtocolClassMissing, null, null, null);
        }
        byte[] cdp = SccpAddressCodec.encode(this.calledParty, this.sccpStackImpl.isRemoveSpc());
        byte[] cnp = SccpAddressCodec.encode(this.callingParty, this.sccpStackImpl.isRemoveSpc());
        if (longMessageRuleType == null) {
            longMessageRuleType = LongMessageRuleType.LongMessagesForbidden;
        }
        if (this.isMtpOriginated && this.type == 9 || this.type == 10) {
            longMessageRuleType = LongMessageRuleType.LongMessagesForbidden;
        }
        boolean isServiceMessage = true;
        if (this instanceof SccpDataMessageImpl) {
            isServiceMessage = false;
        }
        if (longMessageRuleType == LongMessageRuleType.LongMessagesForbidden) {
            int fieldsLen = this.sccpStackImpl.calculateUdtFieldsLengthWithoutData(cdp.length, cnp.length);
            int availLen2 = maxMtp3UserDataLength - fieldsLen;
            if (availLen2 > 254) {
                availLen2 = 254;
            }
            if (bf.length > availLen2) {
                if (logger.isEnabledFor((Priority)Level.WARN)) {
                    logger.warn((Object)String.format("Failure when sending a UDT message: message is too long. SccpMessageSegment=%s", this));
                }
                return new EncodingResultData(EncodingResult.ReturnFailure, null, null, ReturnCauseValue.SEG_NOT_SUPPORTED);
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream(fieldsLen + bf.length);
            this.type = isServiceMessage ? 10 : 9;
            out.write(this.type);
            out.write(this.getSecondParamaterData());
            int len = 3;
            out.write(len);
            len = cdp.length + 3;
            out.write(len);
            out.write(len += cnp.length);
            out.write((byte)cdp.length);
            out.write(cdp);
            out.write((byte)cnp.length);
            out.write(cnp);
            out.write((byte)bf.length);
            out.write(bf);
            return new EncodingResultData(EncodingResult.Success, out.toByteArray(), null, null);
        }
        if (longMessageRuleType == LongMessageRuleType.XudtEnabled) {
            int fieldsLenXSegm;
            int availLenXSegm;
            int fieldsLen2;
            int fieldsLenX;
            int availLenX;
            this.type = isServiceMessage ? 18 : 17;
            if (this.hopCounter == null) {
                this.hopCounter = new HopCounterImpl(15);
            }
            if ((availLenX = maxMtp3UserDataLength - (fieldsLenX = this.sccpStackImpl.calculateXudtFieldsLengthWithoutData(cdp.length, cnp.length, false, this.importance != null))) > (fieldsLen2 = this.sccpStackImpl.calculateXudtFieldsLengthWithoutData2(cdp.length, cnp.length))) {
                availLenX = fieldsLen2;
            }
            if ((availLenXSegm = maxMtp3UserDataLength - (fieldsLenXSegm = this.sccpStackImpl.calculateXudtFieldsLengthWithoutData(cdp.length, cnp.length, true, this.importance != null))) > fieldsLen2) {
                availLenXSegm = fieldsLen2;
            }
            if (bf.length <= availLenX && bf.length <= this.sccpStackImpl.getZMarginXudtMessage()) {
                ByteArrayOutputStream out = new ByteArrayOutputStream(fieldsLenX + bf.length);
                out.write(this.type);
                out.write(this.getSecondParamaterData());
                out.write(this.hopCounter.getValue());
                int len = 4;
                out.write(len);
                out.write(len += cdp.length);
                out.write(len += cnp.length);
                boolean optionalPresent = false;
                if (this.importance != null) {
                    out.write(len += bf.length);
                    optionalPresent = true;
                } else {
                    out.write(0);
                }
                out.write((byte)cdp.length);
                out.write(cdp);
                out.write((byte)cnp.length);
                out.write(cnp);
                out.write((byte)bf.length);
                out.write(bf);
                if (this.importance != null) {
                    out.write(18);
                    byte[] b2 = this.importance.encode();
                    out.write(b2.length);
                    out.write(b2);
                }
                if (optionalPresent) {
                    out.write(0);
                }
                return new EncodingResultData(EncodingResult.Success, out.toByteArray(), null, null);
            }
            if (bf.length > availLenXSegm * 16) {
                if (logger.isEnabledFor((Priority)Level.WARN)) {
                    logger.warn((Object)String.format("Failure when segmenting a message XUDT: message is too long. SccpMessageSegment=%s", this));
                }
                return new EncodingResultData(EncodingResult.ReturnFailure, null, null, ReturnCauseValue.SEG_FAILURE);
            }
            int segmLen = bf.length <= this.sccpStackImpl.getZMarginXudtMessage() * 16 ? this.sccpStackImpl.getZMarginXudtMessage() : availLenXSegm;
            if (segmLen > availLenXSegm) {
                segmLen = availLenXSegm;
            }
            int segmCount = (bf.length - 1) / segmLen + 1;
            if (this.isMtpOriginated) {
                if (this.segmentation == null) {
                    if (logger.isEnabledFor((Priority)Level.WARN)) {
                        logger.warn((Object)String.format("Failure when segmenting a message: message is not locally originated but \"segmentation\" field is absent. SccpMessageSegment=%s", this));
                    }
                    return new EncodingResultData(EncodingResult.ReturnFailure, null, null, ReturnCauseValue.SEG_FAILURE);
                }
                this.segmentation = new SegmentationImpl(true, this.segmentation.isClass1Selected(), (byte)segmCount, this.segmentation.getSegmentationLocalRef());
            } else {
                this.segmentation = new SegmentationImpl(true, this.getIsProtocolClass1(), (byte)segmCount, this.sccpStackImpl.newSegmentationLocalRef());
            }
            byte[] importanceBuf = null;
            if (this.importance != null) {
                importanceBuf = this.importance.encode();
            }
            ArrayList<byte[]> res = new ArrayList<byte[]>();
            for (int num = 0; num < segmCount; ++num) {
                int fst = num * segmLen;
                int last = fst + segmLen;
                if (last > bf.length) {
                    last = bf.length;
                }
                int mLen = last - fst;
                ByteArrayOutputStream out = new ByteArrayOutputStream(fieldsLenXSegm + mLen);
                out.write(this.type);
                out.write(this.getSecondParamaterData());
                out.write(this.hopCounter.getValue());
                int len = 4;
                out.write(len);
                out.write(len += cdp.length);
                out.write(len += cnp.length);
                out.write(len += mLen);
                out.write((byte)cdp.length);
                out.write(cdp);
                out.write((byte)cnp.length);
                out.write(cnp);
                out.write((byte)mLen);
                out.write(bf, fst, mLen);
                out.write(16);
                this.segmentation.setRemainingSegments((byte)(this.segmentation.getRemainingSegments() - 1));
                byte[] b3 = this.segmentation.encode();
                out.write(b3.length);
                out.write(b3);
                this.segmentation.setFirstSegIndication(false);
                if (importanceBuf != null) {
                    out.write(18);
                    out.write(importanceBuf.length);
                    out.write(importanceBuf);
                }
                out.write(0);
                res.add(out.toByteArray());
            }
            return new EncodingResultData(EncodingResult.Success, null, res, null);
        }
        this.type = isServiceMessage ? 20 : 19;
        if (this.hopCounter == null) {
            this.hopCounter = new HopCounterImpl(15);
        }
        if (longMessageRuleType == LongMessageRuleType.LudtEnabled_WithSegmentationField) {
            this.segmentation = new SegmentationImpl(true, this.getIsProtocolClass1(), 0, this.sccpStackImpl.newSegmentationLocalRef());
        }
        if (bf.length > (availLen = maxMtp3UserDataLength - (fieldsLenL = this.sccpStackImpl.calculateLudtFieldsLengthWithoutData(cdp.length, cnp.length, this.segmentation != null, this.importance != null)))) {
            if (logger.isEnabledFor((Priority)Level.WARN)) {
                logger.warn((Object)String.format("Failure when sending a LUDT message: message is too long. SccpMessageSegment=%s", this));
            }
            return new EncodingResultData(EncodingResult.ReturnFailure, null, null, ReturnCauseValue.SEG_FAILURE);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(fieldsLenL + bf.length);
        out.write(this.type);
        out.write(this.getSecondParamaterData());
        out.write(this.hopCounter.getValue());
        int len = 7;
        out.write(len & 0xFF);
        out.write(len >> 8 & 0xFF);
        out.write((len += cdp.length - 1) & 0xFF);
        out.write(len >> 8 & 0xFF);
        out.write((len += cnp.length - 1) & 0xFF);
        out.write(len >> 8 & 0xFF);
        boolean optionalPresent = false;
        if (this.importance != null || this.segmentation != null) {
            out.write((len += bf.length) & 0xFF);
            out.write(len >> 8 & 0xFF);
            optionalPresent = true;
        } else {
            out.write(0);
            out.write(0);
        }
        out.write((byte)cdp.length);
        out.write(cdp);
        out.write((byte)cnp.length);
        out.write(cnp);
        out.write(bf.length & 0xFF);
        out.write(bf.length >> 8 & 0xFF);
        out.write(bf);
        if (this.segmentation != null) {
            out.write(16);
            b = this.segmentation.encode();
            out.write(b.length);
            out.write(b);
        }
        if (this.importance != null) {
            out.write(18);
            b = this.importance.encode();
            out.write(b.length);
            out.write(b);
        }
        if (optionalPresent) {
            out.write(0);
        }
        return new EncodingResultData(EncodingResult.Success, out.toByteArray(), null, null);
    }
}

