/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.sccp.impl.oam;

import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.mobicents.protocols.ss7.indicator.AddressIndicator;
import org.mobicents.protocols.ss7.indicator.NatureOfAddress;
import org.mobicents.protocols.ss7.indicator.NumberingPlan;
import org.mobicents.protocols.ss7.sccp.ConcernedSignalingPointCode;
import org.mobicents.protocols.ss7.sccp.LoadSharingAlgorithm;
import org.mobicents.protocols.ss7.sccp.LongMessageRule;
import org.mobicents.protocols.ss7.sccp.LongMessageRuleType;
import org.mobicents.protocols.ss7.sccp.Mtp3Destination;
import org.mobicents.protocols.ss7.sccp.Mtp3ServiceAccessPoint;
import org.mobicents.protocols.ss7.sccp.OriginationType;
import org.mobicents.protocols.ss7.sccp.RemoteSignalingPointCode;
import org.mobicents.protocols.ss7.sccp.RemoteSubSystem;
import org.mobicents.protocols.ss7.sccp.Router;
import org.mobicents.protocols.ss7.sccp.Rule;
import org.mobicents.protocols.ss7.sccp.RuleType;
import org.mobicents.protocols.ss7.sccp.SccpResource;
import org.mobicents.protocols.ss7.sccp.impl.SccpStackImpl;
import org.mobicents.protocols.ss7.sccp.parameter.GlobalTitle;
import org.mobicents.protocols.ss7.sccp.parameter.SccpAddress;
import org.mobicents.ss7.management.console.ShellExecutor;

public class SccpExecutor
implements ShellExecutor {
    private static final Logger logger = Logger.getLogger(SccpExecutor.class);
    private Router router = null;
    private SccpResource sccpResource = null;
    private SccpStackImpl sccpStack = null;

    public void setSccpStack(SccpStackImpl sccpStack) {
        this.router = sccpStack.getRouter();
        this.sccpResource = sccpStack.getSccpResource();
        this.sccpStack = sccpStack;
    }

    public String execute(String[] options) {
        if (this.router == null || this.sccpResource == null) {
            logger.warn((Object)"Router not set. Command will not be executed ");
            return "Server Error";
        }
        if (options == null || options.length < 2) {
            return "Invalid Command";
        }
        String firstOption = options[1];
        if (firstOption == null) {
            return "Invalid Command";
        }
        try {
            if (firstOption.equals("rule")) {
                return this.manageRule(options);
            }
            if (firstOption.equals("address")) {
                return this.manageAddress(options);
            }
            if (firstOption.equals("rsp")) {
                return this.manageRsp(options);
            }
            if (firstOption.equals("rss")) {
                return this.manageRss(options);
            }
            if (firstOption.equals("lmr")) {
                return this.manageLmr(options);
            }
            if (firstOption.equals("sap")) {
                return this.manageSap(options);
            }
            if (firstOption.equals("dest")) {
                return this.manageDest(options);
            }
            if (firstOption.equals("csp")) {
                return this.manageConcernedSpc(options);
            }
            if (firstOption.equals("set")) {
                return this.manageSet(options);
            }
            if (firstOption.equals("get")) {
                return this.manageGet(options);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error while executing command ", (Throwable)e);
            return e.getMessage();
        }
        catch (Throwable t) {
            return t.toString();
        }
        return "Invalid Command";
    }

    private String manageRss(String[] options) throws Exception {
        if (options.length < 3) {
            return "Invalid Command";
        }
        String command = options[2];
        if (command == null) {
            return "Invalid Command";
        }
        if (command.equals("create")) {
            if (options.length < 7) {
                return "Invalid Command";
            }
            int remoteSsId = Integer.parseInt(options[3]);
            int remoteSpc = Integer.parseInt(options[4]);
            int remoteSs = Integer.parseInt(options[5]);
            int remoteSsFlag = Integer.parseInt(options[6]);
            boolean markProhibitedWhenSpcResuming = false;
            if (options.length >= 8) {
                if (!options[7].toLowerCase().equals("prohibitedwhenspcresuming")) {
                    return "Invalid Command";
                }
                markProhibitedWhenSpcResuming = true;
            }
            this.sccpResource.addRemoteSsn(remoteSsId, remoteSpc, remoteSs, remoteSsFlag, markProhibitedWhenSpcResuming);
            return "Remote Subsystem successfully added";
        }
        if (command.equals("modify")) {
            if (options.length < 7) {
                return "Invalid Command";
            }
            int remoteSsId = Integer.parseInt(options[3]);
            int remoteSpc = Integer.parseInt(options[4]);
            int remoteSs = Integer.parseInt(options[5]);
            int remoteSsFlag = Integer.parseInt(options[6]);
            boolean markProhibitedWhenSpcResuming = false;
            if (options.length >= 8) {
                if (!options[7].toLowerCase().equals("prohibitedwhenspcresuming")) {
                    return "Invalid Command";
                }
                markProhibitedWhenSpcResuming = true;
            }
            this.sccpResource.modifyRemoteSsn(remoteSsId, remoteSpc, remoteSs, remoteSsFlag, markProhibitedWhenSpcResuming);
            return "Remote Subsystem successfully modified";
        }
        if (command.equals("delete")) {
            if (options.length < 4) {
                return "Invalid Command";
            }
            int remoteSsId = Integer.parseInt(options[3]);
            this.sccpResource.removeRemoteSsn(remoteSsId);
            return "Remote Subsystem successfully deleted";
        }
        if (command.equals("show")) {
            if (options.length == 4) {
                int remoteSsId = Integer.parseInt(options[3]);
                RemoteSubSystem rss = this.sccpResource.getRemoteSsn(remoteSsId);
                if (rss == null) {
                    return "Remote Subsystem doesn't exist";
                }
                return rss.toString();
            }
            if (this.sccpResource.getRemoteSsns().size() == 0) {
                return "Remote Subsystem doesn't exist";
            }
            Map idVsRemoteSsn = this.sccpResource.getRemoteSsns();
            StringBuffer sb = new StringBuffer();
            for (Integer e : idVsRemoteSsn.keySet()) {
                RemoteSubSystem rss = (RemoteSubSystem)idVsRemoteSsn.get(e);
                sb.append("key=");
                sb.append(e);
                sb.append("  ");
                sb.append(rss);
                sb.append("\n");
            }
            return sb.toString();
        }
        return "Invalid Command";
    }

    private String manageRsp(String[] options) throws Exception {
        if (options.length < 3) {
            return "Invalid Command";
        }
        String command = options[2];
        if (command == null) {
            return "Invalid Command";
        }
        if (command.equals("create")) {
            if (options.length < 7) {
                return "Invalid Command";
            }
            int remoteSpcId = Integer.parseInt(options[3]);
            int remoteSpc = Integer.parseInt(options[4]);
            int remoteSpcFlag = Integer.parseInt(options[5]);
            int mask = Integer.parseInt(options[6]);
            this.sccpResource.addRemoteSpc(remoteSpcId, remoteSpc, remoteSpcFlag, mask);
            return "Remote Signaling Pointcode successfully added";
        }
        if (command.equals("modify")) {
            if (options.length < 7) {
                return "Invalid Command";
            }
            int remoteSpcId = Integer.parseInt(options[3]);
            int remoteSpc = Integer.parseInt(options[4]);
            int remoteSpcFlag = Integer.parseInt(options[5]);
            int mask = Integer.parseInt(options[6]);
            this.sccpResource.modifyRemoteSpc(remoteSpcId, remoteSpc, remoteSpcFlag, mask);
            return "Remote Signaling Pointcode successfully modified";
        }
        if (command.equals("delete")) {
            if (options.length < 4) {
                return "Invalid Command";
            }
            int remoteSpcId = Integer.parseInt(options[3]);
            this.sccpResource.removeRemoteSpc(remoteSpcId);
            return "Remote Signaling Pointcode successfully deleted";
        }
        if (command.equals("show")) {
            if (options.length == 4) {
                int remoteSpcId = Integer.parseInt(options[3]);
                RemoteSignalingPointCode rspc = this.sccpResource.getRemoteSpc(remoteSpcId);
                if (rspc == null) {
                    return "Remote Signaling Pointcode doesn't exist";
                }
                return rspc.toString();
            }
            if (this.sccpResource.getRemoteSpcs().size() == 0) {
                return "Remote Signaling Pointcode doesn't exist";
            }
            StringBuffer sb = new StringBuffer();
            Map idVsRspc = this.sccpResource.getRemoteSpcs();
            Set rspIds = idVsRspc.keySet();
            for (Integer e : rspIds) {
                RemoteSignalingPointCode rsp = (RemoteSignalingPointCode)idVsRspc.get(e);
                sb.append("key=");
                sb.append(e);
                sb.append("  ");
                sb.append(rsp);
                sb.append("\n");
            }
            return sb.toString();
        }
        return "Invalid Command";
    }

    private String manageAddress(String[] options) throws Exception {
        if (options.length < 3) {
            return "Invalid Command";
        }
        String command = options[2];
        if (command == null) {
            return "Invalid Command";
        }
        if (command.equals("create")) {
            if (options.length < 4) {
                return "Invalid Command";
            }
            int addressId = Integer.parseInt(options[3]);
            SccpAddress address = this.createAddress(options, 4);
            this.router.addRoutingAddress(addressId, address);
            return "Address successfully added";
        }
        if (command.equals("modify")) {
            if (options.length < 4) {
                return "Invalid Command";
            }
            int addressId = Integer.parseInt(options[3]);
            SccpAddress address = this.createAddress(options, 4);
            this.router.modifyRoutingAddress(addressId, address);
            return "Address successfully modified";
        }
        if (command.equals("delete")) {
            if (options.length < 4) {
                return "Invalid Command";
            }
            int addressId = Integer.parseInt(options[3]);
            this.router.removeRoutingAddress(addressId);
            return "Address successfully deleted";
        }
        if (command.equals("show")) {
            if (options.length == 4) {
                int addressId = Integer.parseInt(options[3]);
                SccpAddress pa = this.router.getRoutingAddress(addressId);
                if (pa == null) {
                    return "Address doesn't exist";
                }
                return pa.toString();
            }
            if (this.router.getRoutingAddresses().size() == 0) {
                return "Address doesn't exist";
            }
            StringBuffer sb = new StringBuffer();
            Map idVsPrimAdd = this.router.getRoutingAddresses();
            for (Integer e : idVsPrimAdd.keySet()) {
                SccpAddress address = (SccpAddress)idVsPrimAdd.get(e);
                sb.append("key=");
                sb.append(e);
                sb.append("  ");
                sb.append(address);
                sb.append("\n");
            }
            return sb.toString();
        }
        return "Invalid Command";
    }

    private String manageRule(String[] options) throws Exception {
        if (options.length < 3) {
            return "Invalid Command";
        }
        String command = options[2];
        if (command == null) {
            return "Invalid Command";
        }
        if (command.equals("create")) {
            return this.createRule(options);
        }
        if (command.equals("modify")) {
            return this.modifyRule(options);
        }
        if (command.equals("delete")) {
            return this.deleteRule(options);
        }
        if (command.equals("show")) {
            return this.showRule(options);
        }
        return "Invalid Command";
    }

    private String createRule(String[] options) throws Exception {
        RuleType ruleType;
        if (options.length < 14 || options.length > 22) {
            return "Invalid Command";
        }
        int ruleId = Integer.parseInt(options[3]);
        String mask = options[4];
        if (mask == null) {
            return "Invalid Mask";
        }
        String s1 = options[12].toLowerCase();
        if (s1.equalsIgnoreCase(RuleType.Solitary.getType())) {
            ruleType = RuleType.Solitary;
        } else if (s1.equalsIgnoreCase(RuleType.Dominant.getType())) {
            ruleType = RuleType.Dominant;
        } else if (s1.equalsIgnoreCase(RuleType.Loadshared.getType())) {
            ruleType = RuleType.Loadshared;
        } else if (s1.equals("broadcast")) {
            ruleType = RuleType.Broadcast;
        } else {
            return "Invalid Command";
        }
        int pAddressId = Integer.parseInt(options[13]);
        int count = 14;
        int sAddressId = -1;
        Integer newcgpartyAddressId = null;
        LoadSharingAlgorithm algo = LoadSharingAlgorithm.Undefined;
        OriginationType originationType = OriginationType.All;
        while (count < options.length) {
            String key;
            if ((key = options[count++]) == null) {
                return "Invalid Command";
            }
            if (key.equals("loadsharing-algo")) {
                algo = LoadSharingAlgorithm.getInstance((String)options[count++]);
                continue;
            }
            if (key.equals("backup-addressid")) {
                sAddressId = Integer.parseInt(options[count++]);
                continue;
            }
            if (key.equals("newcgparty-addressid")) {
                newcgpartyAddressId = Integer.parseInt(options[count++]);
                continue;
            }
            if (key.equals("origination-type")) {
                originationType = OriginationType.getInstance((String)options[count++]);
                continue;
            }
            return "Invalid Command";
        }
        SccpAddress pattern = this.createAddress(options, 5);
        this.router.addRule(ruleId, ruleType, algo, originationType, pattern, mask, pAddressId, sAddressId, newcgpartyAddressId);
        return "Rule successfully added";
    }

    private String modifyRule(String[] options) throws Exception {
        RuleType ruleType;
        if (options.length < 14 || options.length > 22) {
            return "Invalid Command";
        }
        int ruleId = Integer.parseInt(options[3]);
        String mask = options[4];
        if (mask == null) {
            return "Invalid Mask";
        }
        String s1 = options[12].toLowerCase();
        if (s1.equals("solitary")) {
            ruleType = RuleType.Solitary;
        } else if (s1.equals("dominant")) {
            ruleType = RuleType.Dominant;
        } else if (s1.equals("loadshared")) {
            ruleType = RuleType.Loadshared;
        } else if (s1.equals("broadcast")) {
            ruleType = RuleType.Broadcast;
        } else {
            return "Invalid Command";
        }
        int pAddressId = Integer.parseInt(options[13]);
        int count = 14;
        int sAddressId = -1;
        Integer newcgpartyAddressId = null;
        LoadSharingAlgorithm algo = LoadSharingAlgorithm.Undefined;
        OriginationType originationType = OriginationType.All;
        while (count < options.length) {
            String key;
            if ((key = options[count++]) == null) {
                return "Invalid Command";
            }
            if (key.equals("loadsharing-algo")) {
                algo = LoadSharingAlgorithm.getInstance((String)options[count++]);
                continue;
            }
            if (key.equals("backup-addressid")) {
                sAddressId = Integer.parseInt(options[count++]);
                continue;
            }
            if (key.equals("newcgparty-addressid")) {
                newcgpartyAddressId = Integer.parseInt(options[count++]);
                continue;
            }
            if (key.equals("origination-type")) {
                originationType = OriginationType.getInstance((String)options[count++]);
                continue;
            }
            return "Invalid Command";
        }
        SccpAddress pattern = this.createAddress(options, 5);
        this.router.modifyRule(ruleId, ruleType, algo, originationType, pattern, mask, pAddressId, sAddressId, newcgpartyAddressId);
        return "Rule successfully modified";
    }

    private String deleteRule(String[] options) throws Exception {
        if (options.length < 4) {
            return "Invalid Command";
        }
        int ruleId = Integer.parseInt(options[3]);
        this.router.removeRule(ruleId);
        return "Rule successfully removed";
    }

    private String showRule(String[] options) throws Exception {
        if (options.length < 3) {
            return "Invalid Command";
        }
        int ruleId = -1;
        if (options.length == 4) {
            ruleId = Integer.parseInt(options[3]);
            Rule rule = this.router.getRule(ruleId);
            if (rule == null) {
                return "Rule doesn't exist";
            }
            return rule.toString();
        }
        if (this.router.getRules().size() == 0) {
            return "Rule doesn't exist";
        }
        Map idVsRule = this.router.getRules();
        StringBuffer sb = new StringBuffer();
        for (Integer e : idVsRule.keySet()) {
            Rule rule = (Rule)idVsRule.get(e);
            sb.append("key=");
            sb.append(e);
            sb.append("  Rule=");
            sb.append(rule);
            sb.append("\n");
        }
        return sb.toString();
    }

    private SccpAddress createAddress(String[] options, int index) throws Exception {
        SccpAddress sccpAddress = null;
        int ai = Integer.parseInt(options[index++]);
        int pc = 0;
        int ssn = 0;
        AddressIndicator aiObj = new AddressIndicator((byte)ai);
        pc = Integer.parseInt(options[index++]);
        ssn = Integer.parseInt(options[index++]);
        int tt = Integer.parseInt(options[index++]);
        NumberingPlan np = NumberingPlan.valueOf((int)Integer.parseInt(options[index++]));
        NatureOfAddress nai = NatureOfAddress.valueOf((int)Integer.parseInt(options[index++]));
        String digits = options[index++];
        GlobalTitle gt = null;
        switch (aiObj.getGlobalTitleIndicator()) {
            case GLOBAL_TITLE_INCLUDES_NATURE_OF_ADDRESS_INDICATOR_ONLY: {
                gt = GlobalTitle.getInstance((NatureOfAddress)nai, (String)digits);
                break;
            }
            case GLOBAL_TITLE_INCLUDES_TRANSLATION_TYPE_ONLY: {
                gt = GlobalTitle.getInstance((int)tt, (String)digits);
                break;
            }
            case GLOBAL_TITLE_INCLUDES_TRANSLATION_TYPE_NUMBERING_PLAN_AND_ENCODING_SCHEME: {
                gt = GlobalTitle.getInstance((int)tt, (NumberingPlan)np, (String)digits);
                break;
            }
            case GLOBAL_TITLE_INCLUDES_TRANSLATION_TYPE_NUMBERING_PLAN_ENCODING_SCHEME_AND_NATURE_OF_ADDRESS: {
                gt = GlobalTitle.getInstance((int)tt, (NumberingPlan)np, (NatureOfAddress)nai, (String)digits);
                break;
            }
            case NO_GLOBAL_TITLE_INCLUDED: {
                gt = GlobalTitle.getInstance((String)digits);
            }
        }
        sccpAddress = new SccpAddress(aiObj.getRoutingIndicator(), pc, gt, ssn);
        return sccpAddress;
    }

    private String manageLmr(String[] options) throws Exception {
        if (options.length < 3) {
            return "Invalid Command";
        }
        String command = options[2];
        if (command == null) {
            return "Invalid Command";
        }
        if (command.equals("create")) {
            LongMessageRuleType ruleType;
            if (options.length < 7) {
                return "Invalid Command";
            }
            int lmrId = Integer.parseInt(options[3]);
            int firstSpc = Integer.parseInt(options[4]);
            int lastSpc = Integer.parseInt(options[5]);
            String s1 = options[6].toLowerCase();
            if (s1.equals("udt")) {
                ruleType = LongMessageRuleType.LongMessagesForbidden;
            } else if (s1.equals("xudt")) {
                ruleType = LongMessageRuleType.XudtEnabled;
            } else if (s1.equals("ludt")) {
                ruleType = LongMessageRuleType.LudtEnabled;
            } else if (s1.equals("ludt_segm")) {
                ruleType = LongMessageRuleType.LudtEnabled_WithSegmentationField;
            } else {
                return "Invalid Command";
            }
            this.router.addLongMessageRule(lmrId, firstSpc, lastSpc, ruleType);
            return "Long message rule successfully added";
        }
        if (command.equals("modify")) {
            LongMessageRuleType ruleType;
            if (options.length < 7) {
                return "Invalid Command";
            }
            int lmrId = Integer.parseInt(options[3]);
            int firstSpc = Integer.parseInt(options[4]);
            int lastSpc = Integer.parseInt(options[5]);
            String s1 = options[6].toLowerCase();
            if (s1.equals("udt")) {
                ruleType = LongMessageRuleType.LongMessagesForbidden;
            } else if (s1.equals("xudt")) {
                ruleType = LongMessageRuleType.XudtEnabled;
            } else if (s1.equals("ludt")) {
                ruleType = LongMessageRuleType.LudtEnabled;
            } else if (s1.equals("ludt_segm")) {
                ruleType = LongMessageRuleType.LudtEnabled_WithSegmentationField;
            } else {
                return "Invalid Command";
            }
            this.router.modifyLongMessageRule(lmrId, firstSpc, lastSpc, ruleType);
            return "Long message rule successfully modified";
        }
        if (command.equals("delete")) {
            if (options.length < 4) {
                return "Invalid Command";
            }
            int lmrId = Integer.parseInt(options[3]);
            this.router.removeLongMessageRule(lmrId);
            return "Long message rule successfully deleted";
        }
        if (command.equals("show")) {
            if (options.length == 4) {
                int lmrId = Integer.parseInt(options[3]);
                LongMessageRule lmr = this.router.getLongMessageRule(lmrId);
                if (lmr == null) {
                    return "Long message rule doesn't exist";
                }
                return lmr.toString();
            }
            if (this.router.getLongMessageRules().size() == 0) {
                return "Long message rule doesn't exist";
            }
            Map idVsLngmsgRule = this.router.getLongMessageRules();
            StringBuffer sb = new StringBuffer();
            for (Integer e : idVsLngmsgRule.keySet()) {
                LongMessageRule lmr = (LongMessageRule)idVsLngmsgRule.get(e);
                sb.append("key=");
                sb.append(e);
                sb.append("  ");
                sb.append(lmr);
                sb.append("\n");
            }
            return sb.toString();
        }
        return "Invalid Command";
    }

    private String manageSap(String[] options) throws Exception {
        if (options.length < 3) {
            return "Invalid Command";
        }
        String command = options[2];
        if (command == null) {
            return "Invalid Command";
        }
        if (command.equals("create")) {
            if (options.length < 7) {
                return "Invalid Command";
            }
            int sapId = Integer.parseInt(options[3]);
            int mtp3Id = Integer.parseInt(options[4]);
            int opc = Integer.parseInt(options[5]);
            int ni = Integer.parseInt(options[6]);
            this.router.addMtp3ServiceAccessPoint(sapId, mtp3Id, opc, ni);
            return "Service access point successfully added";
        }
        if (command.equals("modify")) {
            if (options.length < 7) {
                return "Invalid Command";
            }
            int sapId = Integer.parseInt(options[3]);
            int mtp3Id = Integer.parseInt(options[4]);
            int opc = Integer.parseInt(options[5]);
            int ni = Integer.parseInt(options[6]);
            this.router.modifyMtp3ServiceAccessPoint(sapId, mtp3Id, opc, ni);
            return "Service access point successfully modified";
        }
        if (command.equals("delete")) {
            if (options.length < 4) {
                return "Invalid Command";
            }
            int sapId = Integer.parseInt(options[3]);
            this.router.removeMtp3ServiceAccessPoint(sapId);
            return "Service access point successfully deleted";
        }
        if (command.equals("show")) {
            if (options.length == 4) {
                int sapId = Integer.parseInt(options[3]);
                Mtp3ServiceAccessPoint sap = this.router.getMtp3ServiceAccessPoint(sapId);
                if (sap == null) {
                    return "Service access point doesn't exist";
                }
                return sap.toString();
            }
            if (this.router.getMtp3ServiceAccessPoints().size() == 0) {
                return "Service access point doesn't exist";
            }
            Map idVsMtp3SerAccPt = this.router.getMtp3ServiceAccessPoints();
            StringBuffer sb = new StringBuffer();
            for (Integer e : idVsMtp3SerAccPt.keySet()) {
                Mtp3ServiceAccessPoint sap = (Mtp3ServiceAccessPoint)idVsMtp3SerAccPt.get(e);
                sb.append("key=");
                sb.append(e);
                sb.append("  ");
                sb.append(sap);
                sb.append("\n");
            }
            return sb.toString();
        }
        return "Invalid Command";
    }

    private String manageDest(String[] options) throws Exception {
        if (options.length < 4) {
            return "Invalid Command";
        }
        String command = options[2];
        if (command == null) {
            return "Invalid Command";
        }
        if (command.equals("create")) {
            if (options.length < 10) {
                return "Invalid Command";
            }
            int sapId = Integer.parseInt(options[3]);
            int destId = Integer.parseInt(options[4]);
            int firstDpc = Integer.parseInt(options[5]);
            int lastDpc = Integer.parseInt(options[6]);
            int firstSls = Integer.parseInt(options[7]);
            int lastSls = Integer.parseInt(options[8]);
            int slsMask = Integer.parseInt(options[9]);
            this.router.addMtp3Destination(sapId, destId, firstDpc, lastDpc, firstSls, lastSls, slsMask);
            return "Destination definition successfully added";
        }
        if (command.equals("modify")) {
            if (options.length < 10) {
                return "Invalid Command";
            }
            int sapId = Integer.parseInt(options[3]);
            int destId = Integer.parseInt(options[4]);
            int firstDpc = Integer.parseInt(options[5]);
            int lastDpc = Integer.parseInt(options[6]);
            int firstSls = Integer.parseInt(options[7]);
            int lastSls = Integer.parseInt(options[8]);
            int slsMask = Integer.parseInt(options[9]);
            this.router.modifyMtp3Destination(sapId, destId, firstDpc, lastDpc, firstSls, lastSls, slsMask);
            return "Destination definition successfully modified";
        }
        if (command.equals("delete")) {
            if (options.length < 5) {
                return "Invalid Command";
            }
            int sapId = Integer.parseInt(options[3]);
            int destId = Integer.parseInt(options[4]);
            this.router.removeMtp3Destination(sapId, destId);
            return "Destination definition successfully deleted";
        }
        if (command.equals("show")) {
            if (options.length == 5) {
                int sapId = Integer.parseInt(options[3]);
                Mtp3ServiceAccessPoint sap = this.router.getMtp3ServiceAccessPoint(sapId);
                if (sap == null) {
                    return "Service access point doesn't exist";
                }
                int destId = Integer.parseInt(options[4]);
                Mtp3Destination dest = sap.getMtp3Destination(destId);
                if (dest == null) {
                    return "Destination definition doesn't exist";
                }
                return dest.toString();
            }
            if (options.length == 4) {
                int sapId = Integer.parseInt(options[3]);
                Mtp3ServiceAccessPoint sap = this.router.getMtp3ServiceAccessPoint(sapId);
                if (sap == null) {
                    return "Service access point doesn't exist";
                }
                return sap.toString();
            }
            return "Invalid Command";
        }
        return "Invalid Command";
    }

    private String manageConcernedSpc(String[] options) throws Exception {
        if (options.length < 3) {
            return "Invalid Command";
        }
        String command = options[2];
        if (command == null) {
            return "Invalid Command";
        }
        if (command.equals("create")) {
            if (options.length < 5) {
                return "Invalid Command";
            }
            int concernedSpcId = Integer.parseInt(options[3]);
            int conSpc = Integer.parseInt(options[4]);
            this.sccpResource.addConcernedSpc(concernedSpcId, conSpc);
            return "Concerned spc successfully added";
        }
        if (command.equals("modify")) {
            if (options.length < 5) {
                return "Invalid Command";
            }
            int concernedSpcId = Integer.parseInt(options[3]);
            if (this.sccpResource.getConcernedSpc(concernedSpcId) == null) {
                return "Concerned spc doesn't exist";
            }
            int conSpc = Integer.parseInt(options[4]);
            this.sccpResource.modifyConcernedSpc(concernedSpcId, conSpc);
            return "Concerned spc successfully modified";
        }
        if (command.equals("delete")) {
            if (options.length < 4) {
                return "Invalid Command";
            }
            int concernedSpcId = Integer.parseInt(options[3]);
            this.sccpResource.removeConcernedSpc(concernedSpcId);
            return "Concerned spc successfully deleted";
        }
        if (command.equals("show")) {
            if (options.length == 4) {
                int concernedSpcId = Integer.parseInt(options[3]);
                ConcernedSignalingPointCode conSpc = this.sccpResource.getConcernedSpc(concernedSpcId);
                if (conSpc == null) {
                    return "Concerned spc doesn't exist";
                }
                return conSpc.toString();
            }
            if (this.sccpResource.getConcernedSpcs().size() == 0) {
                return "Concerned spc doesn't exist";
            }
            StringBuffer sb = new StringBuffer();
            Map idvsCsp = this.sccpResource.getConcernedSpcs();
            for (Integer e : idvsCsp.keySet()) {
                ConcernedSignalingPointCode ConcSpc = (ConcernedSignalingPointCode)idvsCsp.get(e);
                sb.append("key=");
                sb.append(e);
                sb.append("  ");
                sb.append(ConcSpc);
                sb.append("\n");
            }
            return sb.toString();
        }
        return "Invalid Command";
    }

    private String manageSet(String[] options) throws Exception {
        if (options.length < 4) {
            return "Invalid Command";
        }
        String parName = options[2].toLowerCase();
        if (parName.equals("zmarginxudtmessage")) {
            int val = Integer.parseInt(options[3]);
            this.sccpStack.setZMarginXudtMessage(val);
        } else if (parName.equals("reassemblytimerdelay")) {
            int val = Integer.parseInt(options[3]);
            this.sccpStack.setReassemblyTimerDelay(val);
        } else if (parName.equals("maxdatamessage")) {
            int val = Integer.parseInt(options[3]);
            this.sccpStack.setMaxDataMessage(val);
        } else if (parName.equals("removespc")) {
            boolean val = Boolean.parseBoolean(options[3]);
            this.sccpStack.setRemoveSpc(val);
        } else if (parName.equals("ssttimerduration_min")) {
            int val = Integer.parseInt(options[3]);
            this.sccpStack.setSstTimerDuration_Min(val);
        } else if (parName.equals("ssttimerduration_max")) {
            int val = Integer.parseInt(options[3]);
            this.sccpStack.setSstTimerDuration_Max(val);
        } else if (parName.equals("ssttimerduration_increasefactor")) {
            double val = Double.parseDouble(options[3]);
            this.sccpStack.setSstTimerDuration_IncreaseFactor(val);
        } else {
            return "Invalid Command";
        }
        return "Parameter has been successfully set";
    }

    private String manageGet(String[] options) throws Exception {
        if (options.length < 2) {
            return "Invalid Command";
        }
        if (options.length == 3) {
            String parName = options[2].toLowerCase();
            StringBuilder sb = new StringBuilder();
            sb.append(options[2]);
            sb.append(" = ");
            if (parName.equals("zmarginxudtmessage")) {
                sb.append(this.sccpStack.getZMarginXudtMessage());
            } else if (parName.equals("reassemblytimerdelay")) {
                sb.append(this.sccpStack.getReassemblyTimerDelay());
            } else if (parName.equals("maxdatamessage")) {
                sb.append(this.sccpStack.getMaxDataMessage());
            } else if (parName.equals("removespc")) {
                sb.append(this.sccpStack.isRemoveSpc());
            } else if (parName.equals("ssttimerduration_min")) {
                sb.append(this.sccpStack.getSstTimerDuration_Min());
            } else if (parName.equals("ssttimerduration_max")) {
                sb.append(this.sccpStack.getSstTimerDuration_Max());
            } else if (parName.equals("ssttimerduration_increasefactor")) {
                sb.append(this.sccpStack.getSstTimerDuration_IncreaseFactor());
            } else {
                return "Invalid Command";
            }
            return sb.toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("zMarginXudtMessage = ");
        sb.append(this.sccpStack.getZMarginXudtMessage());
        sb.append("\n");
        sb.append("reassemblyTimerDelay = ");
        sb.append(this.sccpStack.getReassemblyTimerDelay());
        sb.append("\n");
        sb.append("maxDataMessage = ");
        sb.append(this.sccpStack.getMaxDataMessage());
        sb.append("\n");
        sb.append("removeSpc = ");
        sb.append(this.sccpStack.isRemoveSpc());
        sb.append("\n");
        sb.append("sstTimerDuration_Min = ");
        sb.append(this.sccpStack.getSstTimerDuration_Min());
        sb.append("\n");
        sb.append("sstTimerDuration_Max = ");
        sb.append(this.sccpStack.getSstTimerDuration_Max());
        sb.append("\n");
        sb.append("sstTimerDuration_IncreaseFactor = ");
        sb.append(this.sccpStack.getSstTimerDuration_IncreaseFactor());
        sb.append("\n");
        return sb.toString();
    }

    public boolean handles(String command) {
        return command.startsWith("sccp");
    }
}

