/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.sccp.impl.parameter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mobicents.protocols.ss7.indicator.NatureOfAddress;
import org.mobicents.protocols.ss7.sccp.impl.parameter.GTCodec;
import org.mobicents.protocols.ss7.sccp.parameter.GT0001;
import org.mobicents.protocols.ss7.sccp.parameter.GlobalTitle;

public class GT0001Codec
extends GTCodec {
    private GT0001 gt;

    protected GT0001Codec() {
    }

    public GT0001Codec(GT0001 gt) {
        this.gt = gt;
    }

    public GlobalTitle decode(InputStream in) throws IOException {
        int b = in.read() & 0xFF;
        NatureOfAddress nai = NatureOfAddress.valueOf((int)(b & 0x7F));
        boolean odd = (b & 0x80) == 128;
        String digits = "";
        while (in.available() > 0) {
            b = in.read() & 0xFF;
            digits = digits + Integer.toHexString(b & 0xF) + Integer.toHexString((b & 0xF0) >> 4);
        }
        if (odd) {
            digits = digits.substring(0, digits.length() - 1);
        }
        return new GT0001(nai, digits);
    }

    public void encode(OutputStream out) throws IOException {
        String digits = this.gt.getDigits();
        boolean odd = digits.length() % 2 != 0;
        int b = 0;
        if (odd) {
            b |= 0xFFFFFF80;
        }
        out.write((byte)(b |= (byte)this.gt.getNoA().getValue()));
        int count = odd ? digits.length() - 1 : digits.length();
        for (int i = 0; i < count - 1; i += 2) {
            String ds1 = digits.substring(i, i + 1);
            String ds2 = digits.substring(i + 1, i + 2);
            int d1 = Integer.parseInt(ds1, 16);
            int d2 = Integer.parseInt(ds2, 16);
            b = (byte)(d2 << 4 | d1);
            out.write(b);
        }
        if (odd) {
            String ds1 = digits.substring(count, count + 1);
            int d = Integer.parseInt(ds1);
            b = (byte)(d & 0xF);
            out.write(b);
        }
    }
}

