/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.sccp.impl.parameter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mobicents.protocols.ss7.sccp.impl.parameter.GTCodec;
import org.mobicents.protocols.ss7.sccp.parameter.GT0010;
import org.mobicents.protocols.ss7.sccp.parameter.GlobalTitle;

public class GT0010Codec
extends GTCodec {
    private GT0010 gt;

    public GT0010Codec() {
    }

    public GT0010Codec(GT0010 gt) {
        this.gt = gt;
    }

    public GlobalTitle decode(InputStream in) throws IOException {
        int b;
        int tt = b = in.read() & 0xFF;
        String digits = "";
        while (in.available() > 0) {
            b = in.read() & 0xFF;
            digits = digits + Integer.toHexString(b & 0xF) + Integer.toHexString((b & 0xF0) >> 4);
        }
        return new GT0010(tt, digits);
    }

    public void encode(OutputStream out) throws IOException {
        if (this.gt == null) {
            throw new IOException("No GT to parse");
        }
        out.write(this.gt.getTranslationType());
        String digits = this.gt.getDigits();
        boolean odd = digits.length() % 2 != 0;
        int count = odd ? digits.length() - 1 : digits.length();
        for (int i = 0; i < count - 1; i += 2) {
            String ds1 = digits.substring(i, i + 1);
            String ds2 = digits.substring(i + 1, i + 2);
            int d1 = Integer.parseInt(ds1, 16);
            int d2 = Integer.parseInt(ds2, 16);
            byte b = (byte)(d2 << 4 | d1);
            out.write(b);
        }
        if (odd) {
            String ds1 = digits.substring(count, count + 1);
            int d = Integer.parseInt(ds1);
            byte b = (byte)(d & 0xF);
            out.write(b);
        }
    }
}

