/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.sccp.impl.parameter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mobicents.protocols.ss7.indicator.EncodingScheme;
import org.mobicents.protocols.ss7.indicator.NumberingPlan;
import org.mobicents.protocols.ss7.sccp.impl.parameter.GTCodec;
import org.mobicents.protocols.ss7.sccp.parameter.GT0011;
import org.mobicents.protocols.ss7.sccp.parameter.GlobalTitle;

public class GT0011Codec
extends GTCodec {
    private GT0011 gt;

    public GT0011Codec() {
    }

    public GT0011Codec(GT0011 gt) {
        this.gt = gt;
    }

    public GlobalTitle decode(InputStream in) throws IOException {
        int b;
        int tt = b = in.read() & 0xFF;
        b = in.read() & 0xFF;
        EncodingScheme es = EncodingScheme.valueOf((int)(b & 0xF));
        NumberingPlan np = NumberingPlan.valueOf((int)((b & 0xF0) >> 4));
        String digits = es.decodeDigits(in);
        return new GT0011(tt, np, digits);
    }

    public void encode(OutputStream out) throws IOException {
        String digits = this.gt.getDigits();
        EncodingScheme es = digits.length() % 2 == 0 ? EncodingScheme.BCD_EVEN : EncodingScheme.BCD_ODD;
        out.write(this.gt.getTranslationType());
        out.write(this.gt.getNp().getValue() << 4 | es.getValue());
        es.encodeDigits(digits, out);
    }
}

