/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.sccp.impl.parameter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mobicents.protocols.ss7.indicator.EncodingScheme;
import org.mobicents.protocols.ss7.indicator.NatureOfAddress;
import org.mobicents.protocols.ss7.indicator.NumberingPlan;
import org.mobicents.protocols.ss7.sccp.impl.parameter.GTCodec;
import org.mobicents.protocols.ss7.sccp.parameter.GT0100;
import org.mobicents.protocols.ss7.sccp.parameter.GlobalTitle;

public class GT0100Codec
extends GTCodec {
    private GT0100 gt;

    public GT0100Codec() {
    }

    public GT0100Codec(GT0100 gt) {
        this.gt = gt;
    }

    public GlobalTitle decode(InputStream in) throws IOException {
        int b1 = in.read() & 0xFF;
        int b2 = in.read() & 0xFF;
        int b3 = in.read() & 0xFF;
        int tt = b1;
        EncodingScheme es = EncodingScheme.valueOf((int)(b2 & 0xF));
        NumberingPlan np = NumberingPlan.valueOf((int)((b2 & 0xF0) >> 4));
        NatureOfAddress na = NatureOfAddress.valueOf((int)(b3 & 0x7F));
        String digits = es.decodeDigits(in);
        return new GT0100(tt, np, na, digits);
    }

    public void encode(OutputStream out) throws IOException {
        String digits = this.gt.getDigits();
        EncodingScheme es = digits.length() % 2 == 0 ? EncodingScheme.BCD_EVEN : EncodingScheme.BCD_ODD;
        out.write((byte)this.gt.getTranslationType());
        byte b = (byte)(this.gt.getNumberingPlan().getValue() << 4 | es.getValue());
        out.write(b);
        b = (byte)(this.gt.getNatureOfAddress().getValue() & 0x7F);
        out.write(b);
        es.encodeDigits(digits, out);
    }
}

