/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.sccp.impl.parameter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.mobicents.protocols.ss7.indicator.AddressIndicator;
import org.mobicents.protocols.ss7.indicator.GlobalTitleIndicator;
import org.mobicents.protocols.ss7.sccp.impl.parameter.GTCodec;
import org.mobicents.protocols.ss7.sccp.parameter.GlobalTitle;
import org.mobicents.protocols.ss7.sccp.parameter.SccpAddress;

public class SccpAddressCodec {
    private static final byte ROUTE_ON_PC_FLAG = 64;
    private static final short REMOVE_PC_FLAG = 254;
    private static final byte PC_PRESENT_FLAG = 1;

    public static SccpAddress decode(byte[] buffer) throws IOException {
        ByteArrayInputStream bin = new ByteArrayInputStream(buffer);
        int b = bin.read() & 0xFF;
        AddressIndicator addressIndicator = new AddressIndicator((byte)b);
        int pc = 0;
        if (addressIndicator.pcPresent()) {
            int b1 = bin.read() & 0xFF;
            int b2 = bin.read() & 0xFF;
            pc = (b2 & 0x3F) << 8 | b1;
        }
        int ssn = 0;
        if (addressIndicator.ssnPresent()) {
            ssn = bin.read() & 0xFF;
        }
        GlobalTitle globalTitle = GTCodec.decode(addressIndicator.getGlobalTitleIndicator(), bin);
        return new SccpAddress(addressIndicator.getRoutingIndicator(), pc, globalTitle, ssn);
    }

    public static byte[] encode(SccpAddress address, boolean removeSpc) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        AddressIndicator ai = address.getAddressIndicator();
        byte aiValue = ai.getValue();
        if (removeSpc && (aiValue & 0x40) == 0) {
            aiValue = (byte)(aiValue & 0xFE);
        }
        out.write(aiValue);
        if ((aiValue & 1) == 1) {
            byte b1 = (byte)address.getSignalingPointCode();
            byte b2 = (byte)(address.getSignalingPointCode() >> 8 & 0x3F);
            out.write(b1);
            out.write(b2);
        }
        if (ai.ssnPresent()) {
            out.write((byte)address.getSubsystemNumber());
        }
        if (ai.getGlobalTitleIndicator() != GlobalTitleIndicator.NO_GLOBAL_TITLE_INCLUDED) {
            GTCodec.encode(address.getGlobalTitle(), out);
        }
        return out.toByteArray();
    }
}

