/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.sccp.impl.parameter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mobicents.protocols.ss7.sccp.impl.parameter.AbstractParameter;
import org.mobicents.protocols.ss7.sccp.parameter.Segmentation;

public class SegmentationImpl
extends AbstractParameter
implements Segmentation {
    private static final int _TRUE = 1;
    private static final int _FALSE = 0;
    private boolean firstSegIndication = false;
    private boolean class1Selected = false;
    private byte remainingSegments = (byte)15;
    private int segmentationLocalRef;

    public SegmentationImpl() {
    }

    public SegmentationImpl(boolean firstSegIndication, boolean class1Selected, byte remainingSegments, int segmentationLocalRef) {
        this.firstSegIndication = firstSegIndication;
        this.class1Selected = class1Selected;
        this.remainingSegments = remainingSegments;
        this.segmentationLocalRef = segmentationLocalRef;
    }

    public boolean isFirstSegIndication() {
        return this.firstSegIndication;
    }

    public void setFirstSegIndication(boolean firstSegIndication) {
        this.firstSegIndication = firstSegIndication;
    }

    public boolean isClass1Selected() {
        return this.class1Selected;
    }

    public void setClass1Selected(boolean class1Selected) {
        this.class1Selected = class1Selected;
    }

    public byte getRemainingSegments() {
        return this.remainingSegments;
    }

    public void setRemainingSegments(byte remainingSegments) {
        if (remainingSegments < 0 || remainingSegments > 15) {
            throw new IllegalArgumentException("Wrong value of remaining segments: " + remainingSegments);
        }
        this.remainingSegments = remainingSegments;
    }

    public int getSegmentationLocalRef() {
        return this.segmentationLocalRef;
    }

    public void setSegmentationLocalRef(int segmentationLocalRef) {
        this.segmentationLocalRef = segmentationLocalRef;
    }

    public void decode(InputStream in) throws IOException {
        byte[] buffer = new byte[in.read()];
        if (in.read(buffer) != buffer.length) {
            throw new IOException();
        }
        this.decode(buffer);
    }

    public void encode(OutputStream os) throws IOException {
        byte[] buffer = this.encode();
        os.write(buffer.length);
        os.write(buffer);
    }

    public void decode(byte[] buffer) throws IOException {
        byte v = buffer[0];
        this.firstSegIndication = (v >> 7 & 1) == 1;
        this.class1Selected = (v >> 6 & 1) == 1;
        this.remainingSegments = (byte)(v & 0xF);
        this.segmentationLocalRef = (buffer[1] & 0xFF) + ((buffer[2] & 0xFF) << 8) + ((buffer[3] & 0xFF) << 16);
    }

    public byte[] encode() throws IOException {
        byte[] buffer = new byte[4];
        int v = this.remainingSegments & 0xF;
        v |= (this.class1Selected ? 1 : 0) << 6;
        buffer[0] = (byte)(v |= (this.firstSegIndication ? 1 : 0) << 7);
        buffer[1] = (byte)(this.segmentationLocalRef & 0xFF);
        buffer[2] = (byte)(this.segmentationLocalRef >> 8 & 0xFF);
        buffer[3] = (byte)(this.segmentationLocalRef >> 16 & 0xFF);
        return buffer;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Segmentation [remainingSegments=");
        sb.append(this.getRemainingSegments());
        if (this.isFirstSegIndication()) {
            sb.append(" firstSegment");
        }
        if (this.isClass1Selected()) {
            sb.append(" class1Selected");
        }
        sb.append(" localRef=");
        sb.append(this.getSegmentationLocalRef());
        sb.append("]");
        return sb.toString();
    }
}

