/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.sccp.impl.router;

import java.util.Map;
import javolution.util.FastMap;
import javolution.xml.XMLFormat;
import javolution.xml.XMLSerializable;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.ss7.sccp.impl.router.Mtp3Destination;
import org.mobicents.protocols.ss7.sccp.impl.router.Mtp3DestinationMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mtp3ServiceAccessPoint
implements XMLSerializable {
    private static final String MTP3_ID = "mtp3Id";
    private static final String OPC = "opc";
    private static final String NI = "ni";
    private int mtp3Id;
    private int opc;
    private int ni;
    private Mtp3DestinationMap<Integer, Mtp3Destination> dpcList = new Mtp3DestinationMap();
    protected static final XMLFormat<Mtp3ServiceAccessPoint> XML = new XMLFormat<Mtp3ServiceAccessPoint>(Mtp3ServiceAccessPoint.class){

        public void write(Mtp3ServiceAccessPoint sap, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute(Mtp3ServiceAccessPoint.MTP3_ID, sap.mtp3Id);
            xml.setAttribute(Mtp3ServiceAccessPoint.OPC, sap.opc);
            xml.setAttribute(Mtp3ServiceAccessPoint.NI, sap.ni);
            xml.add((Object)sap.dpcList);
        }

        public void read(XMLFormat.InputElement xml, Mtp3ServiceAccessPoint sap) throws XMLStreamException {
            sap.mtp3Id = xml.getAttribute(Mtp3ServiceAccessPoint.MTP3_ID).toInt();
            sap.opc = xml.getAttribute(Mtp3ServiceAccessPoint.OPC).toInt();
            sap.ni = xml.getAttribute(Mtp3ServiceAccessPoint.NI).toInt();
            sap.dpcList = (Mtp3DestinationMap)((Object)xml.getNext());
        }
    };

    public Mtp3ServiceAccessPoint() {
    }

    public Mtp3ServiceAccessPoint(int mtp3Id, int opc, int ni) {
        this.mtp3Id = mtp3Id;
        this.opc = opc;
        this.ni = ni;
    }

    public int getMtp3Id() {
        return this.mtp3Id;
    }

    public int getOpc() {
        return this.opc;
    }

    public int getNi() {
        return this.ni;
    }

    public Mtp3Destination getMtp3Destination(int destId) {
        return (Mtp3Destination)this.dpcList.get(destId);
    }

    public FastMap<Integer, Mtp3Destination> getMtp3Destinations() {
        return this.dpcList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMtp3Destination(int destId, Mtp3Destination dest) {
        Mtp3ServiceAccessPoint mtp3ServiceAccessPoint = this;
        synchronized (mtp3ServiceAccessPoint) {
            Mtp3DestinationMap newDpcList = new Mtp3DestinationMap();
            newDpcList.putAll((Map)((Object)this.dpcList));
            newDpcList.put(destId, dest);
            this.dpcList = newDpcList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMtp3Destination(int destId) {
        Mtp3ServiceAccessPoint mtp3ServiceAccessPoint = this;
        synchronized (mtp3ServiceAccessPoint) {
            Mtp3DestinationMap newDpcList = new Mtp3DestinationMap();
            newDpcList.putAll((Map)((Object)this.dpcList));
            newDpcList.remove(destId);
            this.dpcList = newDpcList;
        }
    }

    public boolean matches(int dpc, int sls) {
        FastMap.Entry e = this.dpcList.head();
        FastMap.Entry end = this.dpcList.tail();
        while ((e = e.getNext()) != end) {
            if (!((Mtp3Destination)e.getValue()).match(dpc, sls)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("mtp3Id=").append(this.mtp3Id).append(", opc=").append(this.opc).append(", ni=").append(this.ni).append(", dpcList=[");
        boolean isFirst = true;
        FastMap.Entry e = this.dpcList.head();
        FastMap.Entry end = this.dpcList.tail();
        while ((e = e.getNext()) != end) {
            Integer id = (Integer)e.getKey();
            Mtp3Destination dest = (Mtp3Destination)e.getValue();
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            sb.append("[key=");
            sb.append(id);
            sb.append(", ");
            sb.append(dest.toString());
            sb.append("], ");
        }
        sb.append("]");
        return sb.toString();
    }
}

