/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.sccp.impl.router;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javolution.text.TextBuilder;
import javolution.util.FastMap;
import javolution.xml.XMLBinding;
import javolution.xml.XMLObjectReader;
import javolution.xml.XMLObjectWriter;
import javolution.xml.stream.XMLStreamException;
import org.apache.log4j.Logger;
import org.mobicents.protocols.ss7.sccp.LoadSharingAlgorithm;
import org.mobicents.protocols.ss7.sccp.LongMessageRule;
import org.mobicents.protocols.ss7.sccp.LongMessageRuleType;
import org.mobicents.protocols.ss7.sccp.Mtp3ServiceAccessPoint;
import org.mobicents.protocols.ss7.sccp.OriginationType;
import org.mobicents.protocols.ss7.sccp.Router;
import org.mobicents.protocols.ss7.sccp.Rule;
import org.mobicents.protocols.ss7.sccp.RuleType;
import org.mobicents.protocols.ss7.sccp.SccpStack;
import org.mobicents.protocols.ss7.sccp.impl.router.LongMessageRuleImpl;
import org.mobicents.protocols.ss7.sccp.impl.router.LongMessageRuleMap;
import org.mobicents.protocols.ss7.sccp.impl.router.Mtp3DestinationMap;
import org.mobicents.protocols.ss7.sccp.impl.router.Mtp3ServiceAccessPointImpl;
import org.mobicents.protocols.ss7.sccp.impl.router.Mtp3ServiceAccessPointMap;
import org.mobicents.protocols.ss7.sccp.impl.router.RuleComparator;
import org.mobicents.protocols.ss7.sccp.impl.router.RuleImpl;
import org.mobicents.protocols.ss7.sccp.impl.router.RuleMap;
import org.mobicents.protocols.ss7.sccp.impl.router.SccpAddressMap;
import org.mobicents.protocols.ss7.sccp.impl.router.SccpRouterXMLBinding;
import org.mobicents.protocols.ss7.sccp.parameter.GT0001;
import org.mobicents.protocols.ss7.sccp.parameter.GT0010;
import org.mobicents.protocols.ss7.sccp.parameter.GT0011;
import org.mobicents.protocols.ss7.sccp.parameter.GT0100;
import org.mobicents.protocols.ss7.sccp.parameter.NoGlobalTitle;
import org.mobicents.protocols.ss7.sccp.parameter.SccpAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RouterImpl
implements Router {
    private static final Logger logger = Logger.getLogger(RouterImpl.class);
    private static final String SCCP_ROUTER_PERSIST_DIR_KEY = "sccprouter.persist.dir";
    private static final String USER_DIR_KEY = "user.dir";
    private static final String PERSIST_FILE_NAME = "sccprouter2.xml";
    private static final String RULE = "rule";
    private static final String ROUTING_ADDRESS = "routingAddress";
    private static final String LONG_MESSAGE_RULE = "longMessageRule";
    private static final String MTP3_SERVICE_ACCESS_POINT = "sap";
    private final TextBuilder persistFile = TextBuilder.newInstance();
    private static final SccpRouterXMLBinding binding = new SccpRouterXMLBinding();
    private static final String TAB_INDENT = "\t";
    private static final String CLASS_ATTRIBUTE = "type";
    private String persistDir = null;
    private final RuleComparator ruleComparator = new RuleComparator();
    private RuleMap<Integer, Rule> rulesMap = new RuleMap();
    private SccpAddressMap<Integer, SccpAddress> routingAddresses = new SccpAddressMap();
    private LongMessageRuleMap<Integer, LongMessageRule> longMessageRules = new LongMessageRuleMap();
    private Mtp3ServiceAccessPointMap<Integer, Mtp3ServiceAccessPoint> saps = new Mtp3ServiceAccessPointMap();
    private final String name;
    private final SccpStack sccpStack;

    public RouterImpl(String name, SccpStack sccpStack) {
        this.name = name;
        this.sccpStack = sccpStack;
        binding.setAlias(RuleImpl.class, RULE);
        binding.setClassAttribute(CLASS_ATTRIBUTE);
        binding.setAlias(Mtp3DestinationMap.class, "mtp3DestinationMap");
        binding.setAlias(GT0001.class, "GT0001");
        binding.setAlias(GT0010.class, "GT0010");
        binding.setAlias(GT0011.class, "GT0011");
        binding.setAlias(GT0100.class, "GT0100");
        binding.setAlias(NoGlobalTitle.class, "NoGlobalTitle");
    }

    public String getName() {
        return this.name;
    }

    public String getPersistDir() {
        return this.persistDir;
    }

    public void setPersistDir(String persistDir) {
        this.persistDir = persistDir;
    }

    public void start() {
        this.persistFile.clear();
        if (this.persistDir != null) {
            this.persistFile.append(this.persistDir).append(File.separator).append(this.name).append("_").append(PERSIST_FILE_NAME);
        } else {
            this.persistFile.append(System.getProperty(SCCP_ROUTER_PERSIST_DIR_KEY, System.getProperty(USER_DIR_KEY))).append(File.separator).append(this.name).append("_").append(PERSIST_FILE_NAME);
        }
        logger.info((Object)String.format("SCCP Router configuration file path %s", this.persistFile.toString()));
        this.load();
        logger.info((Object)"Started SCCP Router");
    }

    public void stop() {
        this.store();
    }

    public Rule findRule(SccpAddress calledParty, boolean isMtpOriginated) {
        FastMap.Entry e = this.rulesMap.head();
        FastMap.Entry end = this.rulesMap.tail();
        while ((e = e.getNext()) != end) {
            Rule rule = (Rule)e.getValue();
            if (!rule.matches(calledParty, isMtpOriginated)) continue;
            return rule;
        }
        return null;
    }

    public LongMessageRule findLongMessageRule(int dpc) {
        FastMap.Entry e = this.longMessageRules.head();
        FastMap.Entry end = this.longMessageRules.tail();
        while ((e = e.getNext()) != end) {
            LongMessageRule rule = (LongMessageRule)e.getValue();
            if (!rule.matches(dpc)) continue;
            return rule;
        }
        return null;
    }

    public Mtp3ServiceAccessPoint findMtp3ServiceAccessPoint(int dpc, int sls) {
        FastMap.Entry e = this.saps.head();
        FastMap.Entry end = this.saps.tail();
        while ((e = e.getNext()) != end) {
            Mtp3ServiceAccessPoint sap = (Mtp3ServiceAccessPoint)e.getValue();
            if (!sap.matches(dpc, sls)) continue;
            return sap;
        }
        return null;
    }

    public Rule getRule(int id) {
        return (Rule)this.rulesMap.get(id);
    }

    public SccpAddress getRoutingAddress(int id) {
        return (SccpAddress)this.routingAddresses.get(id);
    }

    public LongMessageRule getLongMessageRule(int id) {
        return (LongMessageRule)this.longMessageRules.get(id);
    }

    public Mtp3ServiceAccessPoint getMtp3ServiceAccessPoint(int id) {
        return (Mtp3ServiceAccessPoint)this.saps.get(id);
    }

    public boolean spcIsLocal(int spc) {
        FastMap.Entry e = this.saps.head();
        FastMap.Entry end = this.saps.tail();
        while ((e = e.getNext()) != end) {
            Mtp3ServiceAccessPoint sap = (Mtp3ServiceAccessPoint)e.getValue();
            if (sap.getOpc() != spc) continue;
            return true;
        }
        return false;
    }

    public Map<Integer, Rule> getRules() {
        HashMap<Integer, Rule> rulesMapTmp = new HashMap<Integer, Rule>();
        rulesMapTmp.putAll((Map<Integer, Rule>)((Object)this.rulesMap));
        return rulesMapTmp;
    }

    public Map<Integer, SccpAddress> getRoutingAddresses() {
        HashMap<Integer, SccpAddress> routingAddressesTmp = new HashMap<Integer, SccpAddress>();
        routingAddressesTmp.putAll((Map<Integer, SccpAddress>)((Object)this.routingAddresses));
        return routingAddressesTmp;
    }

    public Map<Integer, LongMessageRule> getLongMessageRules() {
        HashMap<Integer, LongMessageRule> longMessageRulesTmp = new HashMap<Integer, LongMessageRule>();
        longMessageRulesTmp.putAll((Map<Integer, LongMessageRule>)((Object)this.longMessageRules));
        return longMessageRulesTmp;
    }

    public Map<Integer, Mtp3ServiceAccessPoint> getMtp3ServiceAccessPoints() {
        HashMap<Integer, Mtp3ServiceAccessPoint> sapsTmp = new HashMap<Integer, Mtp3ServiceAccessPoint>();
        sapsTmp.putAll((Map<Integer, Mtp3ServiceAccessPoint>)((Object)this.saps));
        return sapsTmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRule(int id, RuleType ruleType, LoadSharingAlgorithm algo, OriginationType originationType, SccpAddress pattern, String mask, int pAddressId, int sAddressId, Integer newCallingPartyAddressAddressId) throws Exception {
        int patternNumberOfSecs;
        Rule ruleTmp = this.getRule(id);
        if (ruleTmp != null) {
            throw new Exception("Rule already exist");
        }
        int maskumberOfSecs = mask.split("/").length - 1;
        if (maskumberOfSecs != (patternNumberOfSecs = pattern.getGlobalTitle().getDigits().split("/").length - 1)) {
            throw new Exception("Number of sections in mask doesn't match with number of sections in pattern GlobalTitle digits");
        }
        SccpAddress pAddress = this.getRoutingAddress(pAddressId);
        if (pAddress == null) {
            throw new Exception(String.format("No primary address defined for id=%d", pAddressId));
        }
        int primAddNumberOfSecs = pAddress.getGlobalTitle().getDigits().split("/").length - 1;
        if (maskumberOfSecs != primAddNumberOfSecs) {
            throw new Exception("Number of sections in mask doesn't match with number of sections in primary address GlobalTitle digits");
        }
        if (sAddressId != -1) {
            SccpAddress sAddress = this.getRoutingAddress(sAddressId);
            if (sAddress == null) {
                throw new Exception(String.format("No backup address defined for id=%d", sAddressId));
            }
            int secAddNumberOfSecs = sAddress.getGlobalTitle().getDigits().split("/").length - 1;
            if (maskumberOfSecs != secAddNumberOfSecs) {
                throw new Exception("Number of sections in mask doesn't match with number of sections in secondary address GlobalTitle digits");
            }
        }
        if (sAddressId == -1 && ruleType != RuleType.Solitary) {
            throw new Exception("If RuleType is not Solitary, specifying Secondar Address is mandatory");
        }
        RouterImpl routerImpl = this;
        synchronized (routerImpl) {
            RuleImpl rule = new RuleImpl(ruleType, algo, originationType, pattern, mask);
            rule.setPrimaryAddressId(pAddressId);
            rule.setSecondaryAddressId(sAddressId);
            rule.setNewCallingPartyAddressId(newCallingPartyAddressAddressId);
            rule.setRuleId(id);
            RuleImpl[] rulesArray = new RuleImpl[this.rulesMap.size() + 1];
            int count = 0;
            FastMap.Entry e = this.rulesMap.head();
            FastMap.Entry end = this.rulesMap.tail();
            while ((e = e.getNext()) != end) {
                Integer ruleId = (Integer)e.getKey();
                RuleImpl ruleTemp1 = (RuleImpl)e.getValue();
                ruleTemp1.setRuleId(ruleId);
                rulesArray[count++] = ruleTemp1;
            }
            rulesArray[count++] = rule;
            Arrays.sort(rulesArray, this.ruleComparator);
            RuleMap newRule = new RuleMap();
            for (int i = 0; i < rulesArray.length; ++i) {
                RuleImpl ruleTemp = rulesArray[i];
                newRule.put(ruleTemp.getRuleId(), ruleTemp);
            }
            this.rulesMap = newRule;
            this.store();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyRule(int id, RuleType ruleType, LoadSharingAlgorithm algo, OriginationType originationType, SccpAddress pattern, String mask, int pAddressId, int sAddressId, Integer newCallingPartyAddressAddressId) throws Exception {
        int patternNumberOfSecs;
        Rule ruleTmp = this.getRule(id);
        if (ruleTmp == null) {
            throw new Exception("Rule doesn't exist");
        }
        int maskumberOfSecs = mask.split("/").length - 1;
        if (maskumberOfSecs != (patternNumberOfSecs = pattern.getGlobalTitle().getDigits().split("/").length - 1)) {
            throw new Exception("Number of sections in mask doesn't match with number of sections in pattern GlobalTitle digits");
        }
        SccpAddress pAddress = this.getRoutingAddress(pAddressId);
        if (pAddress == null) {
            throw new Exception(String.format("No primary address defined for id=%d", pAddressId));
        }
        int primAddNumberOfSecs = pattern.getGlobalTitle().getDigits().split("/").length - 1;
        if (maskumberOfSecs != primAddNumberOfSecs) {
            throw new Exception("Number of sections in mask doesn't match with number of sections in primary address GlobalTitle digits");
        }
        if (sAddressId != -1) {
            SccpAddress sAddress = this.getRoutingAddress(sAddressId);
            if (sAddress == null) {
                throw new Exception(String.format("No backup address defined for id=%d", sAddressId));
            }
            int secAddNumberOfSecs = pattern.getGlobalTitle().getDigits().split("/").length - 1;
            if (maskumberOfSecs != secAddNumberOfSecs) {
                throw new Exception("Number of sections in mask doesn't match with number of sections in secondary address GlobalTitle digits");
            }
        }
        if (sAddressId == -1 && ruleType != RuleType.Solitary) {
            throw new Exception("If RuleType is not Solitary, specifying Secondar Address is mandatory");
        }
        RouterImpl routerImpl = this;
        synchronized (routerImpl) {
            RuleImpl rule = new RuleImpl(ruleType, algo, originationType, pattern, mask);
            rule.setPrimaryAddressId(pAddressId);
            rule.setSecondaryAddressId(sAddressId);
            rule.setNewCallingPartyAddressId(newCallingPartyAddressAddressId);
            rule.setRuleId(id);
            RuleImpl[] rulesArray = new RuleImpl[this.rulesMap.size() + 1];
            int count = 0;
            FastMap.Entry e = this.rulesMap.head();
            FastMap.Entry end = this.rulesMap.tail();
            while ((e = e.getNext()) != end) {
                Integer ruleId = (Integer)e.getKey();
                RuleImpl ruleTemp1 = (RuleImpl)e.getValue();
                ruleTemp1.setRuleId(ruleId);
                rulesArray[count++] = ruleTemp1;
            }
            rulesArray[count++] = rule;
            Arrays.sort(rulesArray, this.ruleComparator);
            RuleMap newRule = new RuleMap();
            for (int i = 0; i < rulesArray.length; ++i) {
                RuleImpl ruleTemp = rulesArray[i];
                newRule.put(ruleTemp.getRuleId(), ruleTemp);
            }
            this.rulesMap = newRule;
            this.store();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRule(int id) throws Exception {
        if (this.getRule(id) == null) {
            throw new Exception("Rule doesn't exist");
        }
        RouterImpl routerImpl = this;
        synchronized (routerImpl) {
            RuleMap newRule = new RuleMap();
            newRule.putAll((Map)((Object)this.rulesMap));
            newRule.remove(id);
            this.rulesMap = newRule;
            this.store();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRoutingAddress(int primAddressId, SccpAddress primaryAddress) throws Exception {
        if (this.getRoutingAddress(primAddressId) != null) {
            throw new Exception("Address already exist");
        }
        RouterImpl routerImpl = this;
        synchronized (routerImpl) {
            SccpAddressMap newPrimaryAddress = new SccpAddressMap();
            newPrimaryAddress.putAll((Map)((Object)this.routingAddresses));
            newPrimaryAddress.put(primAddressId, primaryAddress);
            this.routingAddresses = newPrimaryAddress;
            this.store();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyRoutingAddress(int primAddressId, SccpAddress primaryAddress) throws Exception {
        if (this.getRoutingAddress(primAddressId) == null) {
            throw new Exception("Address doesn't exist");
        }
        RouterImpl routerImpl = this;
        synchronized (routerImpl) {
            SccpAddressMap newPrimaryAddress = new SccpAddressMap();
            newPrimaryAddress.putAll((Map)((Object)this.routingAddresses));
            newPrimaryAddress.put(primAddressId, primaryAddress);
            this.routingAddresses = newPrimaryAddress;
            this.store();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRoutingAddress(int id) throws Exception {
        if (this.getRoutingAddress(id) == null) {
            throw new Exception("Address doesn't exist");
        }
        RouterImpl routerImpl = this;
        synchronized (routerImpl) {
            SccpAddressMap newPrimaryAddress = new SccpAddressMap();
            newPrimaryAddress.putAll((Map)((Object)this.routingAddresses));
            newPrimaryAddress.remove(id);
            this.routingAddresses = newPrimaryAddress;
            this.store();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLongMessageRule(int id, int firstSpc, int lastSpc, LongMessageRuleType ruleType) throws Exception {
        if (this.getLongMessageRule(id) != null) {
            throw new Exception("Long message rule already exists");
        }
        LongMessageRuleImpl longMessageRule = new LongMessageRuleImpl(firstSpc, lastSpc, ruleType);
        RouterImpl routerImpl = this;
        synchronized (routerImpl) {
            LongMessageRuleMap newLongMessageRule = new LongMessageRuleMap();
            newLongMessageRule.putAll((Map)((Object)this.longMessageRules));
            newLongMessageRule.put(id, longMessageRule);
            this.longMessageRules = newLongMessageRule;
            this.store();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyLongMessageRule(int id, int firstSpc, int lastSpc, LongMessageRuleType ruleType) throws Exception {
        if (this.getLongMessageRule(id) == null) {
            throw new Exception("Long message rule doesn't exist");
        }
        LongMessageRuleImpl longMessageRule = new LongMessageRuleImpl(firstSpc, lastSpc, ruleType);
        RouterImpl routerImpl = this;
        synchronized (routerImpl) {
            LongMessageRuleMap newLongMessageRule = new LongMessageRuleMap();
            newLongMessageRule.putAll((Map)((Object)this.longMessageRules));
            newLongMessageRule.put(id, longMessageRule);
            this.longMessageRules = newLongMessageRule;
            this.store();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLongMessageRule(int id) throws Exception {
        if (this.getLongMessageRule(id) == null) {
            throw new Exception("Long message rule doesn't exist");
        }
        RouterImpl routerImpl = this;
        synchronized (routerImpl) {
            LongMessageRuleMap newLongMessageRule = new LongMessageRuleMap();
            newLongMessageRule.putAll((Map)((Object)this.longMessageRules));
            newLongMessageRule.remove(id);
            this.longMessageRules = newLongMessageRule;
            this.store();
        }
    }

    public void addMtp3Destination(int sapId, int destId, int firstDpc, int lastDpc, int firstSls, int lastSls, int slsMask) throws Exception {
        Mtp3ServiceAccessPoint sap = this.getMtp3ServiceAccessPoint(sapId);
        if (sap == null) {
            throw new Exception("Service access point doesn't exist");
        }
        sap.addMtp3Destination(destId, firstDpc, lastDpc, firstSls, lastSls, slsMask);
        this.store();
    }

    public void modifyMtp3Destination(int sapId, int destId, int firstDpc, int lastDpc, int firstSls, int lastSls, int slsMask) throws Exception {
        Mtp3ServiceAccessPoint sap = this.getMtp3ServiceAccessPoint(sapId);
        if (sap == null) {
            throw new Exception("Service access point doesn't exist");
        }
        sap.modifyMtp3Destination(destId, firstDpc, lastDpc, firstSls, lastSls, slsMask);
        this.store();
    }

    public void removeMtp3Destination(int sapId, int destId) throws Exception {
        Mtp3ServiceAccessPoint sap = this.getMtp3ServiceAccessPoint(sapId);
        if (sap == null) {
            throw new Exception("Service access point doesn't exist");
        }
        sap.removeMtp3Destination(destId);
        this.store();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMtp3ServiceAccessPoint(int id, int mtp3Id, int opc, int ni) throws Exception {
        if (this.getMtp3ServiceAccessPoint(id) != null) {
            throw new Exception("Service access point already exists");
        }
        if (this.sccpStack.getMtp3UserPart(mtp3Id) == null) {
            throw new Exception("Mtp3UserPart doesn't exist");
        }
        Mtp3ServiceAccessPointImpl sap = new Mtp3ServiceAccessPointImpl(mtp3Id, opc, ni);
        RouterImpl routerImpl = this;
        synchronized (routerImpl) {
            Mtp3ServiceAccessPointMap newSap = new Mtp3ServiceAccessPointMap();
            newSap.putAll((Map)((Object)this.saps));
            newSap.put(id, sap);
            this.saps = newSap;
            this.store();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyMtp3ServiceAccessPoint(int id, int mtp3Id, int opc, int ni) throws Exception {
        if (this.getMtp3ServiceAccessPoint(id) == null) {
            throw new Exception("Service access point doesn't exist");
        }
        if (this.sccpStack.getMtp3UserPart(mtp3Id) == null) {
            throw new Exception("Mtp3UserPart doesn't exist");
        }
        Mtp3ServiceAccessPointImpl sap = new Mtp3ServiceAccessPointImpl(mtp3Id, opc, ni);
        RouterImpl routerImpl = this;
        synchronized (routerImpl) {
            Mtp3ServiceAccessPointMap newSap = new Mtp3ServiceAccessPointMap();
            newSap.putAll((Map)((Object)this.saps));
            newSap.put(id, sap);
            this.saps = newSap;
            this.store();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMtp3ServiceAccessPoint(int id) throws Exception {
        if (this.getMtp3ServiceAccessPoint(id) == null) {
            throw new Exception("Service access point doesn't exist");
        }
        RouterImpl routerImpl = this;
        synchronized (routerImpl) {
            Mtp3ServiceAccessPointMap newSap = new Mtp3ServiceAccessPointMap();
            newSap.putAll((Map)((Object)this.saps));
            newSap.remove(id);
            this.saps = newSap;
            this.store();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllResourses() {
        RouterImpl routerImpl = this;
        synchronized (routerImpl) {
            if (this.rulesMap.size() == 0 && this.routingAddresses.size() == 0 && this.longMessageRules.size() == 0 && this.saps.size() == 0) {
                return;
            }
            this.rulesMap = new RuleMap();
            this.routingAddresses = new SccpAddressMap();
            this.longMessageRules = new LongMessageRuleMap();
            this.saps = new Mtp3ServiceAccessPointMap();
            this.store();
        }
    }

    public void store() {
        try {
            XMLObjectWriter writer = XMLObjectWriter.newInstance((OutputStream)new FileOutputStream(this.persistFile.toString()));
            writer.setBinding((XMLBinding)binding);
            writer.setIndentation(TAB_INDENT);
            writer.write(this.rulesMap, RULE, RuleMap.class);
            writer.write(this.routingAddresses, ROUTING_ADDRESS, SccpAddressMap.class);
            writer.write(this.longMessageRules, LONG_MESSAGE_RULE, LongMessageRuleMap.class);
            writer.write(this.saps, MTP3_SERVICE_ACCESS_POINT, Mtp3ServiceAccessPointMap.class);
            writer.close();
        }
        catch (Exception e) {
            logger.error((Object)"Error while persisting the Rule state in file", (Throwable)e);
        }
    }

    private void load() {
        try {
            File f = new File(this.persistFile.toString());
            if (f.exists()) {
                this.loadVer3(this.persistFile.toString());
            } else {
                String s1 = this.persistFile.toString().replace("2.xml", ".xml");
                f = new File(s1);
                if (f.exists() && !this.loadVer1(s1)) {
                    this.loadVer2(s1);
                }
                this.store();
                f.delete();
            }
        }
        catch (XMLStreamException ex) {
            logger.error((Object)String.format("Failed to load the SS7 configuration file. \n%s", ex.getMessage()));
        }
        catch (FileNotFoundException e) {
            logger.warn((Object)String.format("Failed to load the SS7 configuration file. \n%s", e.getMessage()));
        }
        catch (IOException e) {
            logger.error((Object)String.format("Failed to load the SS7 configuration file. \n%s", e.getMessage()));
        }
    }

    private void moveBackupToRoutingAddress(SccpAddressMap<Integer, SccpAddress> backupAddresses) {
        FastMap lstChange = new FastMap();
        for (Integer bId : backupAddresses.keySet()) {
            SccpAddress addr = (SccpAddress)backupAddresses.get(bId);
            int i1 = bId + 100;
            while (this.routingAddresses.get(i1) != null) {
                ++i1;
            }
            this.routingAddresses.putEntry(i1, addr);
            lstChange.putEntry((Object)bId, (Object)i1);
        }
        for (Rule rule : this.rulesMap.values()) {
            Integer newVal = (Integer)lstChange.get((Object)rule.getSecondaryAddressId());
            if (newVal == null) continue;
            ((RuleImpl)rule).setSecondaryAddressId(newVal);
        }
    }

    private boolean loadVer1(String fn) throws XMLStreamException, IOException {
        String s1;
        BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(fn)));
        StringBuilder sb = new StringBuilder();
        while ((s1 = br.readLine()) != null) {
            sb.append(s1);
            sb.append("\n");
        }
        br.close();
        String s2 = sb.toString();
        s2 = s2.replace("type=\"org.mobicents.protocols.ss7.sccp.parameter.NoGlobalTitle\"", "type=\"NoGlobalTitle\"");
        s2 = s2.replace("type=\"rule\"", "");
        s2 = s2.replace("pattern type=\"org.mobicents.protocols.ss7.sccp.parameter.SccpAddress\"", "patternSccpAddress");
        s2 = s2.replace("ai type=\"org.mobicents.protocols.ss7.indicator.AddressIndicator\" ai=", "ai value=");
        s2 = s2.replace("gt type=\"org.mobicents.protocols.ss7.sccp.parameter.", "gt type=\"");
        s2 = s2.replace("Key type=\"java.lang.Integer\"", "id");
        s2 = s2.replace("Value", "value");
        s2 = s2.replace("/pattern", "/patternSccpAddress");
        s2 = s2.replace("value type=\"org.mobicents.protocols.ss7.sccp.parameter.SccpAddress\"", "sccpAddress");
        s2 = s2.replace("</value>\r\n</primaryAddress>", "</sccpAddress>\r\n</primaryAddress>");
        s2 = s2.replace("</value>\n</primaryAddress>", "</sccpAddress>\n</primaryAddress>");
        s2 = s2.replace("</value>\r\n</backupAddress>", "</sccpAddress>\r\n</backupAddress>");
        s2 = s2.replace("</value>\n</backupAddress>", "</sccpAddress>\n</backupAddress>");
        s2 = s2.replace("type=\"org.mobicents.protocols.ss7.sccp.parameter.", "type=\"");
        s2 = s2.replace("type=\"org.mobicents.protocols.ss7.sccp.impl.router.Mtp3ServiceAccessPoint\"", "");
        s2 = s2.replace("javolution.util.FastMap", "mtp3DestinationMap");
        s2 = s2.replace("type=\"org.mobicents.protocols.ss7.sccp.impl.router.Mtp3Destination\"", "");
        StringReader sr = new StringReader(s2);
        XMLObjectReader reader = XMLObjectReader.newInstance((Reader)sr);
        reader.setBinding((XMLBinding)binding);
        XMLBinding binding2 = new XMLBinding();
        binding2.setClassAttribute(CLASS_ATTRIBUTE);
        String BACKUP_ADDRESS_V2 = "backupAddress";
        String ROUTING_ADDRESS_V2 = "primaryAddress";
        try {
            this.rulesMap = (RuleMap)((Object)reader.read(RULE, RuleMap.class));
        }
        catch (XMLStreamException e) {
            return false;
        }
        this.routingAddresses = (SccpAddressMap)((Object)reader.read(ROUTING_ADDRESS_V2, SccpAddressMap.class));
        SccpAddressMap backupAddresses = (SccpAddressMap)((Object)reader.read(BACKUP_ADDRESS_V2, SccpAddressMap.class));
        this.longMessageRules = (LongMessageRuleMap)((Object)reader.read(LONG_MESSAGE_RULE, LongMessageRuleMap.class));
        this.saps = (Mtp3ServiceAccessPointMap)((Object)reader.read(MTP3_SERVICE_ACCESS_POINT, Mtp3ServiceAccessPointMap.class));
        reader.close();
        this.moveBackupToRoutingAddress(backupAddresses);
        return true;
    }

    private void loadVer2(String fn) throws XMLStreamException, IOException {
        String s1;
        BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(fn)));
        StringBuilder sb = new StringBuilder();
        while ((s1 = br.readLine()) != null) {
            sb.append(s1);
            sb.append("\n");
        }
        br.close();
        String s2 = sb.toString();
        s2 = s2.replace("type=\"org.mobicents.protocols.ss7.sccp.parameter.NoGlobalTitle\"", "type=\"NoGlobalTitle\"");
        StringReader sr = new StringReader(s2);
        XMLObjectReader reader = XMLObjectReader.newInstance((Reader)sr);
        String ROUTING_ADDRESS_V2 = "primaryAddress";
        String BACKUP_ADDRESS_V2 = "backupAddress";
        reader.setBinding((XMLBinding)binding);
        this.rulesMap = (RuleMap)((Object)reader.read(RULE, RuleMap.class));
        this.routingAddresses = (SccpAddressMap)((Object)reader.read(ROUTING_ADDRESS_V2, SccpAddressMap.class));
        SccpAddressMap backupAddresses = (SccpAddressMap)((Object)reader.read(BACKUP_ADDRESS_V2, SccpAddressMap.class));
        this.longMessageRules = (LongMessageRuleMap)((Object)reader.read(LONG_MESSAGE_RULE, LongMessageRuleMap.class));
        this.saps = (Mtp3ServiceAccessPointMap)((Object)reader.read(MTP3_SERVICE_ACCESS_POINT, Mtp3ServiceAccessPointMap.class));
        reader.close();
        this.moveBackupToRoutingAddress(backupAddresses);
    }

    private void loadVer3(String fn) throws XMLStreamException, FileNotFoundException {
        XMLObjectReader reader = XMLObjectReader.newInstance((InputStream)new FileInputStream(fn));
        reader.setBinding((XMLBinding)binding);
        this.rulesMap = (RuleMap)((Object)reader.read(RULE, RuleMap.class));
        this.routingAddresses = (SccpAddressMap)((Object)reader.read(ROUTING_ADDRESS, SccpAddressMap.class));
        this.longMessageRules = (LongMessageRuleMap)((Object)reader.read(LONG_MESSAGE_RULE, LongMessageRuleMap.class));
        this.saps = (Mtp3ServiceAccessPointMap)((Object)reader.read(MTP3_SERVICE_ACCESS_POINT, Mtp3ServiceAccessPointMap.class));
        reader.close();
    }
}

