/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import javax.slee.facilities.Tracer;
import javax.slee.transaction.SleeTransactionManager;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import net.java.slee.resource.diameter.base.DiameterActivity;
import org.jdiameter.api.Stack;
import org.mobicents.slee.resource.cluster.FaultTolerantResourceAdaptorContext;
import org.mobicents.slee.resource.cluster.FaultTolerantTimer;
import org.mobicents.slee.resource.cluster.FaultTolerantTimerTask;
import org.mobicents.slee.resource.cluster.FaultTolerantTimerTaskData;
import org.mobicents.slee.resource.cluster.FaultTolerantTimerTaskFactory;
import org.mobicents.slee.resource.cluster.ReplicatedData;
import org.mobicents.slee.resource.diameter.DiameterActivityManagement;
import org.mobicents.slee.resource.diameter.DiameterFaultTolerantTimerTaskData;
import org.mobicents.slee.resource.diameter.base.DiameterActivityHandle;
import org.mobicents.slee.resource.diameter.base.DiameterActivityImpl;

public abstract class AbstractClusteredDiameterActivityManagement
implements DiameterActivityManagement {
    private static final int TIMER_THREADS = 4;
    protected Tracer tracer;
    protected Stack diameterStack;
    protected SleeTransactionManager sleeTxManager;
    protected ReplicatedData<String, DiameterActivity> replicatedData;
    protected FaultTolerantTimer faultTolerantTimer;
    protected long delay;

    public AbstractClusteredDiameterActivityManagement(FaultTolerantResourceAdaptorContext ftRAContext, long delay, Tracer tracer, Stack diameterStack, SleeTransactionManager sleeTxManager, ReplicatedData<String, DiameterActivity> replicatedData) {
        this.tracer = tracer;
        this.diameterStack = diameterStack;
        this.sleeTxManager = sleeTxManager;
        this.replicatedData = replicatedData;
        this.faultTolerantTimer = ftRAContext.getFaultTolerantTimer();
        this.faultTolerantTimer.configure((FaultTolerantTimerTaskFactory)new DiameterTimerTaskFactory(), 4);
        this.delay = delay;
    }

    @Override
    public DiameterActivity get(DiameterActivityHandle handle) {
        DiameterActivityImpl activity = (DiameterActivityImpl)((Object)this.replicatedData.get((Serializable)((Object)handle.getId())));
        if (activity != null && activity.getSessionListener() == null) {
            this.performBeforeReturn(activity);
        }
        return activity;
    }

    @Override
    public void put(DiameterActivityHandle handle, DiameterActivity activity) {
        this.replicatedData.put((Serializable)((Object)handle.getId()), (Serializable)activity);
    }

    @Override
    public void update(DiameterActivityHandle handle, DiameterActivity activity) {
        this.replicatedData.put((Serializable)((Object)handle.getId()), (Serializable)activity);
    }

    @Override
    public DiameterActivity remove(DiameterActivityHandle handle) {
        DiameterActivity ac = (DiameterActivity)this.replicatedData.get((Serializable)((Object)handle.getId()));
        Transaction tx = null;
        try {
            tx = this.sleeTxManager.suspend();
        }
        catch (SystemException e) {
            // empty catch block
        }
        this.replicatedData.remove((Serializable)((Object)handle.getId()));
        if (tx != null) {
            try {
                this.sleeTxManager.resume(tx);
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        return ac;
    }

    @Override
    public boolean containsKey(DiameterActivityHandle activityHandle) {
        return this.replicatedData.contains((Serializable)((Object)activityHandle.getId()));
    }

    @Override
    public void startActivityRemoveTimer(DiameterActivityHandle handle) {
        DiameterActivity da = this.get(handle);
        if (da != null) {
            DiameterFaultTolerantTimerTaskData data = new DiameterFaultTolerantTimerTaskData(handle.getId());
            ActivityRemovalFaultTolerantTimerTask task = new ActivityRemovalFaultTolerantTimerTask(data);
            this.faultTolerantTimer.schedule((FaultTolerantTimerTask)task, this.delay, TimeUnit.MILLISECONDS);
            if (this.tracer.isFineEnabled()) {
                this.tracer.fine("Scheduled Activity Remove Timer for ACH ID '" + handle.getId() + "' with delay of " + this.delay + "ms");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopActivityRemoveTimer(DiameterActivityHandle handle) {
        DiameterActivity da = this.get(handle);
        if (da != null) {
            DiameterActivity diameterActivity = da;
            synchronized (diameterActivity) {
                this.faultTolerantTimer.cancel((Serializable)((Object)handle.getId()));
                if (this.tracer.isFineEnabled()) {
                    this.tracer.fine("Canceled Activity Remove Timer for ACH ID '" + handle.getId() + "'");
                }
            }
        }
    }

    protected abstract void performBeforeReturn(DiameterActivityImpl var1);

    private final class DiameterTimerTaskFactory
    implements FaultTolerantTimerTaskFactory {
        private DiameterTimerTaskFactory() {
        }

        public FaultTolerantTimerTask getTask(FaultTolerantTimerTaskData data) {
            return new ActivityRemovalFaultTolerantTimerTask(data);
        }
    }

    private final class ActivityRemovalFaultTolerantTimerTask
    implements FaultTolerantTimerTask {
        private final FaultTolerantTimerTaskData taskData;

        public ActivityRemovalFaultTolerantTimerTask(FaultTolerantTimerTaskData data) {
            this.taskData = data;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block6: {
                try {
                    DiameterActivityImpl da = (DiameterActivityImpl)AbstractClusteredDiameterActivityManagement.this.get(new DiameterActivityHandle((String)((Object)this.getTaskData().getTaskID())));
                    if (da == null) break block6;
                    DiameterActivityImpl diameterActivityImpl = da;
                    synchronized (diameterActivityImpl) {
                        if (da.isTerminateAfterProcessing()) {
                            da.setTerminateAfterProcessing(false);
                            da.endActivity();
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        public FaultTolerantTimerTaskData getTaskData() {
            return this.taskData;
        }
    }
}

