/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import javax.slee.resource.ResourceAdaptorContext;
import net.java.slee.resource.diameter.base.DiameterActivity;
import org.mobicents.slee.resource.diameter.DiameterActivityManagement;
import org.mobicents.slee.resource.diameter.base.DiameterActivityHandle;
import org.mobicents.slee.resource.diameter.base.DiameterActivityImpl;

public class LocalDiameterActivityManagement
implements DiameterActivityManagement {
    private ConcurrentHashMap<DiameterActivityHandle, DiameterActivity> activities = new ConcurrentHashMap();
    private Timer timer;
    private long delay;
    private ConcurrentHashMap<DiameterActivityHandle, TimerTask> removeMap = new ConcurrentHashMap();

    public LocalDiameterActivityManagement(ResourceAdaptorContext raCtx, long delay) {
        this.timer = raCtx.getTimer();
        this.delay = delay;
    }

    @Override
    public DiameterActivity get(DiameterActivityHandle handle) {
        return this.activities.get(handle);
    }

    @Override
    public void put(DiameterActivityHandle handle, DiameterActivity activity) {
        DiameterActivity existingActivity = this.activities.putIfAbsent(handle, activity);
        if (existingActivity != null) {
            throw new IllegalArgumentException("There is already activity for '" + handle + "': " + existingActivity);
        }
    }

    @Override
    public DiameterActivity remove(DiameterActivityHandle handle) {
        return this.activities.remove(handle);
    }

    @Override
    public boolean containsKey(DiameterActivityHandle activityHandle) {
        return this.activities.containsKey(activityHandle);
    }

    @Override
    public void update(DiameterActivityHandle handle, DiameterActivity activity) {
    }

    @Override
    public void startActivityRemoveTimer(DiameterActivityHandle handle) {
        if (this.activities.contains(handle)) {
            ActivityRemoveTimerTask task = new ActivityRemoveTimerTask(handle);
            this.removeMap.put(handle, task);
            this.timer.schedule((TimerTask)new ActivityRemoveTimerTask(handle), this.delay);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopActivityRemoveTimer(DiameterActivityHandle handle) {
        DiameterActivity da = this.activities.get(handle);
        if (da != null) {
            DiameterActivity diameterActivity = da;
            synchronized (diameterActivity) {
                TimerTask tt = this.removeMap.remove(handle);
                if (tt != null) {
                    tt.cancel();
                }
            }
        }
    }

    private class ActivityRemoveTimerTask
    extends TimerTask {
        private DiameterActivityHandle handle;

        public ActivityRemoveTimerTask(DiameterActivityHandle handle) {
            this.handle = handle;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block9: {
                try {
                    DiameterActivityImpl da = (DiameterActivityImpl)LocalDiameterActivityManagement.this.get(this.handle);
                    if (da == null) break block9;
                    DiameterActivityImpl diameterActivityImpl = da;
                    synchronized (diameterActivityImpl) {
                        if (da.isTerminateAfterProcessing()) {
                            da.setTerminateAfterProcessing(false);
                            da.endActivity();
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    LocalDiameterActivityManagement.this.removeMap.remove(this.handle);
                }
            }
        }
    }
}

