/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.base;

import java.io.IOException;
import net.java.slee.resource.diameter.base.AccountingClientSessionActivity;
import net.java.slee.resource.diameter.base.AccountingSessionState;
import net.java.slee.resource.diameter.base.DiameterAvpFactory;
import net.java.slee.resource.diameter.base.DiameterMessageFactory;
import net.java.slee.resource.diameter.base.events.AccountingRequest;
import net.java.slee.resource.diameter.base.events.avp.AccountingRecordType;
import net.java.slee.resource.diameter.base.events.avp.DiameterIdentity;
import org.jdiameter.api.Answer;
import org.jdiameter.api.EventListener;
import org.jdiameter.api.Request;
import org.jdiameter.api.Session;
import org.jdiameter.api.acc.ClientAccSession;
import org.jdiameter.api.acc.events.AccountRequest;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.api.app.StateChangeListener;
import org.jdiameter.api.validation.AvpNotAllowedException;
import org.jdiameter.common.api.app.acc.ClientAccSessionState;
import org.jdiameter.common.impl.app.acc.AccountRequestImpl;
import org.mobicents.slee.resource.diameter.base.AccountingSessionActivityImpl;
import org.mobicents.slee.resource.diameter.base.events.DiameterMessageImpl;

public class AccountingClientSessionActivityImpl
extends AccountingSessionActivityImpl
implements AccountingClientSessionActivity {
    private static final long serialVersionUID = -4377919257333940587L;
    protected transient ClientAccSession clientSession = null;

    public AccountingClientSessionActivityImpl(DiameterMessageFactory messageFactory, DiameterAvpFactory avpFactory, ClientAccSession clientSession, DiameterIdentity destinationHost, DiameterIdentity destinationRealm) {
        super(messageFactory, avpFactory, null, (EventListener<Request, Answer>)((EventListener)clientSession), destinationHost, destinationRealm);
        this.setSession(clientSession);
        super.setCurrentWorkingSession((Session)this.clientSession.getSessions().get(0));
    }

    public AccountingRequest createAccountingRequest(AccountingRecordType accountingRecordType) {
        AccountingRequest acr = this.messageFactory.createAccountingRequest();
        acr.setAcctApplicationId(3L);
        acr.setAccountingRecordType(accountingRecordType);
        return acr;
    }

    public void sendAccountRequest(AccountingRequest request) throws IOException {
        DiameterMessageImpl msg = (DiameterMessageImpl)request;
        try {
            this.clientSession.sendAccountRequest((AccountRequest)new AccountRequestImpl((Request)msg.getGenericData()));
        }
        catch (AvpNotAllowedException e) {
            throw new net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException("Message validation failed.", (Throwable)e, e.getAvpCode(), e.getVendorId());
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Failed to send message, due to: ", (Throwable)e);
            }
            throw new IOException("Failed to send message, due to: " + e);
        }
    }

    public void stateChanged(AppSession source, Enum oldState, Enum newState) {
        this.stateChanged(oldState, newState);
    }

    public void stateChanged(Enum oldState, Enum newState) {
        ClientAccSessionState state = (ClientAccSessionState)newState;
        switch (state) {
            case IDLE: {
                if (oldState == state) break;
                this.setTerminateAfterProcessing(true);
                this.baseListener.startActivityRemoveTimer(this.getActivityHandle());
                break;
            }
            case OPEN: {
                break;
            }
            case PENDING_EVENT: {
                break;
            }
            case PENDING_START: {
                break;
            }
            case PENDING_INTERIM: {
                break;
            }
            case PENDING_CLOSE: {
                break;
            }
        }
    }

    public ClientAccSession getSession() {
        return this.clientSession;
    }

    public AccountingSessionState getAccountingSessionState() {
        ClientAccSessionState state = (ClientAccSessionState)this.clientSession.getState(ClientAccSessionState.class);
        switch (state) {
            case IDLE: {
                return AccountingSessionState.Idle;
            }
            case OPEN: {
                return AccountingSessionState.Open;
            }
            case PENDING_EVENT: {
                return AccountingSessionState.PendingE;
            }
            case PENDING_START: {
                return AccountingSessionState.PendingS;
            }
            case PENDING_INTERIM: {
                return AccountingSessionState.PendingI;
            }
            case PENDING_CLOSE: {
                return AccountingSessionState.PendingC;
            }
            case PENDING_BUFFERED: {
                return AccountingSessionState.PendingB;
            }
        }
        logger.error((Object)("Unexpected state in Accounting Client FSM: " + state));
        return null;
    }

    public void setSession(ClientAccSession clientSession) {
        this.clientSession = clientSession;
        this.clientSession.addStateChangeNotification((StateChangeListener)this);
        this.eventListener = (EventListener)clientSession;
    }

    @Override
    public void endActivity() {
        this.clientSession.release();
        super.endActivity();
    }
}

