/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.base;

import java.io.IOException;
import java.util.ArrayList;
import net.java.slee.resource.diameter.base.AccountingServerSessionActivity;
import net.java.slee.resource.diameter.base.AccountingSessionState;
import net.java.slee.resource.diameter.base.DiameterAvpFactory;
import net.java.slee.resource.diameter.base.DiameterMessageFactory;
import net.java.slee.resource.diameter.base.events.AccountingAnswer;
import net.java.slee.resource.diameter.base.events.AccountingRequest;
import net.java.slee.resource.diameter.base.events.avp.AccountingRecordType;
import net.java.slee.resource.diameter.base.events.avp.DiameterAvp;
import net.java.slee.resource.diameter.base.events.avp.DiameterIdentity;
import org.jdiameter.api.Answer;
import org.jdiameter.api.EventListener;
import org.jdiameter.api.Message;
import org.jdiameter.api.Request;
import org.jdiameter.api.Session;
import org.jdiameter.api.Stack;
import org.jdiameter.api.acc.ServerAccSession;
import org.jdiameter.api.acc.events.AccountAnswer;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.api.app.StateChangeListener;
import org.jdiameter.api.validation.AvpNotAllowedException;
import org.jdiameter.common.api.app.acc.ServerAccSessionState;
import org.jdiameter.common.impl.app.acc.AccountAnswerImpl;
import org.mobicents.slee.resource.diameter.base.AccountingSessionActivityImpl;
import org.mobicents.slee.resource.diameter.base.events.AccountingAnswerImpl;
import org.mobicents.slee.resource.diameter.base.events.DiameterMessageImpl;

public class AccountingServerSessionActivityImpl
extends AccountingSessionActivityImpl
implements AccountingServerSessionActivity {
    private static final long serialVersionUID = 1L;
    protected transient ServerAccSession serverSession = null;
    protected String originHost = "aaa://127.0.0.1:3868";
    protected String originRealm = "mobicents.org";

    public AccountingServerSessionActivityImpl(DiameterMessageFactory messageFactory, DiameterAvpFactory avpFactory, ServerAccSession serverSession, DiameterIdentity destinationHost, DiameterIdentity destinationRealm, Stack stack) {
        super(messageFactory, avpFactory, null, (EventListener<Request, Answer>)((EventListener)serverSession), destinationHost, destinationRealm);
        this.originHost = stack.getMetaData().getLocalPeer().getUri().toString();
        this.originRealm = stack.getMetaData().getLocalPeer().getRealmName();
        this.setSession(serverSession);
        super.setCurrentWorkingSession((Session)this.serverSession.getSessions().get(0));
    }

    public AccountingAnswer createAccountingAnswer(AccountingRequest request) {
        try {
            DiameterMessageImpl implRequest = (DiameterMessageImpl)request;
            ArrayList<DiameterAvp> copyAvps = new ArrayList<DiameterAvp>();
            copyAvps.add(this.avpFactory.createAvp(263, ((Session)this.serverSession.getSessions().get(0)).getSessionId()));
            copyAvps.add(this.avpFactory.createAvp(264, this.originHost.getBytes()));
            copyAvps.add(this.avpFactory.createAvp(296, this.originRealm.getBytes()));
            for (DiameterAvp avp : request.getAvps()) {
                if (avp.getCode() != 485 && avp.getCode() != 480 && avp.getCode() != 259 && avp.getCode() != 260) continue;
                copyAvps.add((DiameterAvp)avp.clone());
            }
            DiameterMessageImpl answer = (DiameterMessageImpl)this.messageFactory.createMessage(implRequest.getHeader(), copyAvps.toArray(new DiameterAvp[copyAvps.size()]));
            Message rawAnswer = answer.getGenericData();
            rawAnswer.setRequest(false);
            rawAnswer.setReTransmitted(false);
            return new AccountingAnswerImpl(rawAnswer);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            return null;
        }
    }

    public AccountingAnswer createAccountAnswer(AccountingRequest request, int resultCode) {
        AccountingAnswer answer = this.createAccountingAnswer(request);
        answer.setResultCode((long)resultCode);
        return answer;
    }

    public void sendAccountingAnswer(AccountingAnswer answer) throws IOException {
        try {
            AccountingAnswerImpl aca = (AccountingAnswerImpl)answer;
            this.serverSession.sendAccountAnswer((AccountAnswer)new AccountAnswerImpl((Answer)aca.getGenericData()));
            if (this.serverSession.isStateless()) {
                this.endActivity();
            } else if (aca.getAccountingRecordType() == AccountingRecordType.STOP_RECORD) {
                this.endActivity();
            }
        }
        catch (AvpNotAllowedException e) {
            throw new net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException("Message validation failed.", (Throwable)e, e.getAvpCode(), e.getVendorId());
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Failed to send message, due to: ", (Throwable)e);
            }
            throw new IOException("Failed to send message, due to: " + e.getMessage());
        }
    }

    public ServerAccSession getSession() {
        return this.serverSession;
    }

    public void stateChanged(AppSession source, Enum oldState, Enum newState) {
        this.stateChanged(oldState, newState);
    }

    public void stateChanged(Enum oldState, Enum newState) {
        if (newState == ServerAccSessionState.IDLE) {
            this.setTerminateAfterProcessing(true);
            this.baseListener.startActivityRemoveTimer(this.getActivityHandle());
        }
    }

    public AccountingSessionState getAccountingSessionState() {
        ServerAccSessionState state = (ServerAccSessionState)this.serverSession.getState(ServerAccSessionState.class);
        switch (state) {
            case IDLE: {
                return AccountingSessionState.Idle;
            }
            case OPEN: {
                return AccountingSessionState.Open;
            }
        }
        logger.error((Object)("Unexpected state in Accounting Server FSM: " + state));
        return null;
    }

    public AccountingAnswer createAccountingAnswer() {
        throw new UnsupportedOperationException();
    }

    public void setSession(ServerAccSession appSession) {
        this.serverSession = appSession;
        this.serverSession.addStateChangeNotification((StateChangeListener)this);
        this.eventListener = (EventListener)appSession;
    }

    public String toString() {
        return super.toString() + "['" + this.isTerminateAfterProcessing() + "']-" + this.serverSession + "-" + this.eventListener + "-" + this.session + "-" + this.baseListener;
    }

    @Override
    public void endActivity() {
        this.serverSession.release();
        super.endActivity();
    }
}

