/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.base;

import java.io.IOException;
import net.java.slee.resource.diameter.base.AuthClientSessionActivity;
import net.java.slee.resource.diameter.base.AuthSessionState;
import net.java.slee.resource.diameter.base.DiameterAvpFactory;
import net.java.slee.resource.diameter.base.DiameterMessageFactory;
import net.java.slee.resource.diameter.base.events.AbortSessionRequest;
import net.java.slee.resource.diameter.base.events.ReAuthRequest;
import net.java.slee.resource.diameter.base.events.SessionTerminationRequest;
import net.java.slee.resource.diameter.base.events.avp.DiameterIdentity;
import net.java.slee.resource.diameter.base.events.avp.TerminationCauseType;
import org.jdiameter.api.Answer;
import org.jdiameter.api.EventListener;
import org.jdiameter.api.Request;
import org.jdiameter.api.Session;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.api.app.StateChangeListener;
import org.jdiameter.api.auth.ClientAuthSession;
import org.jdiameter.api.auth.events.AbortSessionAnswer;
import org.jdiameter.api.auth.events.ReAuthAnswer;
import org.jdiameter.api.auth.events.SessionTermRequest;
import org.jdiameter.api.validation.AvpNotAllowedException;
import org.jdiameter.common.api.app.auth.ClientAuthSessionState;
import org.jdiameter.common.impl.app.auth.AbortSessionAnswerImpl;
import org.jdiameter.common.impl.app.auth.ReAuthAnswerImpl;
import org.jdiameter.common.impl.app.auth.SessionTermRequestImpl;
import org.mobicents.slee.resource.diameter.base.AuthSessionActivityImpl;
import org.mobicents.slee.resource.diameter.base.events.DiameterMessageImpl;

public class AuthClientSessionActivityImpl
extends AuthSessionActivityImpl
implements AuthClientSessionActivity {
    private static final long serialVersionUID = -7354479964717373558L;
    protected transient ClientAuthSession clientSession = null;

    public AuthClientSessionActivityImpl(DiameterMessageFactory messageFactory, DiameterAvpFactory avpFactory, ClientAuthSession clientSession, DiameterIdentity destinationHost, DiameterIdentity destinationRealm) {
        super(messageFactory, avpFactory, null, (EventListener<Request, Answer>)((EventListener)clientSession), destinationHost, destinationRealm);
        this.setSession(clientSession);
        super.setCurrentWorkingSession((Session)clientSession.getSessions().get(0));
    }

    public net.java.slee.resource.diameter.base.events.AbortSessionAnswer createAbortSessionAnswer() {
        AbortSessionRequest asr = this.messageFactory.createAbortSessionRequest();
        asr.setAuthApplicationId(0L);
        return this.createAbortSessionAnswer(asr);
    }

    public net.java.slee.resource.diameter.base.events.AbortSessionAnswer createAbortSessionAnswer(AbortSessionRequest abortSessionRequest) {
        return this.messageFactory.createAbortSessionAnswer(abortSessionRequest);
    }

    public void sendAbortSessionAnswer(net.java.slee.resource.diameter.base.events.AbortSessionAnswer answer) throws IOException {
        try {
            DiameterMessageImpl asa = (DiameterMessageImpl)answer;
            this.clientSession.sendAbortSessionAnswer((AbortSessionAnswer)new AbortSessionAnswerImpl((Answer)asa.getGenericData()));
        }
        catch (AvpNotAllowedException e) {
            throw new net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException("Message validation failed.", (Throwable)e, e.getAvpCode(), e.getVendorId());
        }
        catch (Exception e) {
            throw new IOException("Failed to send message, due to: " + e.getMessage());
        }
    }

    public net.java.slee.resource.diameter.base.events.ReAuthAnswer createReAuthAnswer() {
        ReAuthRequest rar = this.messageFactory.createReAuthRequest();
        rar.setAuthApplicationId(0L);
        return this.createReAuthAnswer(rar);
    }

    public net.java.slee.resource.diameter.base.events.ReAuthAnswer createReAuthAnswer(ReAuthRequest reAuthRequest) {
        return this.messageFactory.createReAuthAnswer(reAuthRequest);
    }

    public void sendReAuthAnswer(net.java.slee.resource.diameter.base.events.ReAuthAnswer answer) throws IOException {
        try {
            DiameterMessageImpl msg = (DiameterMessageImpl)answer;
            this.clientSession.sendReAuthAnswer((ReAuthAnswer)new ReAuthAnswerImpl((Answer)msg.getGenericData()));
        }
        catch (AvpNotAllowedException e) {
            throw new net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException("Message validation failed.", (Throwable)e, e.getAvpCode(), e.getVendorId());
        }
        catch (Exception e) {
            throw new IOException("Failed to send message, due to: " + e.getMessage());
        }
    }

    public SessionTerminationRequest createSessionTerminationRequest(TerminationCauseType terminationCause) {
        SessionTerminationRequest str = this.messageFactory.createSessionTerminationRequest();
        str.setAuthApplicationId(0L);
        str.setTerminationCause(terminationCause);
        return str;
    }

    public void sendSessionTerminationRequest(SessionTerminationRequest request) throws IOException {
        try {
            DiameterMessageImpl msg = (DiameterMessageImpl)request;
            this.clientSession.sendSessionTerminationRequest((SessionTermRequest)new SessionTermRequestImpl(msg.getGenericData()));
        }
        catch (AvpNotAllowedException e) {
            throw new net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException("Message validation failed.", (Throwable)e, e.getAvpCode(), e.getVendorId());
        }
        catch (Exception e) {
            throw new IOException("Failed to send message, due to: " + e.getMessage());
        }
    }

    public void stateChanged(AppSession source, Enum oldState, Enum newState) {
        this.stateChanged(oldState, newState);
    }

    public void stateChanged(Enum oldState, Enum newState) {
        ClientAuthSessionState state = (ClientAuthSessionState)newState;
        switch (state) {
            case IDLE: {
                break;
            }
            case OPEN: {
                break;
            }
            case PENDING: {
                break;
            }
            case DISCONNECTED: {
                this.setTerminateAfterProcessing(true);
                this.baseListener.startActivityRemoveTimer(this.getActivityHandle());
            }
        }
    }

    public AuthSessionState getSessionState() {
        ClientAuthSessionState state = (ClientAuthSessionState)this.clientSession.getState(ClientAuthSessionState.class);
        switch (state) {
            case IDLE: {
                return AuthSessionState.Idle;
            }
            case OPEN: {
                return AuthSessionState.Open;
            }
            case PENDING: {
                return AuthSessionState.Pending;
            }
            case DISCONNECTED: {
                return AuthSessionState.Disconnected;
            }
        }
        logger.error((Object)("Unexpected state in Auth Client FSM: " + state));
        return null;
    }

    public ClientAuthSession getSession() {
        return this.clientSession;
    }

    public void setSession(ClientAuthSession appSession) {
        this.clientSession = appSession;
        this.clientSession.addStateChangeNotification((StateChangeListener)this);
        this.eventListener = (EventListener)appSession;
    }

    @Override
    public void endActivity() {
        this.clientSession.release();
        super.endActivity();
    }
}

