/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.base;

import java.io.IOException;
import net.java.slee.resource.diameter.base.AuthServerSessionActivity;
import net.java.slee.resource.diameter.base.AuthSessionState;
import net.java.slee.resource.diameter.base.DiameterAvpFactory;
import net.java.slee.resource.diameter.base.DiameterMessageFactory;
import net.java.slee.resource.diameter.base.events.SessionTerminationAnswer;
import net.java.slee.resource.diameter.base.events.SessionTerminationRequest;
import net.java.slee.resource.diameter.base.events.avp.DiameterIdentity;
import net.java.slee.resource.diameter.base.events.avp.ReAuthRequestType;
import org.jdiameter.api.Answer;
import org.jdiameter.api.EventListener;
import org.jdiameter.api.Request;
import org.jdiameter.api.Session;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.api.app.StateChangeListener;
import org.jdiameter.api.auth.ServerAuthSession;
import org.jdiameter.api.auth.events.AbortSessionRequest;
import org.jdiameter.api.auth.events.ReAuthRequest;
import org.jdiameter.api.auth.events.SessionTermAnswer;
import org.jdiameter.api.validation.AvpNotAllowedException;
import org.jdiameter.common.api.app.auth.ServerAuthSessionState;
import org.jdiameter.common.impl.app.auth.AbortSessionRequestImpl;
import org.jdiameter.common.impl.app.auth.ReAuthRequestImpl;
import org.jdiameter.common.impl.app.auth.SessionTermAnswerImpl;
import org.mobicents.slee.resource.diameter.base.AuthSessionActivityImpl;
import org.mobicents.slee.resource.diameter.base.events.DiameterMessageImpl;

public class AuthServerSessionActivityImpl
extends AuthSessionActivityImpl
implements AuthServerSessionActivity {
    private static final long serialVersionUID = -3695874024822124799L;
    protected transient ServerAuthSession serverSession = null;

    public AuthServerSessionActivityImpl(DiameterMessageFactory messageFactory, DiameterAvpFactory avpFactory, ServerAuthSession serverSession, DiameterIdentity destinationHost, DiameterIdentity destinationRealm) {
        super(messageFactory, avpFactory, null, (EventListener<Request, Answer>)((EventListener)serverSession), destinationHost, destinationRealm);
        this.setSession(serverSession);
        super.setCurrentWorkingSession((Session)this.serverSession.getSessions().get(0));
    }

    public net.java.slee.resource.diameter.base.events.AbortSessionRequest createAbortSessionRequest() {
        net.java.slee.resource.diameter.base.events.AbortSessionRequest asr = this.messageFactory.createAbortSessionRequest();
        asr.setAuthApplicationId(0L);
        return asr;
    }

    public void sendAbortSessionRequest(net.java.slee.resource.diameter.base.events.AbortSessionRequest request) throws IOException {
        try {
            DiameterMessageImpl msg = (DiameterMessageImpl)request;
            this.serverSession.sendAbortSessionRequest((AbortSessionRequest)new AbortSessionRequestImpl(msg.getGenericData()));
        }
        catch (AvpNotAllowedException e) {
            throw new net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException("Message validation failed.", (Throwable)e, e.getAvpCode(), e.getVendorId());
        }
        catch (Exception e) {
            throw new IOException("Failed to send message, due to: " + e.getMessage());
        }
    }

    public net.java.slee.resource.diameter.base.events.ReAuthRequest createReAuthRequest(ReAuthRequestType reAuthRequestType) {
        net.java.slee.resource.diameter.base.events.ReAuthRequest rar = this.messageFactory.createReAuthRequest();
        rar.setAuthApplicationId(0L);
        rar.setReAuthRequestType(reAuthRequestType);
        return rar;
    }

    public void sendReAuthRequest(net.java.slee.resource.diameter.base.events.ReAuthRequest request) throws IOException {
        try {
            DiameterMessageImpl msg = (DiameterMessageImpl)request;
            this.serverSession.sendReAuthRequest((ReAuthRequest)new ReAuthRequestImpl(msg.getGenericData()));
        }
        catch (AvpNotAllowedException e) {
            throw new net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException("Message validation failed.", (Throwable)e, e.getAvpCode(), e.getVendorId());
        }
        catch (Exception e) {
            throw new IOException("Failed to send message, due to: " + e);
        }
    }

    public SessionTerminationAnswer createSessionTerminationAnswer() {
        SessionTerminationRequest str = this.messageFactory.createSessionTerminationRequest();
        str.setAuthApplicationId(0L);
        return this.createSessionTerminationAnswer(str);
    }

    public SessionTerminationAnswer createSessionTerminationAnswer(SessionTerminationRequest sessionTerminationRequest) {
        return this.messageFactory.createSessionTerminationAnswer(sessionTerminationRequest);
    }

    public void sendSessionTerminationAnswer(SessionTerminationAnswer request) throws IOException {
        try {
            DiameterMessageImpl msg = (DiameterMessageImpl)request;
            this.serverSession.sendSessionTerminationAnswer((SessionTermAnswer)new SessionTermAnswerImpl((Answer)msg.getGenericData()));
        }
        catch (AvpNotAllowedException e) {
            throw new net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException("Message validation failed.", (Throwable)e, e.getAvpCode(), e.getVendorId());
        }
        catch (Exception e) {
            throw new IOException("Failed to send message, due to: " + e);
        }
    }

    public ServerAuthSession getSession() {
        return this.serverSession;
    }

    public void stateChanged(AppSession source, Enum oldState, Enum newState) {
        this.stateChanged(oldState, newState);
    }

    public void stateChanged(Enum oldState, Enum newState) {
        ServerAuthSessionState state = (ServerAuthSessionState)newState;
        switch (state) {
            case IDLE: {
                this.setTerminateAfterProcessing(true);
                this.baseListener.startActivityRemoveTimer(this.getActivityHandle());
                break;
            }
            case OPEN: {
                break;
            }
            case DISCONNECTED: {
                this.setTerminateAfterProcessing(true);
                this.baseListener.startActivityRemoveTimer(this.getActivityHandle());
            }
        }
    }

    public AuthSessionState getSessionState() {
        ServerAuthSessionState state = (ServerAuthSessionState)this.serverSession.getState(ServerAuthSessionState.class);
        switch (state) {
            case IDLE: {
                return AuthSessionState.Idle;
            }
            case OPEN: {
                return AuthSessionState.Open;
            }
            case DISCONNECTED: {
                return AuthSessionState.Disconnected;
            }
        }
        logger.error((Object)("Unexpected state in Auth Server FSM: " + state));
        return null;
    }

    public void setSession(ServerAuthSession appSession) {
        this.serverSession = appSession;
        this.serverSession.addStateChangeNotification((StateChangeListener)this);
        this.eventListener = (EventListener)appSession;
    }

    @Override
    public void endActivity() {
        this.serverSession.release();
        super.endActivity();
    }
}

