/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.base;

import java.io.IOException;
import java.util.concurrent.Future;
import javax.naming.OperationNotSupportedException;
import net.java.slee.resource.diameter.base.DiameterActivity;
import net.java.slee.resource.diameter.base.DiameterAvpFactory;
import net.java.slee.resource.diameter.base.DiameterMessageFactory;
import net.java.slee.resource.diameter.base.events.DiameterMessage;
import net.java.slee.resource.diameter.base.events.avp.DiameterIdentity;
import org.apache.log4j.Logger;
import org.jdiameter.api.Answer;
import org.jdiameter.api.EventListener;
import org.jdiameter.api.Message;
import org.jdiameter.api.Request;
import org.jdiameter.api.Session;
import org.jdiameter.api.validation.AvpNotAllowedException;
import org.mobicents.slee.resource.diameter.base.DiameterActivityHandle;
import org.mobicents.slee.resource.diameter.base.events.AbortSessionAnswerImpl;
import org.mobicents.slee.resource.diameter.base.events.AccountingAnswerImpl;
import org.mobicents.slee.resource.diameter.base.events.CapabilitiesExchangeAnswerImpl;
import org.mobicents.slee.resource.diameter.base.events.DeviceWatchdogAnswerImpl;
import org.mobicents.slee.resource.diameter.base.events.DiameterMessageImpl;
import org.mobicents.slee.resource.diameter.base.events.DisconnectPeerAnswerImpl;
import org.mobicents.slee.resource.diameter.base.events.ErrorAnswerImpl;
import org.mobicents.slee.resource.diameter.base.events.ReAuthAnswerImpl;
import org.mobicents.slee.resource.diameter.base.events.SessionTerminationAnswerImpl;
import org.mobicents.slee.resource.diameter.base.handlers.DiameterRAInterface;

public class DiameterActivityImpl
implements DiameterActivity {
    private static final long serialVersionUID = -1065881101052214841L;
    protected static Logger logger = Logger.getLogger(DiameterActivityImpl.class);
    protected String sessionId = null;
    protected DiameterIdentity destinationHost = null;
    protected DiameterIdentity destinationRealm = null;
    protected boolean terminateAfterProcessing = false;
    protected transient Session session = null;
    protected transient EventListener<Request, Answer> eventListener = null;
    protected transient DiameterRAInterface baseListener = null;
    protected transient DiameterMessageFactory messageFactory = null;
    protected transient DiameterAvpFactory avpFactory = null;
    protected transient DiameterActivityHandle handle = null;

    public DiameterActivityImpl(DiameterMessageFactory messageFactory, DiameterAvpFactory avpFactory, Session session, EventListener<Request, Answer> raEventListener, DiameterIdentity destinationHost, DiameterIdentity destinationRealm) {
        this.messageFactory = messageFactory;
        this.avpFactory = avpFactory;
        this.session = session;
        this.eventListener = raEventListener;
        this.destinationHost = destinationHost;
        this.destinationRealm = destinationRealm;
        if (session != null) {
            this.setCurrentWorkingSession(session);
            this.sessionId = session.getSessionId();
        }
    }

    public void setCurrentWorkingSession(Session session) {
        this.sessionId = session.getSessionId();
        this.session = session;
        if (this.handle == null) {
            this.handle = new DiameterActivityHandle(this.sessionId);
        }
    }

    public void setEventListener(EventListener<Request, Answer> eventListener) {
        this.eventListener = eventListener;
    }

    public void setMessageFactory(DiameterMessageFactory messageFactory) {
        this.messageFactory = messageFactory;
    }

    public void setAvpFactory(DiameterAvpFactory avpFactory) {
        this.avpFactory = avpFactory;
    }

    public void endActivity() {
        this.setTerminateAfterProcessing(false);
        this.baseListener.stopActivityRemoveTimer(this.handle);
        if (this.session != null) {
            this.session.release();
        }
        try {
            this.baseListener.endActivity(this.getActivityHandle());
        }
        catch (Exception e) {
            logger.error((Object)("Failed to end activity [" + this + "]."), (Throwable)e);
        }
    }

    public DiameterAvpFactory getDiameterAvpFactory() {
        return this.avpFactory;
    }

    public DiameterMessageFactory getDiameterMessageFactory() {
        return this.messageFactory;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void sendMessage(DiameterMessage message) throws IOException {
        try {
            if (!(message instanceof DiameterMessageImpl)) {
                throw new OperationNotSupportedException("Trying to send wrong type of message? [" + message.getClass() + "] \n" + message);
            }
            DiameterMessageImpl msg = (DiameterMessageImpl)message;
            this.session.send(msg.getGenericData(), this.eventListener);
        }
        catch (AvpNotAllowedException e) {
            throw new net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException("Message validation failed.", (Throwable)e, e.getAvpCode(), e.getVendorId());
        }
        catch (Exception e) {
            throw new IOException("Failed to send message, due to: " + e);
        }
    }

    public DiameterActivityHandle getActivityHandle() {
        if (this.handle == null) {
            this.handle = new DiameterActivityHandle(this.sessionId);
        }
        return this.handle;
    }

    protected Message doSendMessage(DiameterMessage message) {
        Message receivedMessage = null;
        try {
            if (!(message instanceof DiameterMessageImpl)) {
                throw new OperationNotSupportedException("Trying to send wrong type of message? [" + message.getClass() + "] \n" + message);
            }
            Future future = this.session.send(((DiameterMessageImpl)message).getGenericData());
            receivedMessage = (Message)future.get();
        }
        catch (AvpNotAllowedException e) {
            throw new net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException("Message validation failed.", (Throwable)e, e.getAvpCode(), e.getVendorId());
        }
        catch (Exception e) {
            logger.error((Object)"Failure sending sync request.", (Throwable)e);
        }
        return receivedMessage;
    }

    public DiameterMessage sendSyncMessage(DiameterMessage message) {
        ErrorAnswerImpl answer = null;
        Message receivedMessage = this.doSendMessage(message);
        if (receivedMessage != null) {
            if (!receivedMessage.isRequest()) {
                if (receivedMessage.isError()) {
                    answer = new ErrorAnswerImpl(receivedMessage);
                } else {
                    switch (receivedMessage.getCommandCode()) {
                        case 274: {
                            answer = new AbortSessionAnswerImpl(receivedMessage);
                            break;
                        }
                        case 271: {
                            answer = new AccountingAnswerImpl(receivedMessage);
                            break;
                        }
                        case 257: {
                            answer = new CapabilitiesExchangeAnswerImpl(receivedMessage);
                            break;
                        }
                        case 280: {
                            answer = new DeviceWatchdogAnswerImpl(receivedMessage);
                            break;
                        }
                        case 282: {
                            answer = new DisconnectPeerAnswerImpl(receivedMessage);
                            break;
                        }
                        case 258: {
                            answer = new ReAuthAnswerImpl(receivedMessage);
                            break;
                        }
                        case 275: {
                            answer = new SessionTerminationAnswerImpl(receivedMessage);
                            break;
                        }
                        default: {
                            logger.error((Object)("Received an unknown type of Message for Base Activity: " + receivedMessage));
                            break;
                        }
                    }
                }
            } else {
                logger.error((Object)"Received a REQUEST message when expecting an ANSWER.");
            }
        } else {
            logger.debug((Object)"No answer received. Returning null.");
        }
        return answer;
    }

    public boolean isValid() {
        return this.session.isValid();
    }

    public Object getSessionListener() {
        return this.baseListener;
    }

    public void setSessionListener(Object ra) {
        this.baseListener = (DiameterRAInterface)ra;
    }

    public void setTerminateAfterProcessing(boolean terminateAfterProcessing) {
        this.terminateAfterProcessing = terminateAfterProcessing;
    }

    public boolean isTerminateAfterProcessing() {
        return this.terminateAfterProcessing;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.destinationHost == null ? 0 : this.destinationHost.hashCode());
        result = 31 * result + (this.destinationRealm == null ? 0 : this.destinationRealm.hashCode());
        result = 31 * result + (this.sessionId == null ? 0 : this.sessionId.hashCode());
        result = 31 * result + (this.terminateAfterProcessing ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DiameterActivityImpl other = (DiameterActivityImpl)obj;
        if (this.destinationHost == null ? other.destinationHost != null : !this.destinationHost.equals((Object)other.destinationHost)) {
            return false;
        }
        if (this.destinationRealm == null ? other.destinationRealm != null : !this.destinationRealm.equals((Object)other.destinationRealm)) {
            return false;
        }
        if (this.sessionId == null ? other.sessionId != null : !this.sessionId.equals(other.sessionId)) {
            return false;
        }
        return this.terminateAfterProcessing == other.terminateAfterProcessing;
    }
}

