/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.base;

import net.java.slee.resource.diameter.base.DiameterMessageFactory;
import net.java.slee.resource.diameter.base.events.AbortSessionAnswer;
import net.java.slee.resource.diameter.base.events.AbortSessionRequest;
import net.java.slee.resource.diameter.base.events.AccountingAnswer;
import net.java.slee.resource.diameter.base.events.AccountingRequest;
import net.java.slee.resource.diameter.base.events.CapabilitiesExchangeAnswer;
import net.java.slee.resource.diameter.base.events.CapabilitiesExchangeRequest;
import net.java.slee.resource.diameter.base.events.DeviceWatchdogAnswer;
import net.java.slee.resource.diameter.base.events.DeviceWatchdogRequest;
import net.java.slee.resource.diameter.base.events.DiameterCommand;
import net.java.slee.resource.diameter.base.events.DiameterHeader;
import net.java.slee.resource.diameter.base.events.DiameterMessage;
import net.java.slee.resource.diameter.base.events.DisconnectPeerAnswer;
import net.java.slee.resource.diameter.base.events.DisconnectPeerRequest;
import net.java.slee.resource.diameter.base.events.ExtensionDiameterMessage;
import net.java.slee.resource.diameter.base.events.ReAuthAnswer;
import net.java.slee.resource.diameter.base.events.ReAuthRequest;
import net.java.slee.resource.diameter.base.events.SessionTerminationAnswer;
import net.java.slee.resource.diameter.base.events.SessionTerminationRequest;
import net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException;
import net.java.slee.resource.diameter.base.events.avp.AvpUtilities;
import net.java.slee.resource.diameter.base.events.avp.DiameterAvp;
import net.java.slee.resource.diameter.base.events.avp.DiameterIdentity;
import net.java.slee.resource.diameter.base.events.avp.GroupedAvp;
import org.apache.log4j.Logger;
import org.jdiameter.api.ApplicationId;
import org.jdiameter.api.Avp;
import org.jdiameter.api.AvpSet;
import org.jdiameter.api.Message;
import org.jdiameter.api.Session;
import org.jdiameter.api.Stack;
import org.jdiameter.client.impl.parser.MessageImpl;
import org.mobicents.slee.resource.diameter.base.events.AbortSessionAnswerImpl;
import org.mobicents.slee.resource.diameter.base.events.AbortSessionRequestImpl;
import org.mobicents.slee.resource.diameter.base.events.AccountingAnswerImpl;
import org.mobicents.slee.resource.diameter.base.events.AccountingRequestImpl;
import org.mobicents.slee.resource.diameter.base.events.CapabilitiesExchangeAnswerImpl;
import org.mobicents.slee.resource.diameter.base.events.CapabilitiesExchangeRequestImpl;
import org.mobicents.slee.resource.diameter.base.events.DeviceWatchdogAnswerImpl;
import org.mobicents.slee.resource.diameter.base.events.DeviceWatchdogRequestImpl;
import org.mobicents.slee.resource.diameter.base.events.DisconnectPeerAnswerImpl;
import org.mobicents.slee.resource.diameter.base.events.DisconnectPeerRequestImpl;
import org.mobicents.slee.resource.diameter.base.events.ExtensionDiameterMessageImpl;
import org.mobicents.slee.resource.diameter.base.events.ReAuthAnswerImpl;
import org.mobicents.slee.resource.diameter.base.events.ReAuthRequestImpl;
import org.mobicents.slee.resource.diameter.base.events.SessionTerminationAnswerImpl;
import org.mobicents.slee.resource.diameter.base.events.SessionTerminationRequestImpl;

public class DiameterMessageFactoryImpl
implements DiameterMessageFactory {
    private static Logger logger = Logger.getLogger(DiameterMessageFactoryImpl.class);
    protected Session session;
    protected Stack stack;
    private static final ApplicationId BASE_AUTH_APP_ID = ApplicationId.createByAuthAppId((long)0L, (long)0L);
    private static final ApplicationId BASE_ACCT_APP_ID = ApplicationId.createByAccAppId((long)0L, (long)3L);

    public DiameterMessageFactoryImpl(Session session, Stack stack, DiameterIdentity ... avps) {
        this.session = session;
        this.stack = stack;
    }

    public DiameterMessageFactoryImpl(Stack stack) {
        this.stack = stack;
    }

    public AbortSessionAnswer createAbortSessionAnswer(AbortSessionRequest request, DiameterAvp[] avps) throws AvpNotAllowedException {
        AbortSessionAnswer msg = (AbortSessionAnswer)this.createDiameterMessage(request.getHeader(), avps, 274, this.getApplicationId((DiameterMessage)request));
        this.addSessionIdAvp((DiameterMessage)msg);
        return msg;
    }

    public AbortSessionAnswer createAbortSessionAnswer(AbortSessionRequest request) {
        try {
            return this.createAbortSessionAnswer(request, new DiameterAvp[0]);
        }
        catch (AvpNotAllowedException e) {
            logger.error((Object)"Unexpected failure while trying to create ASA message.", (Throwable)e);
            return null;
        }
    }

    public AbortSessionRequest createAbortSessionRequest(DiameterAvp[] avps) throws AvpNotAllowedException {
        ApplicationId appId = this.getApplicationId(avps);
        AbortSessionRequest msg = (AbortSessionRequest)this.createDiameterMessage(null, avps, 274, appId != null ? appId : BASE_AUTH_APP_ID);
        this.addSessionIdAvp((DiameterMessage)msg);
        return msg;
    }

    public AbortSessionRequest createAbortSessionRequest() {
        try {
            return this.createAbortSessionRequest(new DiameterAvp[0]);
        }
        catch (AvpNotAllowedException e) {
            logger.error((Object)"Unexpected failure while trying to create ASR message.", (Throwable)e);
            return null;
        }
    }

    public AccountingAnswer createAccountingAnswer(AccountingRequest request, DiameterAvp[] avps) throws AvpNotAllowedException {
        AccountingAnswer msg = (AccountingAnswer)this.createDiameterMessage(request.getHeader(), avps, 271, this.getApplicationId((DiameterMessage)request));
        this.addSessionIdAvp((DiameterMessage)msg);
        return msg;
    }

    public AccountingAnswer createAccountingAnswer(AccountingRequest request) {
        try {
            return this.createAccountingAnswer(request, new DiameterAvp[0]);
        }
        catch (AvpNotAllowedException e) {
            logger.error((Object)"Unexpected failure while trying to create ACA message.", (Throwable)e);
            return null;
        }
    }

    public AccountingRequest createAccountingRequest(DiameterAvp[] avps) throws AvpNotAllowedException {
        ApplicationId appId = this.getApplicationId(avps);
        AccountingRequest msg = (AccountingRequest)this.createDiameterMessage(null, avps, 271, appId != null ? appId : BASE_ACCT_APP_ID);
        this.addSessionIdAvp((DiameterMessage)msg);
        return msg;
    }

    public AccountingRequest createAccountingRequest() {
        try {
            return this.createAccountingRequest(new DiameterAvp[0]);
        }
        catch (AvpNotAllowedException e) {
            logger.error((Object)"Unexpected failure while trying to create ACR message.", (Throwable)e);
            return null;
        }
    }

    public CapabilitiesExchangeAnswer createCapabilitiesExchangeAnswer(CapabilitiesExchangeRequest request, DiameterAvp[] avps) throws AvpNotAllowedException {
        CapabilitiesExchangeAnswer msg = (CapabilitiesExchangeAnswer)this.createDiameterMessage(request.getHeader(), avps, 257, this.getApplicationId((DiameterMessage)request));
        this.addSessionIdAvp((DiameterMessage)msg);
        return msg;
    }

    public CapabilitiesExchangeAnswer createCapabilitiesExchangeAnswer(CapabilitiesExchangeRequest request) {
        try {
            return this.createCapabilitiesExchangeAnswer(request, new DiameterAvp[0]);
        }
        catch (AvpNotAllowedException e) {
            logger.error((Object)"Unexpected failure while trying to create CEA message.", (Throwable)e);
            return null;
        }
    }

    public CapabilitiesExchangeRequest createCapabilitiesExchangeRequest(DiameterAvp[] avps) throws AvpNotAllowedException {
        CapabilitiesExchangeRequest msg = (CapabilitiesExchangeRequest)this.createDiameterMessage(null, avps, 257, BASE_AUTH_APP_ID);
        this.addSessionIdAvp((DiameterMessage)msg);
        return msg;
    }

    public CapabilitiesExchangeRequest createCapabilitiesExchangeRequest() {
        try {
            return this.createCapabilitiesExchangeRequest(new DiameterAvp[0]);
        }
        catch (AvpNotAllowedException e) {
            logger.error((Object)"Unexpected failure while trying to create CER message.", (Throwable)e);
            return null;
        }
    }

    public DeviceWatchdogAnswer createDeviceWatchdogAnswer(DeviceWatchdogRequest request, DiameterAvp[] avps) throws AvpNotAllowedException {
        DeviceWatchdogAnswer msg = (DeviceWatchdogAnswer)this.createDiameterMessage(request.getHeader(), avps, 280, this.getApplicationId((DiameterMessage)request));
        this.addSessionIdAvp((DiameterMessage)msg);
        return msg;
    }

    public DeviceWatchdogAnswer createDeviceWatchdogAnswer(DeviceWatchdogRequest request) {
        try {
            return this.createDeviceWatchdogAnswer(request, new DiameterAvp[0]);
        }
        catch (AvpNotAllowedException e) {
            logger.error((Object)"Unexpected failure while trying to create DWA message.", (Throwable)e);
            return null;
        }
    }

    public DeviceWatchdogRequest createDeviceWatchdogRequest(DiameterAvp[] avps) throws AvpNotAllowedException {
        DeviceWatchdogRequest msg = (DeviceWatchdogRequest)this.createDiameterMessage(null, avps, 280, BASE_AUTH_APP_ID);
        this.addSessionIdAvp((DiameterMessage)msg);
        return msg;
    }

    public DeviceWatchdogRequest createDeviceWatchdogRequest() {
        try {
            return this.createDeviceWatchdogRequest(new DiameterAvp[0]);
        }
        catch (AvpNotAllowedException e) {
            logger.error((Object)"Unexpected failure while trying to create DWR message.", (Throwable)e);
            return null;
        }
    }

    public DisconnectPeerAnswer createDisconnectPeerAnswer(DisconnectPeerRequest request, DiameterAvp[] avps) throws AvpNotAllowedException {
        DisconnectPeerAnswer msg = (DisconnectPeerAnswer)this.createDiameterMessage(request.getHeader(), avps, 282, this.getApplicationId((DiameterMessage)request));
        this.addSessionIdAvp((DiameterMessage)msg);
        return msg;
    }

    public DisconnectPeerAnswer createDisconnectPeerAnswer(DisconnectPeerRequest request) {
        try {
            return this.createDisconnectPeerAnswer(request, new DiameterAvp[0]);
        }
        catch (AvpNotAllowedException e) {
            logger.error((Object)"Unexpected failure while trying to create DPA message.", (Throwable)e);
            return null;
        }
    }

    public DisconnectPeerRequest createDisconnectPeerRequest(DiameterAvp[] avps) throws AvpNotAllowedException {
        DisconnectPeerRequest msg = (DisconnectPeerRequest)this.createDiameterMessage(null, avps, 282, BASE_AUTH_APP_ID);
        this.addSessionIdAvp((DiameterMessage)msg);
        return msg;
    }

    public DisconnectPeerRequest createDisconnectPeerRequest() {
        try {
            return this.createDisconnectPeerRequest(new DiameterAvp[0]);
        }
        catch (AvpNotAllowedException e) {
            logger.error((Object)"Unexpected failure while trying to create DPR message.", (Throwable)e);
            return null;
        }
    }

    public ExtensionDiameterMessage createMessage(DiameterCommand command, DiameterAvp[] avps) throws AvpNotAllowedException {
        ApplicationId aid = command.getCode() == 271 ? ApplicationId.createByAccAppId((long)0L, (long)command.getApplicationId()) : ApplicationId.createByAuthAppId((long)0L, (long)command.getApplicationId());
        ExtensionDiameterMessageImpl msg = (ExtensionDiameterMessageImpl)this.createDiameterMessage(null, avps, command.getCode(), aid);
        msg.getGenericData().setRequest(command.isRequest());
        ((MessageImpl)msg.getGenericData()).setProxiable(command.isProxiable());
        if (!command.isRequest()) {
            ((MessageImpl)msg.getGenericData()).setReTransmitted(false);
        }
        return msg;
    }

    public ReAuthAnswer createReAuthAnswer(ReAuthRequest request, DiameterAvp[] avps) throws AvpNotAllowedException {
        ReAuthAnswer msg = (ReAuthAnswer)this.createDiameterMessage(request.getHeader(), avps, 258, this.getApplicationId((DiameterMessage)request));
        this.addSessionIdAvp((DiameterMessage)msg);
        return msg;
    }

    public ReAuthAnswer createReAuthAnswer(ReAuthRequest request) {
        try {
            return this.createReAuthAnswer(request, new DiameterAvp[0]);
        }
        catch (AvpNotAllowedException e) {
            logger.error((Object)"Unexpected failure while trying to create RAA message.", (Throwable)e);
            return null;
        }
    }

    public ReAuthRequest createReAuthRequest(DiameterAvp[] avps) throws AvpNotAllowedException {
        ReAuthRequest msg = (ReAuthRequest)this.createDiameterMessage(null, avps, 258, BASE_AUTH_APP_ID);
        this.addSessionIdAvp((DiameterMessage)msg);
        return msg;
    }

    public ReAuthRequest createReAuthRequest() {
        try {
            return this.createReAuthRequest(new DiameterAvp[0]);
        }
        catch (AvpNotAllowedException e) {
            logger.error((Object)"Unexpected failure while trying to create RAR message.", (Throwable)e);
            return null;
        }
    }

    public SessionTerminationAnswer createSessionTerminationAnswer(SessionTerminationRequest request, DiameterAvp[] avps) throws AvpNotAllowedException {
        SessionTerminationAnswer msg = (SessionTerminationAnswer)this.createDiameterMessage(request.getHeader(), avps, 275, this.getApplicationId((DiameterMessage)request));
        this.addSessionIdAvp((DiameterMessage)msg);
        return msg;
    }

    public SessionTerminationAnswer createSessionTerminationAnswer(SessionTerminationRequest request) {
        try {
            return this.createSessionTerminationAnswer(request, new DiameterAvp[0]);
        }
        catch (AvpNotAllowedException e) {
            logger.error((Object)"Unexpected failure while trying to create STA message.", (Throwable)e);
            return null;
        }
    }

    public SessionTerminationRequest createSessionTerminationRequest(DiameterAvp[] avps) throws AvpNotAllowedException {
        SessionTerminationRequest msg = (SessionTerminationRequest)this.createDiameterMessage(null, avps, 275, BASE_AUTH_APP_ID);
        this.addSessionIdAvp((DiameterMessage)msg);
        return msg;
    }

    public SessionTerminationRequest createSessionTerminationRequest() {
        try {
            return this.createSessionTerminationRequest(new DiameterAvp[0]);
        }
        catch (AvpNotAllowedException e) {
            logger.error((Object)"Unexpected failure while trying to create STR message.", (Throwable)e);
            return null;
        }
    }

    protected DiameterMessage createDiameterMessage(DiameterHeader diameterHeader, DiameterAvp[] avps, int _commandCode, ApplicationId appId) throws IllegalArgumentException {
        Message raw;
        boolean creatingRequest = diameterHeader == null;
        Message msg = null;
        if (!creatingRequest) {
            raw = this.createMessage(diameterHeader, avps, 0, appId);
            raw.setRequest(false);
            raw.setReTransmitted(false);
            msg = raw;
        } else {
            raw = this.createMessage(diameterHeader, avps, _commandCode, appId);
            boolean isPeerManagementMessage = _commandCode == 257 || _commandCode == 280 || _commandCode == 282;
            raw.setProxiable(!isPeerManagementMessage);
            raw.setRequest(true);
            msg = raw;
        }
        int commandCode = creatingRequest ? _commandCode : diameterHeader.getCommandCode();
        ExtensionDiameterMessageImpl diamMessage = null;
        switch (commandCode) {
            case 274: {
                diamMessage = creatingRequest ? new AbortSessionRequestImpl(msg) : new AbortSessionAnswerImpl(msg);
                break;
            }
            case 271: {
                diamMessage = creatingRequest ? new AccountingRequestImpl(msg) : new AccountingAnswerImpl(msg);
                break;
            }
            case 257: {
                diamMessage = creatingRequest ? new CapabilitiesExchangeRequestImpl(msg) : new CapabilitiesExchangeAnswerImpl(msg);
                break;
            }
            case 280: {
                diamMessage = creatingRequest ? new DeviceWatchdogRequestImpl(msg) : new DeviceWatchdogAnswerImpl(msg);
                break;
            }
            case 282: {
                diamMessage = creatingRequest ? new DisconnectPeerRequestImpl(msg) : new DisconnectPeerAnswerImpl(msg);
                break;
            }
            case 258: {
                diamMessage = creatingRequest ? new ReAuthRequestImpl(msg) : new ReAuthAnswerImpl(msg);
                break;
            }
            case 275: {
                diamMessage = creatingRequest ? new SessionTerminationRequestImpl(msg) : new SessionTerminationAnswerImpl(msg);
                break;
            }
            default: {
                diamMessage = new ExtensionDiameterMessageImpl(msg);
            }
        }
        this.addOriginHostAndRealm((DiameterMessage)diamMessage);
        return diamMessage;
    }

    protected Message createMessage(DiameterHeader header, DiameterAvp[] avps, int _commandCode, ApplicationId appId) throws AvpNotAllowedException {
        try {
            Message msg = this.createRawMessage(header, _commandCode, appId);
            if (avps != null && avps.length > 0) {
                AvpSet set = msg.getAvps();
                for (DiameterAvp avp : avps) {
                    if (appId != null && (avp.getCode() == 260 || avp.getCode() == 259 || avp.getCode() == 258)) continue;
                    this.addAvp(avp, set);
                }
            }
            return msg;
        }
        catch (Exception e) {
            logger.error((Object)"Failure trying to create Diameter message.", (Throwable)e);
            return null;
        }
    }

    protected Message createRawMessage(DiameterHeader header, int _commandCode, ApplicationId appId) {
        int commandCode = 0;
        long endToEndId = -1L;
        long hopByHopId = -1L;
        boolean isRequest = true;
        boolean isProxiable = true;
        boolean isError = false;
        boolean isPotentiallyRetransmitted = false;
        if (header != null) {
            commandCode = header.getCommandCode();
            endToEndId = header.getEndToEndId();
            hopByHopId = header.getHopByHopId();
            isRequest = header.isRequest();
            isProxiable = header.isProxiable();
            isError = header.isError();
            isPotentiallyRetransmitted = header.isPotentiallyRetransmitted();
        } else {
            commandCode = _commandCode;
        }
        try {
            Message msg = this.stack.getSessionFactory().getNewRawSession().createMessage(commandCode, appId, hopByHopId, endToEndId, new Avp[0]);
            msg.setRequest(isRequest);
            msg.setProxiable(isProxiable);
            msg.setError(isError);
            msg.setReTransmitted(isRequest && isPotentiallyRetransmitted);
            return msg;
        }
        catch (Exception e) {
            logger.error((Object)"Failure while trying to create raw message.", (Throwable)e);
            return null;
        }
    }

    protected void addAvp(DiameterAvp avp, AvpSet set) {
        AvpUtilities.addAvp((DiameterAvp)avp, (AvpSet)set);
    }

    public void clean() {
        this.session = null;
    }

    public DiameterMessage createMessage(DiameterHeader header, DiameterAvp[] avps) throws AvpNotAllowedException {
        return this.createDiameterMessage(header, avps, header.getCommandCode(), this.getApplicationId(avps));
    }

    private void addOriginHostAndRealm(DiameterMessage msg) {
        if (!msg.hasOriginHost()) {
            msg.setOriginHost(new DiameterIdentity(this.stack.getMetaData().getLocalPeer().getUri().getFQDN().toString()));
        }
        if (!msg.hasOriginRealm()) {
            msg.setOriginRealm(new DiameterIdentity(this.stack.getMetaData().getLocalPeer().getRealmName()));
        }
    }

    private ApplicationId getApplicationId(DiameterMessage msg) {
        ApplicationId applicationId = this.getApplicationId(msg.getAvps());
        if (applicationId == null) {
            applicationId = msg.getCommand().getCode() == 271 ? ApplicationId.createByAccAppId((long)0L) : ApplicationId.createByAuthAppId((long)0L);
        }
        return applicationId;
    }

    private ApplicationId getApplicationId(DiameterAvp[] avps) {
        ApplicationId applicationId = null;
        long vendorId = 0L;
        if (avps != null) {
            for (DiameterAvp avp : avps) {
                if (avp.getCode() == 266) {
                    vendorId = avp.intValue();
                }
                if (avp.getCode() == 260) {
                    applicationId = this.getApplicationId(((GroupedAvp)avp).getExtensionAvps());
                    break;
                }
                if (avp.getCode() == 259) {
                    applicationId = ApplicationId.createByAccAppId((long)vendorId, (long)avp.intValue());
                    break;
                }
                if (avp.getCode() != 258) continue;
                applicationId = ApplicationId.createByAuthAppId((long)vendorId, (long)avp.intValue());
                break;
            }
        }
        return applicationId;
    }

    private void addSessionIdAvp(DiameterMessage msg) {
        if (!msg.hasSessionId() && this.session != null) {
            msg.setSessionId(this.session.getSessionId());
        }
    }
}

