/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.base.handlers;

import java.util.HashMap;
import java.util.HashSet;
import org.apache.log4j.Logger;
import org.jdiameter.api.ApplicationId;
import org.jdiameter.api.IllegalDiameterStateException;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.Message;
import org.jdiameter.api.OverloadException;
import org.jdiameter.api.RouteException;
import org.jdiameter.api.Session;
import org.jdiameter.api.SessionFactory;
import org.jdiameter.api.acc.ClientAccSession;
import org.jdiameter.api.acc.ClientAccSessionListener;
import org.jdiameter.api.acc.ServerAccSession;
import org.jdiameter.api.acc.ServerAccSessionListener;
import org.jdiameter.api.acc.events.AccountAnswer;
import org.jdiameter.api.acc.events.AccountRequest;
import org.jdiameter.api.app.AppAnswerEvent;
import org.jdiameter.api.app.AppRequestEvent;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.api.app.StateChangeListener;
import org.jdiameter.client.api.ISessionFactory;
import org.jdiameter.common.api.app.IAppSessionFactory;
import org.jdiameter.common.impl.app.acc.AccSessionFactoryImpl;
import org.mobicents.slee.resource.diameter.base.handlers.DiameterRAInterface;

public class AccountingSessionFactory
extends AccSessionFactoryImpl
implements IAppSessionFactory,
ServerAccSessionListener,
StateChangeListener<AppSession>,
ClientAccSessionListener {
    private static HashSet<Integer> accEventCodes = new HashSet();
    private static HashSet<Integer> authEventCodes = new HashSet();
    protected HashMap<ApplicationId, DiameterRAInterface> ras = new HashMap();
    protected long messageTimeout = 5000L;
    protected SessionFactory sessionFactory = null;
    protected static final Logger logger;
    public static AccountingSessionFactory INSTANCE;

    private AccountingSessionFactory() {
    }

    public void registerListener(DiameterRAInterface ra, long messageTimeout, SessionFactory sessionFactory) {
        for (ApplicationId appId : ra.getSupportedApplications()) {
            this.ras.put(appId, ra);
        }
        this.messageTimeout = messageTimeout;
        this.sessionFactory = sessionFactory;
        super.setSessionFactory((ISessionFactory)sessionFactory);
    }

    public AppSession getNewSession(String sessionId, Class<? extends AppSession> aClass, ApplicationId applicationId, Object[] args) {
        AppSession session = super.getNewSession(sessionId, aClass, applicationId, args);
        if (aClass == ServerAccSession.class) {
            return session;
        }
        if (aClass == ClientAccSession.class) {
            return session;
        }
        return null;
    }

    public void doAccRequestEvent(ServerAccSession appSession, AccountRequest acr) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info((Object)("Diameter Base AccountingSessionFactory :: doAccRequestEvent :: appSession[" + appSession + "], Request[" + acr + "]"));
        this.doFireEvent((AppSession)appSession, acr.getMessage());
    }

    public void doAccAnswerEvent(ClientAccSession appSession, AccountRequest acr, AccountAnswer aca) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info((Object)("doAccAnswerEvent :: appSession[" + appSession + "], Request[" + acr + "], Answer[" + aca + "]"));
        this.doFireEvent((AppSession)appSession, aca.getMessage());
    }

    public void doOtherEvent(AppSession appSession, AppRequestEvent request, AppAnswerEvent answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info((Object)("Diameter Base AccountingSessionFactory :: doOtherEvent :: appSession[" + appSession + "], Request[" + request + "], Answer[" + answer + "]"));
        this.doFireEvent(appSession, answer != null ? answer.getMessage() : request.getMessage());
    }

    public void stateChanged(Enum oldState, Enum newState) {
        logger.info((Object)("Diameter Base AccountingSessionFactory :: stateChanged :: oldState[" + oldState + "], newState[" + newState + "]"));
    }

    public void stateChanged(AppSession source, Enum oldState, Enum newState) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Diameter Base AccountingSessionFactory :: stateChanged :: source[" + source + "] :: oldState[" + oldState + "], newState[" + newState + "]"));
        }
    }

    private void doFireEvent(AppSession appSession, Message message) {
        DiameterRAInterface ra;
        ApplicationId appId = null;
        for (ApplicationId curAppId : message.getApplicationIdAvps()) {
            if (curAppId.getAcctAppId() == 0L || !this.ras.containsKey(curAppId)) continue;
            appId = curAppId;
            break;
        }
        DiameterRAInterface diameterRAInterface = ra = appId != null ? this.ras.get(appId) : this.ras.values().iterator().next();
        if (ra != null) {
            ra.fireEvent(((Session)appSession.getSessions().get(0)).getSessionId(), message);
        }
    }

    static {
        authEventCodes.add(274);
        authEventCodes.add(258);
        authEventCodes.add(275);
        accEventCodes.add(271);
        logger = Logger.getLogger(AccountingSessionFactory.class);
        INSTANCE = new AccountingSessionFactory();
    }
}

