/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.base.handlers;

import org.apache.log4j.Logger;
import org.jdiameter.api.Answer;
import org.jdiameter.api.ApplicationId;
import org.jdiameter.api.IllegalDiameterStateException;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.Message;
import org.jdiameter.api.OverloadException;
import org.jdiameter.api.Request;
import org.jdiameter.api.RouteException;
import org.jdiameter.api.Session;
import org.jdiameter.api.SessionFactory;
import org.jdiameter.api.app.AppAnswerEvent;
import org.jdiameter.api.app.AppRequestEvent;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.api.app.StateChangeListener;
import org.jdiameter.api.auth.ClientAuthSession;
import org.jdiameter.api.auth.ClientAuthSessionListener;
import org.jdiameter.api.auth.ServerAuthSession;
import org.jdiameter.api.auth.ServerAuthSessionListener;
import org.jdiameter.api.auth.events.AbortSessionAnswer;
import org.jdiameter.api.auth.events.AbortSessionRequest;
import org.jdiameter.api.auth.events.ReAuthAnswer;
import org.jdiameter.api.auth.events.ReAuthRequest;
import org.jdiameter.api.auth.events.SessionTermAnswer;
import org.jdiameter.api.auth.events.SessionTermRequest;
import org.jdiameter.client.impl.app.auth.ClientAuthSessionImpl;
import org.jdiameter.common.api.app.IAppSessionFactory;
import org.jdiameter.common.api.app.auth.IAuthMessageFactory;
import org.jdiameter.common.impl.app.AppAnswerEventImpl;
import org.jdiameter.common.impl.app.AppRequestEventImpl;
import org.jdiameter.common.impl.app.auth.AuthSessionFactoryImpl;
import org.jdiameter.server.impl.app.auth.ServerAuthSessionImpl;
import org.mobicents.slee.resource.diameter.base.handlers.DiameterRAInterface;

public class AuthorizationSessionFactory
extends AuthSessionFactoryImpl
implements IAppSessionFactory,
IAuthMessageFactory,
ServerAuthSessionListener,
StateChangeListener<AppSession>,
ClientAuthSessionListener {
    private long authAppId = 19301L;
    protected DiameterRAInterface ra;
    protected long messageTimeout = 5000L;
    protected SessionFactory sessionFactory = null;
    protected static final Logger logger = Logger.getLogger(AuthorizationSessionFactory.class);
    private boolean stateless = true;

    public AuthorizationSessionFactory(DiameterRAInterface ra, long messageTimeout, SessionFactory sessionFactory) {
        super(sessionFactory);
        this.ra = ra;
        this.messageTimeout = messageTimeout;
        this.sessionFactory = sessionFactory;
    }

    public AppSession getNewSession(String sessionId, Class<? extends AppSession> aClass, ApplicationId applicationId, Object[] args) {
        AppSession session = super.getNewSession(sessionId, aClass, applicationId, args);
        if (aClass == ServerAuthSession.class) {
            ServerAuthSessionImpl serverAuthSession = (ServerAuthSessionImpl)session;
            return serverAuthSession;
        }
        if (aClass == ClientAuthSession.class) {
            ClientAuthSessionImpl clientAuthSession = (ClientAuthSessionImpl)session;
            return clientAuthSession;
        }
        return null;
    }

    public void stateChanged(Enum oldState, Enum newState) {
        logger.info((Object)("Diameter Base AuthorizationSessionFactory :: stateChanged :: oldState[" + oldState + "], newState[" + newState + "]"));
    }

    public void stateChanged(AppSession source, Enum oldState, Enum newState) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Diameter Base AuthorizationSessionFactory :: stateChanged :: source[" + source + "] :: oldState[" + oldState + "], newState[" + newState + "]"));
        }
    }

    public void doAbortSessionRequestEvent(ClientAuthSession appSession, AbortSessionRequest asr) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info((Object)("Diameter Base AuthorizationSessionFactory :: doAbortSessionRequestEvent :: appSession[" + appSession + "], ASR[" + asr + "]"));
        this.doFireEvent((AppSession)appSession, asr.getMessage());
    }

    public void doAbortSessionAnswerEvent(ServerAuthSession appSession, AbortSessionAnswer asa) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info((Object)("Diameter Base AuthorizationSessionFactory :: doAbortSessionAnswerEvent :: appSession[" + appSession + "], ASA[" + asa + "]"));
        this.doFireEvent((AppSession)appSession, asa.getMessage());
    }

    public void doSessionTerminationRequestEvent(ServerAuthSession appSession, SessionTermRequest str) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info((Object)("Diameter Base AuthorizationSessionFactory :: doSessionTerminationRequestEvent :: appSession[" + appSession + "], STA[" + str + "]"));
        this.doFireEvent((AppSession)appSession, str.getMessage());
    }

    public void doSessionTerminationAnswerEvent(ClientAuthSession appSession, SessionTermAnswer sta) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info((Object)("Diameter Base AuthorizationSessionFactory :: doSessionTerminationAnswerEvent :: appSession[" + appSession + "], STA[" + sta + "]"));
        this.doFireEvent((AppSession)appSession, sta.getMessage());
    }

    public void doAuthRequestEvent(ServerAuthSession appSession, AppRequestEvent request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info((Object)("Diameter Base AuthorizationSessionFactory :: doAuthRequestEvent :: appSession[" + appSession + "], Request[" + request + "]"));
        this.doFireEvent((AppSession)appSession, request.getMessage());
    }

    public void doAuthAnswerEvent(ClientAuthSession appSession, AppRequestEvent request, AppAnswerEvent answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info((Object)("Diameter Base AuthorizationSessionFactory :: doAuthAnswerEvent :: appSession[" + appSession + "], Request[" + request + "], Answer[" + answer + "]"));
        this.doFireEvent((AppSession)appSession, answer.getMessage());
    }

    public void doReAuthRequestEvent(ClientAuthSession appSession, ReAuthRequest rar) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info((Object)("Diameter Base AuthorizationSessionFactory :: doReAuthRequestEvent :: appSession[" + appSession + "], RAR[" + rar + "]"));
        this.doFireEvent((AppSession)appSession, rar.getMessage());
    }

    public void doReAuthAnswerEvent(ServerAuthSession appSession, ReAuthRequest rar, ReAuthAnswer raa) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info((Object)("Diameter Base AuthorizationSessionFactory :: doReAuthAnswerEvent :: appSession[" + appSession + "], RAR[" + rar + "], RAA[" + raa + "]"));
        this.doFireEvent((AppSession)appSession, raa.getMessage());
    }

    public void doOtherEvent(AppSession appSession, AppRequestEvent request, AppAnswerEvent answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info((Object)("Diameter Base AuthorizationSessionFactory :: doOtherEvent :: appSession[" + appSession + "], Request[" + request + "], Answer[" + answer + "]"));
        this.doFireEvent(appSession, answer != null ? answer.getMessage() : request.getMessage());
    }

    public AppAnswerEvent createAuthAnswer(Answer answer) {
        return new AppAnswerEventImpl(answer);
    }

    public AppRequestEvent createAuthRequest(Request request) {
        return new AppRequestEventImpl((Message)request);
    }

    public ApplicationId getApplicationId() {
        return ApplicationId.createByAuthAppId((long)this.authAppId);
    }

    public int getAuthMessageCommandCode() {
        return 0;
    }

    public void setStateless(boolean stateless) {
        this.stateless = stateless;
    }

    public boolean getStateless() {
        return this.stateless;
    }

    private void doFireEvent(AppSession appSession, Message message) {
        this.ra.fireEvent(((Session)appSession.getSessions().get(0)).getSessionId(), message);
    }
}

