/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.cxdx;

import java.io.IOException;
import javax.slee.resource.SleeEndpoint;
import net.java.slee.resource.diameter.base.events.DiameterMessage;
import net.java.slee.resource.diameter.base.events.avp.DiameterAvp;
import net.java.slee.resource.diameter.base.events.avp.DiameterIdentity;
import net.java.slee.resource.diameter.cxdx.CxDxAVPFactory;
import net.java.slee.resource.diameter.cxdx.CxDxClientSessionActivity;
import net.java.slee.resource.diameter.cxdx.CxDxMessageFactory;
import net.java.slee.resource.diameter.cxdx.events.LocationInfoRequest;
import net.java.slee.resource.diameter.cxdx.events.MultimediaAuthenticationRequest;
import net.java.slee.resource.diameter.cxdx.events.PushProfileAnswer;
import net.java.slee.resource.diameter.cxdx.events.PushProfileRequest;
import net.java.slee.resource.diameter.cxdx.events.RegistrationTerminationAnswer;
import net.java.slee.resource.diameter.cxdx.events.RegistrationTerminationRequest;
import net.java.slee.resource.diameter.cxdx.events.ServerAssignmentRequest;
import net.java.slee.resource.diameter.cxdx.events.UserAuthorizationRequest;
import org.jdiameter.api.Answer;
import org.jdiameter.api.EventListener;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.Request;
import org.jdiameter.api.Session;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.api.app.StateChangeListener;
import org.jdiameter.api.cxdx.ClientCxDxSession;
import org.jdiameter.api.cxdx.events.JLocationInfoRequest;
import org.jdiameter.api.cxdx.events.JMultimediaAuthRequest;
import org.jdiameter.api.cxdx.events.JPushProfileAnswer;
import org.jdiameter.api.cxdx.events.JRegistrationTerminationAnswer;
import org.jdiameter.api.cxdx.events.JServerAssignmentRequest;
import org.jdiameter.api.cxdx.events.JUserAuthorizationRequest;
import org.jdiameter.api.validation.AvpNotAllowedException;
import org.jdiameter.common.api.app.cxdx.CxDxSessionState;
import org.jdiameter.common.impl.app.cxdx.JLocationInfoRequestImpl;
import org.jdiameter.common.impl.app.cxdx.JMultimediaAuthRequestImpl;
import org.jdiameter.common.impl.app.cxdx.JPushProfileAnswerImpl;
import org.jdiameter.common.impl.app.cxdx.JRegistrationTerminationAnswerImpl;
import org.jdiameter.common.impl.app.cxdx.JServerAssignmentRequestImpl;
import org.jdiameter.common.impl.app.cxdx.JUserAuthorizationRequestImpl;
import org.mobicents.slee.resource.diameter.base.events.DiameterMessageImpl;
import org.mobicents.slee.resource.diameter.cxdx.CxDxSessionImpl;

public class CxDxClientSessionImpl
extends CxDxSessionImpl
implements CxDxClientSessionActivity {
    private static final long serialVersionUID = -2312531970361957314L;
    protected transient ClientCxDxSession appSession;

    public CxDxClientSessionImpl(CxDxMessageFactory messageFactory, CxDxAVPFactory avpFactory, ClientCxDxSession session, EventListener<Request, Answer> raEventListener, DiameterIdentity destinationHost, DiameterIdentity destinationRealm, SleeEndpoint endpoint) {
        super(messageFactory, avpFactory, (Session)session.getSessions().get(0), raEventListener, destinationHost, destinationRealm);
        this.setSession(session);
        super.setCurrentWorkingSession((Session)session.getSessions().get(0));
    }

    public void setSession(ClientCxDxSession session) {
        this.appSession = session;
        this.appSession.addStateChangeNotification((StateChangeListener)this);
    }

    public LocationInfoRequest createLocationInfoRequest() {
        LocationInfoRequest lir = this.cxdxMessageFactory.createLocationInfoRequest(super.getSessionId());
        this.fillSessionAVPs((DiameterMessage)lir);
        return lir;
    }

    public MultimediaAuthenticationRequest createMultimediaAuthenticationRequest() {
        MultimediaAuthenticationRequest mar = this.cxdxMessageFactory.createMultimediaAuthenticationRequest(super.getSessionId());
        this.fillSessionAVPs((DiameterMessage)mar);
        return mar;
    }

    public PushProfileAnswer createPushProfileAnswer() {
        if (!(this.lastRequest instanceof PushProfileRequest)) {
            logger.warn((Object)"Invalid type of answer for this activity.");
            return null;
        }
        try {
            PushProfileAnswer ppa = (PushProfileAnswer)this.cxdxMessageFactory.createCxDxMessage(this.lastRequest.getHeader(), new DiameterAvp[0], 305, this.cxdxMessageFactory.getApplicationId());
            this.fillSessionAVPs((DiameterMessage)ppa);
            return ppa;
        }
        catch (InternalException e) {
            logger.error((Object)"Failed to create Push-Profile-Answer.", (Throwable)e);
            return null;
        }
    }

    public RegistrationTerminationAnswer createRegistrationTerminationAnswer() {
        if (!(this.lastRequest instanceof RegistrationTerminationRequest)) {
            logger.warn((Object)"Invalid type of answer for this activity.");
            return null;
        }
        try {
            RegistrationTerminationAnswer rta = (RegistrationTerminationAnswer)this.cxdxMessageFactory.createCxDxMessage(this.lastRequest.getHeader(), new DiameterAvp[0], 304, this.cxdxMessageFactory.getApplicationId());
            this.fillSessionAVPs((DiameterMessage)rta);
            return rta;
        }
        catch (InternalException e) {
            logger.error((Object)"Failed to create Registration-Termination-Answer.", (Throwable)e);
            return null;
        }
    }

    public ServerAssignmentRequest createServerAssignmentRequest() {
        ServerAssignmentRequest sar = this.cxdxMessageFactory.createServerAssignmentRequest(super.getSessionId());
        this.fillSessionAVPs((DiameterMessage)sar);
        return sar;
    }

    public UserAuthorizationRequest createUserAuthorizationRequest() {
        UserAuthorizationRequest uar = this.cxdxMessageFactory.createUserAuthorizationRequest(super.getSessionId());
        this.fillSessionAVPs((DiameterMessage)uar);
        return uar;
    }

    public void sendLocationInfoRequest(LocationInfoRequest locationInfoRequest) throws IOException {
        try {
            DiameterMessageImpl msg = (DiameterMessageImpl)locationInfoRequest;
            this.appSession.sendLocationInformationRequest((JLocationInfoRequest)new JLocationInfoRequestImpl(msg.getGenericData()));
        }
        catch (AvpNotAllowedException anae) {
            throw new net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException(anae.getMessage(), anae.getAvpCode(), anae.getVendorId());
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public void sendMultimediaAuthenticationRequest(MultimediaAuthenticationRequest multimediaAuthenticationRequest) throws IOException {
        try {
            DiameterMessageImpl msg = (DiameterMessageImpl)multimediaAuthenticationRequest;
            this.appSession.sendMultimediaAuthRequest((JMultimediaAuthRequest)new JMultimediaAuthRequestImpl(msg.getGenericData()));
        }
        catch (AvpNotAllowedException anae) {
            throw new net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException(anae.getMessage(), anae.getAvpCode(), anae.getVendorId());
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public void sendPushProfileAnswer(PushProfileAnswer pushProfileAnswer) throws IOException {
        try {
            DiameterMessageImpl msg = (DiameterMessageImpl)pushProfileAnswer;
            this.appSession.sendPushProfileAnswer((JPushProfileAnswer)new JPushProfileAnswerImpl((Answer)msg.getGenericData()));
        }
        catch (AvpNotAllowedException anae) {
            throw new net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException(anae.getMessage(), anae.getAvpCode(), anae.getVendorId());
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public void sendRegistrationTerminationAnswer(RegistrationTerminationAnswer registrationTerminationAnswer) throws IOException {
        try {
            DiameterMessageImpl msg = (DiameterMessageImpl)registrationTerminationAnswer;
            this.appSession.sendRegistrationTerminationAnswer((JRegistrationTerminationAnswer)new JRegistrationTerminationAnswerImpl((Answer)msg.getGenericData()));
        }
        catch (AvpNotAllowedException anae) {
            throw new net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException(anae.getMessage(), anae.getAvpCode(), anae.getVendorId());
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public void sendServerAssignmentRequest(ServerAssignmentRequest serverAssignmentRequest) throws IOException {
        try {
            DiameterMessageImpl msg = (DiameterMessageImpl)serverAssignmentRequest;
            this.appSession.sendServerAssignmentRequest((JServerAssignmentRequest)new JServerAssignmentRequestImpl(msg.getGenericData()));
        }
        catch (AvpNotAllowedException anae) {
            throw new net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException(anae.getMessage(), anae.getAvpCode(), anae.getVendorId());
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public void sendUserAuthorizationRequest(UserAuthorizationRequest userAuthorizationRequest) throws IOException {
        try {
            DiameterMessageImpl msg = (DiameterMessageImpl)userAuthorizationRequest;
            this.appSession.sendUserAuthorizationRequest((JUserAuthorizationRequest)new JUserAuthorizationRequestImpl(msg.getGenericData()));
        }
        catch (AvpNotAllowedException anae) {
            throw new net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException(anae.getMessage(), anae.getAvpCode(), anae.getVendorId());
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public void stateChanged(Enum oldState, Enum newState) {
        if (!(this.terminated || newState != CxDxSessionState.TERMINATED && newState != CxDxSessionState.TIMEDOUT)) {
            this.terminated = true;
            this.setTerminateAfterProcessing(true);
            this.baseListener.startActivityRemoveTimer(this.getActivityHandle());
        }
    }

    public void stateChanged(AppSession arg0, Enum oldState, Enum newState) {
        this.stateChanged(oldState, newState);
    }

    public void endActivity() {
        if (this.appSession != null) {
            this.appSession.release();
        }
        super.endActivity();
    }
}

