/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.cxdx;

import java.io.IOException;
import net.java.slee.resource.diameter.base.events.DiameterMessage;
import net.java.slee.resource.diameter.base.events.avp.DiameterAvp;
import net.java.slee.resource.diameter.base.events.avp.DiameterIdentity;
import net.java.slee.resource.diameter.cxdx.CxDxAVPFactory;
import net.java.slee.resource.diameter.cxdx.CxDxMessageFactory;
import net.java.slee.resource.diameter.cxdx.CxDxServerSessionActivity;
import net.java.slee.resource.diameter.cxdx.events.LocationInfoAnswer;
import net.java.slee.resource.diameter.cxdx.events.LocationInfoRequest;
import net.java.slee.resource.diameter.cxdx.events.MultimediaAuthenticationAnswer;
import net.java.slee.resource.diameter.cxdx.events.MultimediaAuthenticationRequest;
import net.java.slee.resource.diameter.cxdx.events.PushProfileRequest;
import net.java.slee.resource.diameter.cxdx.events.RegistrationTerminationRequest;
import net.java.slee.resource.diameter.cxdx.events.ServerAssignmentAnswer;
import net.java.slee.resource.diameter.cxdx.events.ServerAssignmentRequest;
import net.java.slee.resource.diameter.cxdx.events.UserAuthorizationAnswer;
import net.java.slee.resource.diameter.cxdx.events.UserAuthorizationRequest;
import org.jdiameter.api.Answer;
import org.jdiameter.api.EventListener;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.Request;
import org.jdiameter.api.Session;
import org.jdiameter.api.Stack;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.api.app.StateChangeListener;
import org.jdiameter.api.cxdx.ServerCxDxSession;
import org.jdiameter.api.cxdx.events.JLocationInfoAnswer;
import org.jdiameter.api.cxdx.events.JMultimediaAuthAnswer;
import org.jdiameter.api.cxdx.events.JPushProfileRequest;
import org.jdiameter.api.cxdx.events.JRegistrationTerminationRequest;
import org.jdiameter.api.cxdx.events.JServerAssignmentAnswer;
import org.jdiameter.api.cxdx.events.JUserAuthorizationAnswer;
import org.jdiameter.api.validation.AvpNotAllowedException;
import org.jdiameter.common.api.app.cxdx.CxDxSessionState;
import org.jdiameter.common.impl.app.cxdx.JLocationInfoAnswerImpl;
import org.jdiameter.common.impl.app.cxdx.JMultimediaAuthAnswerImpl;
import org.jdiameter.common.impl.app.cxdx.JPushProfileRequestImpl;
import org.jdiameter.common.impl.app.cxdx.JRegistrationTerminationRequestImpl;
import org.jdiameter.common.impl.app.cxdx.JServerAssignmentAnswerImpl;
import org.jdiameter.common.impl.app.cxdx.JUserAuthorizationAnswerImpl;
import org.mobicents.slee.resource.diameter.base.events.DiameterMessageImpl;
import org.mobicents.slee.resource.diameter.cxdx.CxDxSessionImpl;

public class CxDxServerSessionImpl
extends CxDxSessionImpl
implements CxDxServerSessionActivity {
    private static final long serialVersionUID = 7518916596996009148L;
    protected transient ServerCxDxSession appSession;

    public CxDxServerSessionImpl(CxDxMessageFactory cxdxMessageFactory, CxDxAVPFactory cxdxAvpFactory, ServerCxDxSession session, EventListener<Request, Answer> raEventListener, DiameterIdentity destinationHost, DiameterIdentity destinationRealm, Stack stack) {
        super(cxdxMessageFactory, cxdxAvpFactory, (Session)session.getSessions().get(0), raEventListener, destinationHost, destinationRealm);
        this.setSession(session);
        super.setCurrentWorkingSession((Session)session.getSessions().get(0));
    }

    public void setSession(ServerCxDxSession session) {
        this.appSession = session;
        this.appSession.addStateChangeNotification((StateChangeListener)this);
    }

    public PushProfileRequest createPushProfileRequest() {
        PushProfileRequest ppr = this.cxdxMessageFactory.createPushProfileRequest(super.getSessionId());
        this.fillSessionAVPs((DiameterMessage)ppr);
        return ppr;
    }

    public RegistrationTerminationRequest createRegistrationTerminationRequest() {
        RegistrationTerminationRequest rtr = this.cxdxMessageFactory.createRegistrationTerminationRequest(super.getSessionId());
        this.fillSessionAVPs((DiameterMessage)rtr);
        return rtr;
    }

    public LocationInfoAnswer createLocationInfoAnswer() {
        if (!(this.lastRequest instanceof LocationInfoRequest)) {
            logger.warn((Object)"Invalid type of answer for this activity.");
            return null;
        }
        try {
            LocationInfoAnswer lia = (LocationInfoAnswer)this.cxdxMessageFactory.createCxDxMessage(this.lastRequest.getHeader(), new DiameterAvp[0], 302, this.cxdxMessageFactory.getApplicationId());
            this.fillSessionAVPs((DiameterMessage)lia);
            return lia;
        }
        catch (InternalException e) {
            logger.error((Object)"Failed to create Location-Info-Answer.", (Throwable)e);
            return null;
        }
    }

    public MultimediaAuthenticationAnswer createMultimediaAuthenticationAnswer() {
        if (!(this.lastRequest instanceof MultimediaAuthenticationRequest)) {
            logger.warn((Object)"Invalid type of answer for this activity.");
            return null;
        }
        try {
            MultimediaAuthenticationAnswer maa = (MultimediaAuthenticationAnswer)this.cxdxMessageFactory.createCxDxMessage(this.lastRequest.getHeader(), new DiameterAvp[0], 303, this.cxdxMessageFactory.getApplicationId());
            this.fillSessionAVPs((DiameterMessage)maa);
            return maa;
        }
        catch (InternalException e) {
            logger.error((Object)"Failed to create Multimedia-Authentication-Answer.", (Throwable)e);
            return null;
        }
    }

    public ServerAssignmentAnswer createServerAssignmentAnswer() {
        if (!(this.lastRequest instanceof ServerAssignmentRequest)) {
            logger.warn((Object)"Invalid type of answer for this activity.");
            return null;
        }
        try {
            ServerAssignmentAnswer saa = (ServerAssignmentAnswer)this.cxdxMessageFactory.createCxDxMessage(this.lastRequest.getHeader(), new DiameterAvp[0], 301, this.cxdxMessageFactory.getApplicationId());
            this.fillSessionAVPs((DiameterMessage)saa);
            return saa;
        }
        catch (InternalException e) {
            logger.error((Object)"Failed to create Server-Assignment-Answer.", (Throwable)e);
            return null;
        }
    }

    public UserAuthorizationAnswer createUserAuthorizationAnswer() {
        if (!(this.lastRequest instanceof UserAuthorizationRequest)) {
            logger.warn((Object)("Invalid type of answer for this activity. Type: " + this.lastRequest));
            return null;
        }
        try {
            UserAuthorizationAnswer uaa = (UserAuthorizationAnswer)this.cxdxMessageFactory.createCxDxMessage(this.lastRequest.getHeader(), new DiameterAvp[0], 300, this.cxdxMessageFactory.getApplicationId());
            this.fillSessionAVPs((DiameterMessage)uaa);
            return uaa;
        }
        catch (InternalException e) {
            logger.error((Object)"Failed to create User-Authorization-Answer.", (Throwable)e);
            return null;
        }
    }

    public void sendLocationInfoAnswer(LocationInfoAnswer locationInfoAnswer) throws IOException {
        DiameterMessageImpl msg = (DiameterMessageImpl)locationInfoAnswer;
        JLocationInfoAnswerImpl answer = new JLocationInfoAnswerImpl((Answer)msg.getGenericData());
        try {
            this.appSession.sendLocationInformationAnswer((JLocationInfoAnswer)answer);
        }
        catch (AvpNotAllowedException anae) {
            throw new net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException(anae.getMessage(), anae.getAvpCode(), anae.getVendorId());
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Failed to send message.", (Throwable)e);
            }
            throw new IOException(e.getMessage());
        }
    }

    public void sendMultimediaAuthenticationAnswer(MultimediaAuthenticationAnswer multimediaAuthenticationAnswer) throws IOException {
        DiameterMessageImpl msg = (DiameterMessageImpl)multimediaAuthenticationAnswer;
        JMultimediaAuthAnswerImpl answer = new JMultimediaAuthAnswerImpl((Answer)msg.getGenericData());
        try {
            this.appSession.sendMultimediaAuthAnswer((JMultimediaAuthAnswer)answer);
        }
        catch (AvpNotAllowedException anae) {
            throw new net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException(anae.getMessage(), anae.getAvpCode(), anae.getVendorId());
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Failed to send message.", (Throwable)e);
            }
            throw new IOException(e.getMessage());
        }
    }

    public void sendPushProfileRequest(PushProfileRequest pushProfileRequest) throws IOException {
        DiameterMessageImpl msg = (DiameterMessageImpl)pushProfileRequest;
        JPushProfileRequestImpl request = new JPushProfileRequestImpl(msg.getGenericData());
        try {
            this.appSession.sendPushProfileRequest((JPushProfileRequest)request);
        }
        catch (AvpNotAllowedException anae) {
            throw new net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException(anae.getMessage(), anae.getAvpCode(), anae.getVendorId());
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Failed to send message.", (Throwable)e);
            }
            throw new IOException(e.getMessage());
        }
    }

    public void sendRegistrationTerminationRequest(RegistrationTerminationRequest registrationTerminationRequest) throws IOException {
        DiameterMessageImpl msg = (DiameterMessageImpl)registrationTerminationRequest;
        JRegistrationTerminationRequestImpl request = new JRegistrationTerminationRequestImpl(msg.getGenericData());
        try {
            this.appSession.sendRegistrationTerminationRequest((JRegistrationTerminationRequest)request);
        }
        catch (AvpNotAllowedException anae) {
            throw new net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException(anae.getMessage(), anae.getAvpCode(), anae.getVendorId());
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Failed to send message.", (Throwable)e);
            }
            throw new IOException(e.getMessage());
        }
    }

    public void sendServerAssignmentAnswer(ServerAssignmentAnswer serverAssignmentAnswer) throws IOException {
        DiameterMessageImpl msg = (DiameterMessageImpl)serverAssignmentAnswer;
        JServerAssignmentAnswerImpl answer = new JServerAssignmentAnswerImpl((Answer)msg.getGenericData());
        try {
            this.appSession.sendServerAssignmentAnswer((JServerAssignmentAnswer)answer);
        }
        catch (AvpNotAllowedException anae) {
            throw new net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException(anae.getMessage(), anae.getAvpCode(), anae.getVendorId());
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Failed to send message.", (Throwable)e);
            }
            throw new IOException(e.getMessage());
        }
    }

    public void sendUserAuthorizationAnswer(UserAuthorizationAnswer userAuthorizationAnswer) throws IOException {
        DiameterMessageImpl msg = (DiameterMessageImpl)userAuthorizationAnswer;
        JUserAuthorizationAnswerImpl answer = new JUserAuthorizationAnswerImpl((Answer)msg.getGenericData());
        try {
            this.appSession.sendUserAuthorizationAnswer((JUserAuthorizationAnswer)answer);
        }
        catch (AvpNotAllowedException anae) {
            throw new net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException(anae.getMessage(), anae.getAvpCode(), anae.getVendorId());
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Failed to send message.", (Throwable)e);
            }
            throw new IOException(e.getMessage());
        }
    }

    public void stateChanged(Enum oldState, Enum newState) {
        if (!(this.terminated || newState != CxDxSessionState.TERMINATED && newState != CxDxSessionState.TIMEDOUT)) {
            this.terminated = true;
            this.setTerminateAfterProcessing(true);
            this.baseListener.startActivityRemoveTimer(this.getActivityHandle());
        }
    }

    public void stateChanged(AppSession arg0, Enum oldState, Enum newState) {
        this.stateChanged(oldState, newState);
    }

    public void endActivity() {
        if (this.appSession != null) {
            this.appSession.release();
        }
        super.endActivity();
    }
}

