/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.cxdx;

import java.util.ArrayList;
import net.java.slee.resource.diameter.base.events.DiameterMessage;
import net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException;
import net.java.slee.resource.diameter.base.events.avp.DiameterAvp;
import net.java.slee.resource.diameter.base.events.avp.DiameterIdentity;
import net.java.slee.resource.diameter.cxdx.CxDxAVPFactory;
import net.java.slee.resource.diameter.cxdx.CxDxMessageFactory;
import net.java.slee.resource.diameter.cxdx.CxDxSessionActivity;
import org.jdiameter.api.Answer;
import org.jdiameter.api.EventListener;
import org.jdiameter.api.Request;
import org.jdiameter.api.Session;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.api.app.StateChangeListener;
import org.mobicents.slee.resource.diameter.base.DiameterActivityImpl;
import org.mobicents.slee.resource.diameter.cxdx.CxDxMessageFactoryImpl;

public abstract class CxDxSessionImpl
extends DiameterActivityImpl
implements CxDxSessionActivity,
StateChangeListener<AppSession> {
    private static final long serialVersionUID = 4374137032596394588L;
    protected boolean terminated = false;
    protected transient CxDxMessageFactoryImpl cxdxMessageFactory = null;
    protected transient CxDxAVPFactory cxdxAvpFactory = null;
    protected transient DiameterMessage lastRequest = null;
    protected transient ArrayList<DiameterAvp> sessionAvps = new ArrayList();

    public CxDxSessionImpl(CxDxMessageFactory messageFactory, CxDxAVPFactory avpFactory, Session session, EventListener<Request, Answer> raEventListener, DiameterIdentity destinationHost, DiameterIdentity destinationRealm) {
        super(null, null, session, raEventListener, destinationHost, destinationRealm);
        this.cxdxMessageFactory = (CxDxMessageFactoryImpl)messageFactory;
        this.cxdxAvpFactory = avpFactory;
    }

    public CxDxAVPFactory getCxDxAvpFactory() {
        return this.cxdxAvpFactory;
    }

    public CxDxMessageFactory getCxDxMessageFactory() {
        return this.cxdxMessageFactory;
    }

    public void setCxDxMessageFactory(CxDxMessageFactoryImpl cxdxMessageFactory) {
        this.cxdxMessageFactory = cxdxMessageFactory;
    }

    public void setCxDxAvpFactory(CxDxAVPFactory cxdxAvpFactory) {
        this.cxdxAvpFactory = cxdxAvpFactory;
    }

    public String getSessionId() {
        return this.session.getSessionId();
    }

    public void fetchSessionData(DiameterMessage cxdxRequest) {
        this.lastRequest = cxdxRequest;
    }

    protected void fillSessionAVPs(DiameterMessage message) {
        if (message.getHeader().isRequest()) {
            if (this.destinationHost != null) {
                message.setDestinationHost(this.destinationHost);
            }
            if (this.destinationRealm != null) {
                message.setDestinationRealm(this.destinationRealm);
            }
        }
        if (this.sessionAvps.size() > 0) {
            try {
                message.setExtensionAvps(this.sessionAvps.toArray(new DiameterAvp[this.sessionAvps.size()]));
            }
            catch (AvpNotAllowedException e) {
                logger.error((Object)"Failed to add Session AVPs to request.", (Throwable)e);
            }
        }
        if (!message.hasSessionId() && this.sessionId != null) {
            message.setSessionId(this.sessionId);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.terminated ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        CxDxSessionImpl other = (CxDxSessionImpl)((Object)obj);
        return this.terminated == other.terminated;
    }
}

