/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.tools.maven.plugins.du;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployableUnitDescriptorMojo
extends AbstractMojo {
    private String duJarDirectory;
    private String duServiceDirectory;
    private File jarInputDirectory;
    private File serviceInputDirectory;
    private File duXmlOutputDirectory;
    private File workDirectory;

    public void execute() throws MojoExecutionException {
        this.setupDirectories();
        if (!this.duXmlOutputDirectory.exists()) {
            this.duXmlOutputDirectory.mkdirs();
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)"Collecting SLEE component jars...");
        }
        Set<String> jars = this.collectFiles(this.jarInputDirectory, ".jar");
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)"Collecting SLEE service descriptors...");
        }
        Set<String> services = this.collectFiles(this.serviceInputDirectory, ".xml");
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)"Generating JAIN SLEE 1.1 Deployable Unit XML descriptor...");
        }
        String xml = this.generateDuDescriptor(jars, services);
        File descriptor = new File(this.duXmlOutputDirectory, "deployable-unit.xml");
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(descriptor);
            fileWriter.write(xml);
            this.getLog().info((CharSequence)("Generated JAIN SLEE 1.1 Deployable Unit XML descriptor:\n" + xml));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating file " + descriptor, (Exception)e);
        }
        finally {
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private String generateDuDescriptor(Set<String> jars, Set<String> services) {
        StringBuilder sb = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<!DOCTYPE deployable-unit PUBLIC \"-//Sun Microsystems, Inc.//DTD JAIN SLEE Deployable Unit 1.1//EN\" \"http://java.sun.com/dtd/slee-deployable-unit_1_1.dtd\">\r\n<deployable-unit>\r\n");
        for (String jar : jars) {
            sb.append("\t<jar>");
            if (this.duJarDirectory == null) {
                sb.append(jar);
            } else {
                sb.append(this.duJarDirectory).append('/').append(jar);
            }
            sb.append("</jar>\r\n");
        }
        for (String service : services) {
            sb.append("\t<service-xml>");
            if (this.duServiceDirectory == null) {
                sb.append(service);
            } else {
                sb.append(this.duServiceDirectory).append('/').append(service);
            }
            sb.append("</service-xml>\r\n");
        }
        sb.append("</deployable-unit>");
        return sb.toString();
    }

    private void setupDirectories() {
        if (this.jarInputDirectory == null) {
            this.jarInputDirectory = this.duJarDirectory == null ? this.workDirectory : new File(this.workDirectory, this.duJarDirectory);
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Jar input directory: " + this.jarInputDirectory.getAbsolutePath()));
        }
        if (this.serviceInputDirectory == null) {
            this.serviceInputDirectory = this.duServiceDirectory == null ? this.workDirectory : new File(this.workDirectory, this.duServiceDirectory);
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Service input directory: " + this.serviceInputDirectory.getAbsolutePath()));
        }
        if (this.duXmlOutputDirectory == null) {
            this.duXmlOutputDirectory = new File(this.workDirectory, "META-INF");
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("XML output directory: " + this.duXmlOutputDirectory.getAbsolutePath()));
        }
    }

    private Set<String> collectFiles(File inputDirectory, String suffix) {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Collecting non hidden files with " + suffix + " name sufix from directory " + inputDirectory.getAbsolutePath()));
        }
        if (inputDirectory == null || !inputDirectory.exists() || !inputDirectory.isDirectory()) {
            return Collections.emptySet();
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Directory " + inputDirectory.getAbsolutePath() + " sucessfully validated."));
        }
        HashSet<String> result = new HashSet<String>();
        for (File f : inputDirectory.listFiles()) {
            if (f.isDirectory() || f.isHidden() || !f.getName().endsWith(suffix)) continue;
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Collecting file " + f.getName()));
            }
            result.add(f.getName());
        }
        return result;
    }
}

