/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.serialization.java;

import com.google.common.base.Strings;
import org.mockserver.client.serialization.java.ToJavaSerializer;
import org.mockserver.model.HttpCallback;

public class HttpCallbackToJavaSerializer
implements ToJavaSerializer<HttpCallback> {
    @Override
    public String serializeAsJava(int numberOfSpacesToIndent, HttpCallback httpCallback) {
        StringBuffer output = new StringBuffer();
        if (httpCallback != null) {
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append("callback()");
            if (httpCallback.getCallbackClass() != null) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(".withCallbackClass(\"").append(httpCallback.getCallbackClass()).append("\")");
            }
        }
        return output.toString();
    }

    private StringBuffer appendNewLineAndIndent(int numberOfSpacesToIndent, StringBuffer output) {
        return output.append(System.getProperty("line.separator")).append(Strings.padStart((String)"", (int)numberOfSpacesToIndent, (char)' '));
    }
}

