/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.serialization.serializers.response;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.mockserver.client.serialization.model.BinaryBodyDTO;
import org.mockserver.client.serialization.model.BodyDTO;
import org.mockserver.client.serialization.model.HttpResponseDTO;
import org.mockserver.client.serialization.model.JsonBodyDTO;
import org.mockserver.client.serialization.model.StringBodyDTO;

public class HttpResponseDTOSerializer
extends StdSerializer<HttpResponseDTO> {
    public HttpResponseDTOSerializer() {
        super(HttpResponseDTO.class);
    }

    public void serialize(HttpResponseDTO httpResponseDTO, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        BodyDTO body;
        jgen.writeStartObject();
        if (httpResponseDTO.getStatusCode() != null) {
            jgen.writeObjectField("statusCode", (Object)httpResponseDTO.getStatusCode());
        }
        if (httpResponseDTO.getHeaders() != null && !httpResponseDTO.getHeaders().isEmpty()) {
            jgen.writeObjectField("headers", httpResponseDTO.getHeaders());
        }
        if (httpResponseDTO.getCookies() != null && !httpResponseDTO.getCookies().isEmpty()) {
            jgen.writeObjectField("cookies", httpResponseDTO.getCookies());
        }
        if ((body = httpResponseDTO.getBody()) != null) {
            if (body instanceof StringBodyDTO && !((StringBodyDTO)body).getString().isEmpty()) {
                jgen.writeObjectField("body", (Object)body);
            } else if (body instanceof JsonBodyDTO && !((JsonBodyDTO)body).getJson().isEmpty()) {
                jgen.writeObjectField("body", (Object)((JsonBodyDTO)body).getJson());
            } else if (body instanceof BinaryBodyDTO) {
                jgen.writeObjectField("body", (Object)body);
            }
        }
        if (httpResponseDTO.getDelay() != null) {
            jgen.writeObjectField("delay", (Object)httpResponseDTO.getDelay());
        }
        if (httpResponseDTO.getConnectionOptions() != null) {
            jgen.writeObjectField("connectionOptions", (Object)httpResponseDTO.getConnectionOptions());
        }
        jgen.writeEndObject();
    }
}

