/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.filters;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.mockserver.client.serialization.ExpectationSerializer;
import org.mockserver.client.serialization.HttpRequestSerializer;
import org.mockserver.client.serialization.java.ExpectationToJavaSerializer;
import org.mockserver.collections.CircularLinkedList;
import org.mockserver.collections.CircularMultiMap;
import org.mockserver.filters.RequestFilter;
import org.mockserver.filters.ResponseFilter;
import org.mockserver.logging.LogFormatter;
import org.mockserver.matchers.HttpRequestMatcher;
import org.mockserver.matchers.MatcherBuilder;
import org.mockserver.matchers.TimeToLive;
import org.mockserver.matchers.Times;
import org.mockserver.mock.Expectation;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.verify.Verification;
import org.mockserver.verify.VerificationSequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogFilter
implements ResponseFilter,
RequestFilter {
    private static final Logger logger = LoggerFactory.getLogger(LogFilter.class);
    private final CircularMultiMap<HttpRequest, HttpResponse> requestResponseLog = new CircularMultiMap(100, 100);
    private final CircularLinkedList<HttpRequest> requestLog = new CircularLinkedList(100);
    private final MatcherBuilder matcherBuilder = new MatcherBuilder();
    private LogFormatter logFormatter = new LogFormatter(logger);
    private Logger requestLogger = LoggerFactory.getLogger((String)"REQUEST");
    private HttpRequestSerializer httpRequestSerializer = new HttpRequestSerializer();

    @Override
    public synchronized HttpResponse onResponse(HttpRequest httpRequest, HttpResponse httpResponse) {
        if (httpRequest != null && httpResponse != null) {
            this.requestResponseLog.put(httpRequest, httpResponse);
        } else if (httpRequest != null) {
            this.requestResponseLog.put(httpRequest, HttpResponse.notFoundResponse());
        }
        return httpResponse;
    }

    public synchronized HttpRequest onRequest(HttpRequest httpRequest) {
        this.requestLog.add(httpRequest);
        return httpRequest;
    }

    public synchronized List<HttpResponse> httpResponses(HttpRequest httpRequest) {
        ArrayList<HttpResponse> httpResponses = new ArrayList<HttpResponse>();
        HttpRequestMatcher httpRequestMatcher = this.matcherBuilder.transformsToMatcher(httpRequest);
        for (HttpRequest loggedHttpRequest : this.requestResponseLog.keySet()) {
            if (!httpRequestMatcher.matches(loggedHttpRequest)) continue;
            httpResponses.addAll(this.requestResponseLog.getAll(loggedHttpRequest));
        }
        return httpResponses;
    }

    public synchronized List<HttpRequest> httpRequests(HttpRequest httpRequest) {
        ArrayList<HttpRequest> httpRequests = new ArrayList<HttpRequest>();
        HttpRequestMatcher httpRequestMatcher = this.matcherBuilder.transformsToMatcher(httpRequest);
        for (HttpRequest loggedHttpRequest : this.requestLog) {
            if (!httpRequestMatcher.matches(loggedHttpRequest)) continue;
            httpRequests.add(loggedHttpRequest);
        }
        return httpRequests;
    }

    public synchronized void reset() {
        this.requestResponseLog.clear();
        this.requestLog.clear();
    }

    public synchronized void clear(HttpRequest httpRequest) {
        if (httpRequest != null) {
            HttpRequestMatcher httpRequestMatcher = this.matcherBuilder.transformsToMatcher(httpRequest);
            for (HttpRequest key : new LinkedList<HttpRequest>(this.requestResponseLog.keySet())) {
                if (!httpRequestMatcher.matches(key)) continue;
                this.requestResponseLog.removeAll(key);
            }
            for (HttpRequest value : new LinkedList<HttpRequest>(this.requestLog)) {
                if (!httpRequestMatcher.matches(value, true)) continue;
                this.requestLog.remove(value);
            }
        } else {
            this.reset();
        }
    }

    public synchronized void dumpToLog(HttpRequest httpRequest, boolean asJava) {
        ExpectationSerializer expectationSerializer = new ExpectationSerializer();
        ExpectationToJavaSerializer expectationToJavaSerializer = new ExpectationToJavaSerializer();
        if (httpRequest != null) {
            HttpRequestMatcher httpRequestMatcher = this.matcherBuilder.transformsToMatcher(httpRequest);
            for (Map.Entry<HttpRequest, HttpResponse> entry : this.requestResponseLog.entrySet()) {
                if (!httpRequestMatcher.matches(entry.getKey(), true)) continue;
                if (asJava) {
                    this.requestLogger.warn(expectationToJavaSerializer.serializeAsJava(0, new Expectation(entry.getKey(), Times.once(), TimeToLive.unlimited()).thenRespond(entry.getValue())));
                    continue;
                }
                this.requestLogger.warn(expectationSerializer.serialize(new Expectation(entry.getKey(), Times.once(), TimeToLive.unlimited()).thenRespond(entry.getValue())));
            }
        } else {
            for (Map.Entry<HttpRequest, HttpResponse> entry : this.requestResponseLog.entrySet()) {
                if (asJava) {
                    this.requestLogger.warn(expectationToJavaSerializer.serializeAsJava(0, new Expectation(entry.getKey(), Times.once(), TimeToLive.unlimited()).thenRespond(entry.getValue())));
                    continue;
                }
                this.requestLogger.warn(expectationSerializer.serialize(new Expectation(entry.getKey(), Times.once(), TimeToLive.unlimited()).thenRespond(entry.getValue())));
            }
        }
    }

    public synchronized HttpRequest[] retrieve(HttpRequest httpRequestToMatch) {
        ArrayList<HttpRequest> matchingRequests = new ArrayList<HttpRequest>();
        if (httpRequestToMatch != null) {
            HttpRequestMatcher httpRequestMatcher = this.matcherBuilder.transformsToMatcher(httpRequestToMatch);
            for (HttpRequest httpRequest : this.requestLog) {
                if (!httpRequestMatcher.matches(httpRequest, true)) continue;
                matchingRequests.add(httpRequest);
            }
        } else {
            for (HttpRequest httpRequest : this.requestLog) {
                matchingRequests.add(httpRequest);
            }
        }
        return matchingRequests.toArray(new HttpRequest[matchingRequests.size()]);
    }

    public synchronized String verify(Verification verification) {
        String failureMessage = "";
        if (verification != null) {
            ArrayList<HttpRequest> matchingRequests = new ArrayList<HttpRequest>();
            if (verification.getHttpRequest() != null) {
                HttpRequestMatcher httpRequestMatcher = this.matcherBuilder.transformsToMatcher(verification.getHttpRequest());
                for (HttpRequest httpRequest : this.requestLog) {
                    if (!httpRequestMatcher.matches(httpRequest, true)) continue;
                    matchingRequests.add(httpRequest);
                }
            }
            boolean verified = true;
            if (verification.getTimes().getCount() != 0 && matchingRequests.isEmpty()) {
                verified = false;
            } else if (verification.getTimes().isExact() && matchingRequests.size() != verification.getTimes().getCount()) {
                verified = false;
            } else if (matchingRequests.size() < verification.getTimes().getCount()) {
                verified = false;
            }
            if (!verified) {
                HttpRequest[] allRequestsArray = this.requestLog.toArray(new HttpRequest[this.requestLog.size()]);
                String serializedRequestToBeVerified = this.httpRequestSerializer.serialize(verification.getHttpRequest());
                String serializedAllRequestInLog = allRequestsArray.length == 1 ? this.httpRequestSerializer.serialize(allRequestsArray[0]) : this.httpRequestSerializer.serialize(allRequestsArray);
                this.logFormatter.infoLog("request not found " + verification.getTimes() + ", expected:{}" + System.getProperty("line.separator") + " but was:{}", serializedRequestToBeVerified, serializedAllRequestInLog);
                failureMessage = "Request not found " + verification.getTimes() + ", expected:<" + serializedRequestToBeVerified + "> but was:<" + serializedAllRequestInLog + ">";
            }
        }
        return failureMessage;
    }

    public String verify(VerificationSequence verificationSequence) {
        String failureMessage = "";
        if (verificationSequence != null) {
            int requestLogCounter = 0;
            for (HttpRequest verificationHttpRequest : verificationSequence.getHttpRequests()) {
                if (verificationHttpRequest == null) continue;
                HttpRequestMatcher httpRequestMatcher = this.matcherBuilder.transformsToMatcher(verificationHttpRequest);
                boolean foundRequest = false;
                while (!foundRequest && requestLogCounter < this.requestLog.size()) {
                    if (httpRequestMatcher.matches((HttpRequest)this.requestLog.get(requestLogCounter), true)) {
                        foundRequest = true;
                    }
                    ++requestLogCounter;
                }
                if (foundRequest) continue;
                String serializedRequestToBeVerified = this.httpRequestSerializer.serialize(verificationSequence.getHttpRequests());
                String serializedAllRequestInLog = this.httpRequestSerializer.serialize(this.requestLog);
                failureMessage = "Request sequence not found, expected:<" + serializedRequestToBeVerified + "> but was:<" + serializedAllRequestInLog + ">";
                this.logFormatter.infoLog("request sequence not found, expected:{}" + System.getProperty("line.separator") + " but was:{}", serializedRequestToBeVerified, serializedAllRequestInLog);
                break;
            }
        }
        return failureMessage;
    }
}

