/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.mockserver.model.ObjectWithReflectiveEqualsHashCodeToString;

public class TimeToLive
extends ObjectWithReflectiveEqualsHashCodeToString {
    private final TimeUnit timeUnit;
    private final Long timeToLive;
    private final boolean unlimited;
    private final DateTime createdDate;
    private DateTime endDate;

    private TimeToLive(TimeUnit timeUnit, Long timeToLive, boolean unlimited) {
        this.addFieldsExcludedFromEqualsAndHashCode("createdDate", "endDate");
        this.timeUnit = timeUnit;
        this.timeToLive = timeToLive;
        this.unlimited = unlimited;
        this.createdDate = DateTime.now();
        if (!unlimited) {
            this.endDate = DateTime.now().plus(timeUnit.toMillis(timeToLive));
        }
    }

    public static TimeToLive unlimited() {
        return new TimeToLive(null, null, true);
    }

    public static TimeToLive exactly(TimeUnit timeUnit, Long timeToLive) {
        return new TimeToLive(timeUnit, timeToLive, false);
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public Long getTimeToLive() {
        return this.timeToLive;
    }

    public boolean isUnlimited() {
        return this.unlimited;
    }

    public boolean stillAlive() {
        if (this.unlimited || this.endDate.isAfterNow()) {
            return true;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Remaining time is " + (this.endDate.getMillis() - this.createdDate.getMillis()) + "ms");
        }
        return false;
    }
}

