/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.netty;

import com.google.common.util.concurrent.SettableFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import org.mockserver.model.HttpResponse;

public class HttpClientHandler
extends SimpleChannelInboundHandler<HttpResponse> {
    private final SettableFuture<HttpResponse> responseFuture = SettableFuture.create();

    public SettableFuture<HttpResponse> getResponseFuture() {
        return this.responseFuture;
    }

    public HttpClientHandler() {
        super(false);
    }

    public void channelRead0(ChannelHandlerContext ctx, HttpResponse response) {
        this.responseFuture.set((Object)response);
        ctx.close();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        cause.printStackTrace();
        this.responseFuture.setException(cause);
        ctx.close();
    }
}

