/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.netty;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.mockserver.client.netty.HttpClientInitializer;
import org.mockserver.client.netty.SocketCommunicationException;
import org.mockserver.client.netty.SocketConnectionException;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.OutboundHttpRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyHttpClient {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public HttpResponse sendRequest(final OutboundHttpRequest httpRequest) throws SocketConnectionException {
        this.logger.debug("Sending request: {}", (Object)httpRequest);
        NioEventLoopGroup group = new NioEventLoopGroup();
        try {
            final HttpClientInitializer channelInitializer = new HttpClientInitializer(httpRequest.isSecure());
            ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)group)).channel(NioSocketChannel.class)).handler((ChannelHandler)channelInitializer)).connect(httpRequest.getHost(), httpRequest.getPort().intValue()).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (future.isSuccess()) {
                        future.channel().writeAndFlush((Object)httpRequest);
                    } else {
                        channelInitializer.getResponseFuture().setException(future.cause());
                    }
                }
            });
            HttpResponse httpResponse = (HttpResponse)channelInitializer.getResponseFuture().get();
            this.logger.debug("Received response: {}", (Object)httpResponse);
            group.shutdownGracefully(0L, 1L, TimeUnit.MILLISECONDS);
            HttpResponse httpResponse2 = httpResponse;
            return httpResponse2;
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof ConnectException) {
                throw new SocketConnectionException("Unable to connect to socket " + httpRequest.getHost() + ":" + httpRequest.getPort(), e.getCause());
            }
            if (e.getCause() instanceof UnknownHostException) {
                throw new SocketConnectionException("Unable to resolve host " + httpRequest.getHost(), e.getCause());
            }
            if (e.getCause() instanceof IOException) {
                throw new SocketCommunicationException("Error while communicating to " + httpRequest.getHost() + ":" + httpRequest.getPort(), e.getCause());
            }
            throw new RuntimeException("Exception while sending request", e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Exception while sending request", e);
        }
        finally {
            group.shutdownGracefully(0L, 1L, TimeUnit.MILLISECONDS);
        }
    }
}

