/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.echo;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import org.mockserver.server.unification.PortUnificationHandler;

@ChannelHandler.Sharable
public class EchoServerUnificationHandler
extends PortUnificationHandler {
    @Override
    protected void configurePipeline(ChannelHandlerContext ctx, ChannelPipeline pipeline) {
        pipeline.addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<FullHttpRequest>(){

            protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest request) {
                HttpResponseStatus responseStatus = HttpResponseStatus.OK;
                if (request.getUri().equals("/not_found")) {
                    responseStatus = HttpResponseStatus.NOT_FOUND;
                }
                DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, responseStatus, Unpooled.copiedBuffer((ByteBuf)request.content()));
                response.headers().add(request.headers());
                response.headers().set("Content-Length", (Object)response.content().readableBytes());
                if (HttpHeaders.isKeepAlive((HttpMessage)request)) {
                    response.headers().set("Connection", (Object)"keep-alive");
                }
                if (HttpHeaders.is100ContinueExpected((HttpMessage)request)) {
                    ctx.write((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE));
                }
                ctx.writeAndFlush((Object)response);
            }

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                cause.printStackTrace();
                ctx.close();
            }
        }});
    }
}

