/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.filters;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.mockserver.client.serialization.ExpectationSerializer;
import org.mockserver.client.serialization.HttpRequestSerializer;
import org.mockserver.collections.CircularLinkedList;
import org.mockserver.collections.CircularMultiMap;
import org.mockserver.filters.RequestFilter;
import org.mockserver.filters.ResponseFilter;
import org.mockserver.matchers.HttpRequestMatcher;
import org.mockserver.matchers.MatcherBuilder;
import org.mockserver.matchers.Times;
import org.mockserver.mock.Expectation;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.verify.Verification;
import org.mockserver.verify.VerificationSequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogFilter
implements ResponseFilter,
RequestFilter {
    private final CircularMultiMap<HttpRequest, HttpResponse> requestResponseLog = new CircularMultiMap(100, 100);
    private final CircularLinkedList<HttpRequest> requestLog = new CircularLinkedList(100);
    private final MatcherBuilder matcherBuilder = new MatcherBuilder();
    private Logger requestLogger = LoggerFactory.getLogger((String)"REQUEST");
    private HttpRequestSerializer httpRequestSerializer = new HttpRequestSerializer();

    @Override
    public synchronized HttpResponse onResponse(HttpRequest httpRequest, HttpResponse httpResponse) {
        if (httpRequest != null && httpResponse != null) {
            this.requestResponseLog.put(httpRequest, httpResponse);
        } else if (httpRequest != null) {
            this.requestResponseLog.put(httpRequest, HttpResponse.notFoundResponse());
        }
        return httpResponse;
    }

    public synchronized HttpRequest onRequest(HttpRequest httpRequest) {
        this.requestLog.add(httpRequest);
        return httpRequest;
    }

    public synchronized List<HttpResponse> httpResponses(HttpRequest httpRequest) {
        ArrayList<HttpResponse> httpResponses = new ArrayList<HttpResponse>();
        HttpRequestMatcher httpRequestMatcher = this.matcherBuilder.transformsToMatcher(httpRequest);
        for (HttpRequest loggedHttpRequest : this.requestResponseLog.keySet()) {
            if (!httpRequestMatcher.matches(loggedHttpRequest)) continue;
            httpResponses.addAll(this.requestResponseLog.getAll(loggedHttpRequest));
        }
        return httpResponses;
    }

    public synchronized List<HttpRequest> httpRequests(HttpRequest httpRequest) {
        ArrayList<HttpRequest> httpRequests = new ArrayList<HttpRequest>();
        HttpRequestMatcher httpRequestMatcher = this.matcherBuilder.transformsToMatcher(httpRequest);
        for (HttpRequest loggedHttpRequest : this.requestLog) {
            if (!httpRequestMatcher.matches(loggedHttpRequest)) continue;
            httpRequests.add(loggedHttpRequest);
        }
        return httpRequests;
    }

    public synchronized void reset() {
        this.requestResponseLog.clear();
        this.requestLog.clear();
    }

    public synchronized void clear(HttpRequest httpRequest) {
        if (httpRequest != null) {
            HttpRequestMatcher httpRequestMatcher = this.matcherBuilder.transformsToMatcher(httpRequest);
            for (HttpRequest key : new LinkedList<HttpRequest>(this.requestResponseLog.keySet())) {
                if (!httpRequestMatcher.matches(key)) continue;
                this.requestResponseLog.removeAll(key);
            }
            for (HttpRequest value : new LinkedList<HttpRequest>(this.requestLog)) {
                if (!httpRequestMatcher.matches(value)) continue;
                this.requestLog.remove(value);
            }
        } else {
            this.reset();
        }
    }

    public synchronized void dumpToLog(HttpRequest httpRequest, boolean asJava) {
        ExpectationSerializer expectationSerializer = new ExpectationSerializer();
        if (httpRequest != null) {
            HttpRequestMatcher httpRequestMatcher = this.matcherBuilder.transformsToMatcher(httpRequest);
            for (Map.Entry<HttpRequest, HttpResponse> entry : this.requestResponseLog.entrySet()) {
                if (!httpRequestMatcher.matches(entry.getKey())) continue;
                if (asJava) {
                    this.requestLogger.warn(expectationSerializer.serializeAsJava(new Expectation(entry.getKey(), Times.once()).thenRespond(entry.getValue())));
                    continue;
                }
                this.requestLogger.warn(expectationSerializer.serialize(new Expectation(entry.getKey(), Times.once()).thenRespond(entry.getValue())));
            }
        } else {
            for (Map.Entry<HttpRequest, HttpResponse> entry : this.requestResponseLog.entrySet()) {
                if (asJava) {
                    this.requestLogger.warn(expectationSerializer.serializeAsJava(new Expectation(entry.getKey(), Times.once()).thenRespond(entry.getValue())));
                    continue;
                }
                this.requestLogger.warn(expectationSerializer.serialize(new Expectation(entry.getKey(), Times.once()).thenRespond(entry.getValue())));
            }
        }
    }

    public synchronized Expectation[] retrieve(HttpRequest httpRequest) {
        ArrayList<Expectation> expectations = new ArrayList<Expectation>();
        if (httpRequest != null) {
            HttpRequestMatcher httpRequestMatcher = this.matcherBuilder.transformsToMatcher(httpRequest);
            for (HttpRequest key : this.requestResponseLog.keySet()) {
                for (HttpResponse value : this.requestResponseLog.getAll(key)) {
                    if (!httpRequestMatcher.matches(key)) continue;
                    expectations.add(new Expectation(key, Times.once()).thenRespond(value));
                }
            }
        } else {
            for (HttpRequest key : this.requestResponseLog.keySet()) {
                for (HttpResponse value : this.requestResponseLog.getAll(key)) {
                    expectations.add(new Expectation(key, Times.once()).thenRespond(value));
                }
            }
        }
        return expectations.toArray(new Expectation[expectations.size()]);
    }

    public synchronized String verify(Verification verification) {
        if (verification != null) {
            ArrayList<HttpRequest> matchingRequests = new ArrayList<HttpRequest>();
            if (verification.getHttpRequest() != null) {
                HttpRequestMatcher httpRequestMatcher = this.matcherBuilder.transformsToMatcher(verification.getHttpRequest());
                for (HttpRequest httpRequest : this.requestLog) {
                    if (!httpRequestMatcher.matches(httpRequest)) continue;
                    matchingRequests.add(httpRequest);
                }
            }
            HttpRequest[] allRequestsArray = this.requestLog.toArray(new HttpRequest[this.requestLog.size()]);
            if (verification.getTimes().getCount() != 0 && matchingRequests.isEmpty()) {
                return "Request not found " + verification.getTimes() + ", expected:<" + this.httpRequestSerializer.serialize(verification.getHttpRequest()) + "> but was:<" + (allRequestsArray.length == 1 ? this.httpRequestSerializer.serialize(allRequestsArray[0]) : this.httpRequestSerializer.serialize(allRequestsArray)) + ">";
            }
            if (verification.getTimes().isExact() ? matchingRequests.size() != verification.getTimes().getCount() : matchingRequests.size() < verification.getTimes().getCount()) {
                return "Request not found " + verification.getTimes() + ", expected:<" + this.httpRequestSerializer.serialize(verification.getHttpRequest()) + "> but was:<" + (allRequestsArray.length == 1 ? this.httpRequestSerializer.serialize(allRequestsArray[0]) : this.httpRequestSerializer.serialize(allRequestsArray)) + ">";
            }
        }
        return "";
    }

    public String verify(VerificationSequence verificationSequence) {
        if (verificationSequence != null) {
            int requestLogCounter = 0;
            for (HttpRequest verificationHttpRequest : verificationSequence.getHttpRequests()) {
                if (verificationHttpRequest == null) continue;
                HttpRequestMatcher httpRequestMatcher = this.matcherBuilder.transformsToMatcher(verificationHttpRequest);
                boolean foundRequest = false;
                while (!foundRequest && requestLogCounter < this.requestLog.size()) {
                    if (httpRequestMatcher.matches((HttpRequest)this.requestLog.get(requestLogCounter))) {
                        foundRequest = true;
                    }
                    ++requestLogCounter;
                }
                if (foundRequest) continue;
                return "Request sequence not found, expected:<" + this.httpRequestSerializer.serialize(verificationSequence.getHttpRequests()) + "> but was:<" + this.httpRequestSerializer.serialize(this.requestLog) + ">";
            }
        }
        return "";
    }
}

