/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.mockserver.model.BinaryBody;
import org.mockserver.model.Body;
import org.mockserver.model.Cookie;
import org.mockserver.model.Header;
import org.mockserver.model.ObjectWithJsonToString;
import org.mockserver.model.Parameter;
import org.mockserver.model.StringBody;

public class HttpRequest
extends ObjectWithJsonToString {
    String method = "";
    String path = "";
    Map<String, Parameter> queryStringParameters = new LinkedHashMap<String, Parameter>();
    Body body = null;
    Map<String, Header> headers = new LinkedHashMap<String, Header>();
    Map<String, Cookie> cookies = new LinkedHashMap<String, Cookie>();
    boolean isKeepAlive = false;
    boolean secure;

    public static HttpRequest request() {
        return new HttpRequest();
    }

    public static HttpRequest request(String path) {
        return new HttpRequest().withPath(path);
    }

    @JsonIgnore
    public boolean isKeepAlive() {
        return this.isKeepAlive;
    }

    public HttpRequest setKeepAlive(boolean isKeepAlive) {
        this.isKeepAlive = isKeepAlive;
        return this;
    }

    @JsonIgnore
    public boolean isSecure() {
        return this.secure;
    }

    public HttpRequest setSecure(boolean secure) {
        this.secure = secure;
        return this;
    }

    public HttpRequest withMethod(String method) {
        this.method = method;
        return this;
    }

    public String getMethod() {
        return this.method;
    }

    public String getMethod(String defaultValue) {
        if (Strings.isNullOrEmpty((String)this.method)) {
            return defaultValue;
        }
        return this.getMethod();
    }

    public String getPath() {
        return this.path;
    }

    public HttpRequest withPath(String path) {
        this.path = path;
        return this;
    }

    public boolean matches(String method, String path) {
        return this.method.equals(method) && this.path.equals(path);
    }

    public HttpRequest withQueryStringParameters(List<Parameter> parameters) {
        this.queryStringParameters.clear();
        for (Parameter parameter : parameters) {
            this.withQueryStringParameter(parameter);
        }
        return this;
    }

    public HttpRequest withQueryStringParameters(Parameter ... parameters) {
        return this.withQueryStringParameters(Arrays.asList(parameters));
    }

    public HttpRequest withQueryStringParameters(Map<String, List<String>> parameters) {
        this.queryStringParameters.clear();
        for (String name : parameters.keySet()) {
            for (String value : parameters.get(name)) {
                this.withQueryStringParameter(new Parameter(name, value));
            }
        }
        return this;
    }

    public HttpRequest withQueryStringParameter(Parameter parameter) {
        if (this.queryStringParameters.containsKey(parameter.getName())) {
            this.queryStringParameters.get(parameter.getName()).addValues(parameter.getValues());
        } else {
            this.queryStringParameters.put(parameter.getName(), parameter);
        }
        return this;
    }

    public List<Parameter> getQueryStringParameters() {
        return new ArrayList<Parameter>(this.queryStringParameters.values());
    }

    public boolean hasQueryStringParameter(String name, String expectedValue) {
        if (Strings.isNullOrEmpty((String)name)) {
            throw new IllegalArgumentException("Name must not be null or empty");
        }
        if (expectedValue == null) {
            throw new IllegalArgumentException("Expected value must not be null");
        }
        Parameter parameter = this.queryStringParameters.get(name);
        if (parameter != null) {
            for (String actualValue : parameter.getValues()) {
                if (!expectedValue.equals(actualValue)) continue;
                return true;
            }
        }
        return false;
    }

    public HttpRequest withBody(String body) {
        this.body = new StringBody(body, Body.Type.STRING);
        return this;
    }

    public HttpRequest withBody(byte[] body) {
        this.body = new BinaryBody(body);
        return this;
    }

    public HttpRequest withBody(Body body) {
        this.body = body;
        return this;
    }

    public Body getBody() {
        return this.body;
    }

    @JsonIgnore
    public byte[] getBodyAsRawBytes() {
        return this.body != null ? this.body.getRawBytes() : new byte[]{};
    }

    @JsonIgnore
    public String getBodyAsString() {
        return this.body != null ? new String(this.body.getRawBytes(), Charsets.UTF_8) : "";
    }

    public HttpRequest withHeaders(List<Header> headers) {
        this.headers.clear();
        for (Header header : headers) {
            this.withHeader(header);
        }
        return this;
    }

    public HttpRequest withHeaders(Header ... headers) {
        if (headers != null) {
            this.withHeaders(Arrays.asList(headers));
        }
        return this;
    }

    public HttpRequest withHeader(Header header) {
        if (this.headers.containsKey(header.getName())) {
            this.headers.get(header.getName()).addValues(header.getValues());
        } else {
            this.headers.put(header.getName(), header);
        }
        return this;
    }

    public HttpRequest replaceHeader(Header header) {
        for (String key : new HashSet<String>(this.headers.keySet())) {
            if (!header.getName().equalsIgnoreCase(key)) continue;
            this.headers.remove(key);
        }
        this.headers.put(header.getName(), header);
        return this;
    }

    public List<Header> getHeaders() {
        return new ArrayList<Header>(this.headers.values());
    }

    public String getFirstHeader(String name) {
        String firstHeadValue = "";
        if (this.headers.containsKey(name) || this.headers.containsKey(name.toLowerCase())) {
            Header header = this.headers.get(name);
            if (header == null) {
                header = this.headers.get(name.toLowerCase());
            }
            if (!header.getValues().isEmpty() && !Strings.isNullOrEmpty((String)header.getValues().get(0))) {
                firstHeadValue = header.getValues().get(0);
            }
        }
        return firstHeadValue;
    }

    public boolean containsHeader(String name) {
        return this.headers.containsKey(name);
    }

    public HttpRequest withCookies(List<Cookie> cookies) {
        this.cookies.clear();
        for (Cookie cookie : cookies) {
            this.withCookie(cookie);
        }
        return this;
    }

    public HttpRequest withCookies(Cookie ... cookies) {
        if (cookies != null) {
            this.withCookies(Arrays.asList(cookies));
        }
        return this;
    }

    public HttpRequest withCookie(Cookie cookie) {
        this.cookies.put(cookie.getName(), cookie);
        return this;
    }

    public List<Cookie> getCookies() {
        return new ArrayList<Cookie>(this.cookies.values());
    }
}

