/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.collections;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.mockserver.collections.ImmutableEntry;
import org.mockserver.collections.SubSets;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.RegexStringMatcher;
import org.mockserver.model.NottableString;
import org.slf4j.event.Level;

public class CaseInsensitiveRegexHashMap
extends LinkedHashMap<NottableString, NottableString>
implements Map<NottableString, NottableString> {
    private final RegexStringMatcher regexStringMatcher;
    private final MockServerLogger mockServerLogger;
    private boolean noOptionals = true;

    public CaseInsensitiveRegexHashMap(MockServerLogger mockServerLogger, boolean controlPlaneMatcher) {
        this.mockServerLogger = mockServerLogger;
        this.regexStringMatcher = new RegexStringMatcher(mockServerLogger, controlPlaneMatcher);
    }

    @VisibleForTesting
    public static CaseInsensitiveRegexHashMap hashMap(boolean controlPlaneMatcher, String[] ... keyAndValues) {
        CaseInsensitiveRegexHashMap hashMap = new CaseInsensitiveRegexHashMap(new MockServerLogger(), controlPlaneMatcher);
        for (String[] keyAndValue : keyAndValues) {
            if (keyAndValue.length < 2) continue;
            hashMap.put(keyAndValue[0], keyAndValue[1]);
        }
        return hashMap;
    }

    @VisibleForTesting
    public static CaseInsensitiveRegexHashMap hashMap(boolean controlPlaneMatcher, NottableString[] ... keyAndValues) {
        CaseInsensitiveRegexHashMap hashMap = new CaseInsensitiveRegexHashMap(new MockServerLogger(), controlPlaneMatcher);
        for (NottableString[] keyAndValue : keyAndValues) {
            if (keyAndValue.length < 2) continue;
            hashMap.put(keyAndValue[0], keyAndValue[1]);
        }
        return hashMap;
    }

    public boolean isNoOptionals() {
        return this.noOptionals;
    }

    public boolean containsAll(CaseInsensitiveRegexHashMap matcher) {
        return this.containsAll(matcher, null);
    }

    public boolean containsAll(CaseInsensitiveRegexHashMap matcher, String logCorrelationId) {
        List<ImmutableEntry> matchedEntries = this.entryList();
        Multimap<Integer, List<ImmutableEntry>> allMatchedSubSets = SubSets.distinctSubSetsMap(matchedEntries, ArrayListMultimap.create(), matchedEntries.size() - 1);
        if (MockServerLogger.isEnabled(Level.TRACE)) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setCorrelationId(logCorrelationId).setMessageFormat("attempting to match subset from{}against hashmap{}").setArguments(allMatchedSubSets, matcher.entryList()));
        }
        if (this.isEmpty() && matcher.allKeysNotted()) {
            return true;
        }
        if (this.noOptionals && matcher.isNoOptionals()) {
            List<ImmutableEntry> matcherEntries = matcher.entryList();
            for (List matchedSubSet : allMatchedSubSets.get((Object)matcherEntries.size())) {
                if (!ImmutableEntry.listsEqual(matcherEntries, matchedSubSet)) continue;
                if (MockServerLogger.isEnabled(Level.TRACE)) {
                    this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setCorrelationId(logCorrelationId).setMessageFormat("hashmap{}containsAll subset{}in{}").setArguments(this, matchedSubSet, matcherEntries));
                }
                return true;
            }
            if (MockServerLogger.isEnabled(Level.TRACE)) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setCorrelationId(logCorrelationId).setMessageFormat("hashmap{}containsAll found no subset equal to{}from{}").setArguments(this, matcherEntries, allMatchedSubSets));
            }
        } else {
            boolean result = false;
            List matcherEntriesWithoutOptionals = matcher.entryList().stream().filter(entry -> !((NottableString)entry.getKey()).isOptional()).collect(Collectors.toList());
            for (Collection<ImmutableEntry> matchedSubSet : allMatchedSubSets.get((Object)matcherEntriesWithoutOptionals.size())) {
                if (!ImmutableEntry.listsEqual(matcherEntriesWithoutOptionals, matchedSubSet)) continue;
                if (MockServerLogger.isEnabled(Level.TRACE)) {
                    this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setCorrelationId(logCorrelationId).setMessageFormat("hashmap{}containsAll subset of non-optionals{}in{}").setArguments(this, matchedSubSet, matcherEntriesWithoutOptionals));
                }
                result = true;
            }
            if (result) {
                List optionalMatcherEntries = matcher.entryList().stream().filter(entry -> ((NottableString)entry.getKey()).isOptional()).collect(Collectors.toList());
                if (!optionalMatcherEntries.isEmpty()) {
                    Collection<ImmutableEntry> matchedSubSet;
                    matchedSubSet = new HashSet();
                    for (ImmutableEntry optionalMatcherEntry : optionalMatcherEntries) {
                        for (ImmutableEntry matchedEntry : matchedEntries) {
                            if (optionalMatcherEntry.equals(matchedEntry)) {
                                matchedSubSet.add(matchedEntry);
                                continue;
                            }
                            if (MockServerLogger.isEnabled(Level.TRACE)) {
                                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setCorrelationId(logCorrelationId).setMessageFormat("hashmap{}failed to match optional{}with{}").setArguments(this, optionalMatcherEntry, matchedEntry));
                            }
                            return false;
                        }
                    }
                    if (MockServerLogger.isEnabled(Level.TRACE)) {
                        this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setCorrelationId(logCorrelationId).setMessageFormat("hashmap{}containsAll subset of optionals{}in{}").setArguments(this, matchedSubSet, optionalMatcherEntries));
                    }
                    return true;
                }
                return true;
            }
            if (MockServerLogger.isEnabled(Level.TRACE)) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setCorrelationId(logCorrelationId).setMessageFormat("hashmap{}containsAll found no subset equal to{}from{}").setArguments(this, matcher.entryList(), matchedEntries));
            }
        }
        return false;
    }

    public boolean allKeysNotted() {
        for (NottableString key : this.keySet()) {
            if (key.isNot()) continue;
            return false;
        }
        return true;
    }

    public boolean allKeysOptional() {
        for (NottableString key : this.keySet()) {
            if (key.isOptional()) continue;
            return false;
        }
        return true;
    }

    public synchronized boolean containsKeyValue(String key, String value) {
        return this.containsKeyValue(NottableString.string(key), NottableString.string(value));
    }

    public synchronized boolean containsKeyValue(NottableString key, NottableString value) {
        boolean result = false;
        for (Map.Entry matcherEntry : this.entrySet()) {
            if (!this.regexStringMatcher.matches(value, (NottableString)matcherEntry.getValue(), true) || !this.regexStringMatcher.matches(key, (NottableString)matcherEntry.getKey(), true)) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        boolean result = false;
        if (key instanceof NottableString) {
            for (NottableString keyToCompare : this.keySet()) {
                if (!this.regexStringMatcher.matches((NottableString)key, keyToCompare, true)) continue;
                result = true;
                break;
            }
        } else if (key instanceof String) {
            result = this.containsKey(NottableString.string((String)key));
        }
        return result;
    }

    @Override
    public synchronized boolean containsValue(Object value) {
        boolean result = false;
        if (value instanceof NottableString) {
            for (Map.Entry entry : this.entrySet()) {
                if (!this.regexStringMatcher.matches((NottableString)value, (NottableString)entry.getValue(), true)) continue;
                return true;
            }
        } else if (value instanceof String) {
            result = this.containsValue(NottableString.string((String)value));
        }
        return result;
    }

    @Override
    public synchronized NottableString get(Object key) {
        if (key instanceof NottableString) {
            for (Map.Entry entry : this.entrySet()) {
                if (!this.regexStringMatcher.matches((NottableString)key, (NottableString)entry.getKey(), true)) continue;
                return (NottableString)super.get(entry.getKey());
            }
        } else if (key instanceof String) {
            return this.get(NottableString.string((String)key));
        }
        return null;
    }

    @Override
    public synchronized NottableString put(NottableString key, NottableString value) {
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("value must not be null");
        }
        if (key.isOptional()) {
            this.noOptionals = false;
        }
        return super.put(key, value);
    }

    @Override
    public synchronized NottableString put(String key, String value) {
        return super.put(NottableString.string(key), NottableString.string(value));
    }

    @Override
    public synchronized NottableString remove(Object key) {
        if (key instanceof NottableString) {
            for (Map.Entry entry : this.entrySet()) {
                if (!this.regexStringMatcher.matches((NottableString)key, (NottableString)entry.getKey(), true)) continue;
                return (NottableString)super.remove(entry.getKey());
            }
        } else if (key instanceof String) {
            return this.remove(NottableString.string((String)key));
        }
        return null;
    }

    public synchronized List<ImmutableEntry> entryList() {
        if (!this.isEmpty()) {
            ArrayList<ImmutableEntry> entrySet = new ArrayList<ImmutableEntry>();
            for (Map.Entry entry : this.entrySet()) {
                entrySet.add(ImmutableEntry.entry(this.regexStringMatcher, (NottableString)entry.getKey(), (NottableString)entry.getValue()));
            }
            return entrySet;
        }
        return Collections.emptyList();
    }
}

