/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.logging;

import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.logging.LogManager;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.Version;
import org.mockserver.character.Character;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.log.model.LogEntry;
import org.mockserver.mock.HttpState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class MockServerLogger {
    private final Logger logger;
    private HttpState httpStateHandler;

    public static void configureLogger() {
        block3: {
            try {
                if (StringUtils.isNotBlank((CharSequence)ConfigurationProperties.javaLoggerLogLevel()) && System.getProperty("java.util.logging.config.file") == null && System.getProperty("java.util.logging.config.class") == null) {
                    String loggingConfiguration = "" + (!ConfigurationProperties.disableSystemOut() ? "handlers=org.mockserver.logging.StandardOutConsoleHandler" + Character.NEW_LINE : "") + "org.mockserver.logging.StandardOutConsoleHandler.level=ALL" + Character.NEW_LINE + "org.mockserver.logging.StandardOutConsoleHandler.formatter=java.util.logging.SimpleFormatter" + Character.NEW_LINE + "java.util.logging.SimpleFormatter.format=%1$tF %1$tT " + Version.getVersion() + " %3$s  %4$s  %5$s %6$s%n" + Character.NEW_LINE + "org.mockserver.level=" + ConfigurationProperties.javaLoggerLogLevel() + Character.NEW_LINE + "io.netty.handler.ssl.SslHandler.level=WARNING";
                    LogManager.getLogManager().readConfiguration(new ByteArrayInputStream(loggingConfiguration.getBytes(StandardCharsets.UTF_8)));
                }
            }
            catch (Throwable throwable) {
                if (!MockServerLogger.isEnabled(Level.ERROR)) break block3;
                new MockServerLogger().logEvent(new LogEntry().setType(LogEntry.LogMessageType.SERVER_CONFIGURATION).setLogLevel(Level.ERROR).setMessageFormat("exception while configuring Java logging - " + throwable.getMessage()).setThrowable(throwable));
            }
        }
    }

    @VisibleForTesting
    public MockServerLogger() {
        this(MockServerLogger.class);
    }

    @VisibleForTesting
    public MockServerLogger(Logger logger) {
        this.logger = logger;
        this.httpStateHandler = null;
    }

    public MockServerLogger(Class<?> loggerClass) {
        this.logger = LoggerFactory.getLogger(loggerClass);
        this.httpStateHandler = null;
    }

    public MockServerLogger(@Nullable HttpState httpStateHandler) {
        this.logger = null;
        this.httpStateHandler = httpStateHandler;
    }

    public MockServerLogger setHttpStateHandler(HttpState httpStateHandler) {
        this.httpStateHandler = httpStateHandler;
        return this;
    }

    public void logEvent(LogEntry logEntry) {
        if (logEntry.getType() == LogEntry.LogMessageType.RECEIVED_REQUEST || logEntry.getType() == LogEntry.LogMessageType.FORWARDED_REQUEST || MockServerLogger.isEnabled(logEntry.getLogLevel())) {
            if (this.httpStateHandler != null) {
                this.httpStateHandler.log(logEntry);
            } else {
                MockServerLogger.writeToSystemOut(this.logger, logEntry);
            }
        }
    }

    public static void writeToSystemOut(Logger logger, LogEntry logEntry) {
        if (!ConfigurationProperties.disableSystemOut() && MockServerLogger.isEnabled(logEntry.getLogLevel()) && StringUtils.isNotBlank((CharSequence)logEntry.getMessage())) {
            switch (logEntry.getLogLevel()) {
                case ERROR: {
                    logger.error(logEntry.getMessage(), logEntry.getThrowable());
                    break;
                }
                case WARN: {
                    logger.warn(logEntry.getMessage(), logEntry.getThrowable());
                    break;
                }
                case INFO: {
                    logger.info(logEntry.getMessage(), logEntry.getThrowable());
                    break;
                }
                case DEBUG: {
                    logger.debug(logEntry.getMessage(), logEntry.getThrowable());
                    break;
                }
                case TRACE: {
                    logger.trace(logEntry.getMessage(), logEntry.getThrowable());
                }
            }
        }
    }

    public static boolean isEnabled(Level level) {
        return ConfigurationProperties.logLevel() == null && level.toInt() >= Level.WARN.toInt() || ConfigurationProperties.logLevel() != null && level.toInt() >= ConfigurationProperties.logLevel().toInt();
    }

    static {
        MockServerLogger.configureLogger();
    }
}

